/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.prodos.ResourceFork;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class AbstractFile
implements DataSource {
    static boolean showDebugText;
    protected String name;
    public byte[] buffer;
    AssemblerProgram assembler;
    protected BufferedImage image;
    int loadAddress;
    ResourceFork resourceFork;

    public AbstractFile(String name, byte[] buffer) {
        this.name = name;
        this.buffer = buffer;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Name : " + this.name + "\n\nNo text description");
        if (this.resourceFork != null) {
            text.append("\n\nResource Fork:\n\n");
            text.append(this.resourceFork);
        }
        return text.toString();
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    public static void setDefaultDebug(boolean value) {
        showDebugText = value;
    }

    public void setResourceFork(ResourceFork resourceFork) {
        this.resourceFork = resourceFork;
    }

    public static void setDebug(boolean value) {
        showDebugText = value;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getAssembler() {
        if (this.buffer == null) {
            return "No buffer";
        }
        if (this.assembler == null) {
            this.assembler = new AssemblerProgram(this.name, this.buffer, this.loadAddress);
        }
        return this.assembler.getText();
    }

    @Override
    public String getHexDump() {
        if (this.buffer == null || this.buffer.length == 0) {
            return "No buffer";
        }
        if (this.buffer.length <= 999999) {
            return HexFormatter.format(this.buffer, 0, this.buffer.length);
        }
        System.out.println("**** truncating hex dump");
        return HexFormatter.format(this.buffer, 0, 999999);
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    String getHeader() {
        return "Name : " + this.name + "\n\n";
    }

    @Override
    public JComponent getComponent() {
        return new JPanel();
    }
}

