/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.applefile.DefaultAppleFile;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

class Header {
    static String[] typeText = new String[]{"header", "maze", "monsters", "rewards", "items", "characters", "images", "char levels"};
    static String[] scenarioNames = new String[]{"PROVING GROUNDS OF THE MAD OVERLORD!", "THE KNIGHT OF DIAMONDS", "THE LEGACY OF LLYLGAMYN"};
    static final int MAZE_AREA = 1;
    static final int MONSTER_AREA = 2;
    static final int TREASURE_TABLE_AREA = 3;
    static final int ITEM_AREA = 4;
    static final int CHARACTER_AREA = 5;
    static final int IMAGE_AREA = 6;
    static final int EXPERIENCE_AREA = 7;
    String scenarioTitle;
    public int scenarioID;
    List<ScenarioData> data = new ArrayList<ScenarioData>(8);
    FormattedDisk owner;

    public Header(DefaultMutableTreeNode dataNode, FormattedDisk owner) {
        this.owner = owner;
        AppleFileSource afs = (AppleFileSource)dataNode.getUserObject();
        List<DiskAddress> sectors = afs.getSectors();
        DefaultAppleFile daf = (DefaultAppleFile)afs.getDataSource();
        this.scenarioTitle = HexFormatter.getPascalString(daf.buffer, 0);
        while (this.scenarioID < scenarioNames.length) {
            if (scenarioNames[this.scenarioID++].equals(this.scenarioTitle)) break;
        }
        assert (this.scenarioID <= scenarioNames.length) : "Invalid scenario ID : " + this.scenarioID;
        int i = 0;
        while (i < 8) {
            this.data.add(new ScenarioData(daf.buffer, i, sectors));
            ++i;
        }
        StringBuilder text = new StringBuilder("Data type     Offset   Size  Units    ???\n------------  ------  -----  -----  -----\n");
        for (ScenarioData sd : this.data) {
            text.append(sd + "\n");
        }
        daf.setText(text.toString());
        text = new StringBuilder(String.valueOf(this.scenarioTitle) + "\n\n");
        int ptr = 106;
        while (daf.buffer[ptr] != -1) {
            text.append(String.valueOf(HexFormatter.getPascalString(daf.buffer, ptr)) + "\n");
            ptr += 10;
        }
        DefaultAppleFileSource dafs = new DefaultAppleFileSource("Header", text.toString(), owner);
        dafs.setSectors(this.data.get((int)0).sectors);
        DefaultMutableTreeNode headerNode = new DefaultMutableTreeNode(dafs);
        dataNode.add(headerNode);
        int totalBlocks = this.data.get((int)0).sectors.size();
        this.linkText("Text", this.data.get((int)0).sectors.get(0), headerNode);
        if (this.scenarioID < 3) {
            this.linkPictures("Alphabet", this.data.get((int)0).sectors.get(1), headerNode);
            this.linkPictures("Graphics", this.data.get((int)0).sectors.get(2), headerNode);
            this.linkPictures("Unknown", this.data.get((int)0).sectors.get(3), headerNode);
        }
        this.linkSpells("Mage spells", this.data.get((int)0).sectors.get(totalBlocks - 2), headerNode);
        this.linkSpells("Priest spells", this.data.get((int)0).sectors.get(totalBlocks - 1), headerNode);
    }

    private void linkText(String title, DiskAddress da, DefaultMutableTreeNode headerNode) {
        ArrayList<DiskAddress> blocks = new ArrayList<DiskAddress>();
        blocks.add(da);
        StringBuilder text = new StringBuilder(String.valueOf(this.scenarioTitle) + "\n\n");
        int ptr = 106;
        byte[] buffer = this.owner.getDisk().readSector(da);
        while (buffer[ptr] != -1) {
            text.append(String.valueOf(HexFormatter.getPascalString(buffer, ptr)) + "\n");
            ptr += 10;
        }
        ptr += 2;
        text.append("\n");
        while (ptr < 512) {
            int value = HexFormatter.intValue(buffer[ptr], buffer[ptr + 1]);
            text.append(String.format("%04X  %,6d%n", value, value));
            ptr += 2;
        }
        DefaultAppleFileSource dafs = new DefaultAppleFileSource(title, text.toString(), this.owner);
        dafs.setSectors(blocks);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(dafs);
        node.setAllowsChildren(false);
        headerNode.add(node);
    }

    private void linkPictures(String title, DiskAddress da, DefaultMutableTreeNode headerNode) {
        ArrayList<DiskAddress> blocks = new ArrayList<DiskAddress>();
        blocks.add(da);
        byte[] buffer = this.owner.getDisk().readSector(da);
        String text = this.printChars(buffer, 0);
        DefaultAppleFileSource dafs = new DefaultAppleFileSource(title, text, this.owner);
        dafs.setSectors(blocks);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(dafs);
        node.setAllowsChildren(false);
        headerNode.add(node);
    }

    private void linkSpells(String title, DiskAddress da, DefaultMutableTreeNode headerNode) {
        String[] spells;
        ArrayList<DiskAddress> blocks = new ArrayList<DiskAddress>();
        blocks.add(da);
        int level = 1;
        StringBuilder list = new StringBuilder("Level " + level + ":\n");
        byte[] buffer = this.owner.getDisk().readSector(da);
        String text = HexFormatter.getString(buffer, 0, 512);
        String[] stringArray = spells = text.split("\n");
        int n = spells.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() == 0) break;
            if (s.startsWith("*")) {
                s = s.substring(1);
                list.append("\nLevel " + ++level + ":\n");
            }
            list.append("  " + s + "\n");
            ++n2;
        }
        DefaultAppleFileSource dafs = new DefaultAppleFileSource(title, list.toString(), this.owner);
        dafs.setSectors(blocks);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(dafs);
        node.setAllowsChildren(false);
        headerNode.add(node);
    }

    private String printChars(byte[] buffer, int block) {
        StringBuilder text = new StringBuilder();
        int i = block * 512;
        while (i < (block + 1) * 512) {
            int line = 0;
            while (line < 8) {
                int j = 0;
                while (j < 8) {
                    int value = HexFormatter.intValue(buffer[i + line + j * 8]);
                    int bit = 0;
                    while (bit < 7) {
                        if ((value & 1) == 1) {
                            text.append("O");
                        } else {
                            text.append(".");
                        }
                        value >>= 1;
                        ++bit;
                    }
                    text.append("   ");
                    ++j;
                }
                text.append("\n");
                ++line;
            }
            text.append("\n");
            i += 64;
        }
        return text.toString();
    }

    class ScenarioData {
        int dunno;
        int total;
        int totalBlocks;
        int dataOffset;
        int type;
        List<DiskAddress> sectors;

        public ScenarioData(byte[] buffer, int seq, List<DiskAddress> sectors) {
            int offset = 42 + seq * 2;
            this.dunno = HexFormatter.intValue(buffer[offset]);
            this.total = HexFormatter.intValue(buffer[offset + 16]);
            this.totalBlocks = HexFormatter.intValue(buffer[offset + 32]);
            this.dataOffset = HexFormatter.intValue(buffer[offset + 48]);
            this.type = seq;
            this.sectors = new ArrayList<DiskAddress>(this.totalBlocks);
            int i = this.dataOffset;
            int max = this.dataOffset + this.totalBlocks;
            while (i < max) {
                this.sectors.add(sectors.get(i));
                ++i;
            }
        }

        public String toString() {
            return String.format("%-15s  %3d    %3d    %3d    %3d", typeText[this.type], this.dataOffset, this.totalBlocks, this.total, this.dunno);
        }
    }
}

