/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;

class ExperienceLevel
extends AbstractFile {
    private final long[] expLevels = new long[13];

    public ExperienceLevel(String name, byte[] buffer) {
        super(name, buffer);
        int seq = 0;
        int ptr = 0;
        while (ptr < buffer.length) {
            if (buffer[ptr] == 0) break;
            long points = (long)(HexFormatter.intValue(buffer[ptr], buffer[ptr + 1]) + HexFormatter.intValue(buffer[ptr + 2], buffer[ptr + 3]) * 10000) + (long)HexFormatter.intValue(buffer[ptr + 4], buffer[ptr + 5]) * 100000000L;
            this.expLevels[seq++] = points;
            ptr += 6;
        }
    }

    public long getExperiencePoints(int level) {
        if (level < 13) {
            return this.expLevels[level];
        }
        return (long)(level - 12) * this.expLevels[0] + this.expLevels[12];
    }

    @Override
    public String getText() {
        StringBuilder line = new StringBuilder();
        long[] lArray = this.expLevels;
        int n = this.expLevels.length;
        int n2 = 0;
        while (n2 < n) {
            long exp = lArray[n2];
            line.append(String.valueOf(exp) + "\n");
            ++n2;
        }
        return line.toString();
    }
}

