/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.wizardry.ExperienceLevel;
import com.bytezone.diskbrowser.wizardry.Item;
import com.bytezone.diskbrowser.wizardry.Spell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class Character
extends AbstractFile {
    private final Attributes attributes;
    private final Statistics stats;
    int scenario;
    private final Collection<Spell> spellBook = new ArrayList<Spell>();
    private final Collection<Baggage> baggageList = new ArrayList<Baggage>();
    static String[] races = new String[]{"No race", "Human", "Elf", "Dwarf", "Gnome", "Hobbit"};
    static String[] alignments = new String[]{"Unalign", "Good", "Neutral", "Evil"};
    static String[] types = new String[]{"Fighter", "Mage", "Priest", "Thief", "Bishop", "Samurai", "Lord", "Ninja"};
    static String[] statuses = new String[]{"OK", "Afraid", "Asleep", "Paralyze", "Stoned", "Dead", "Ashes", "Lost"};

    public Character(String name, byte[] buffer, int scenario) {
        super(name, buffer);
        this.scenario = scenario;
        this.attributes = new Attributes();
        this.stats = new Statistics();
        this.stats.race = races[HexFormatter.intValue(buffer[34])];
        this.stats.typeInt = HexFormatter.intValue(buffer[36]);
        this.stats.type = types[this.stats.typeInt];
        this.stats.ageInWeeks = HexFormatter.intValue(buffer[38], buffer[39]);
        this.stats.statusValue = buffer[40];
        this.stats.status = statuses[this.stats.statusValue];
        this.stats.alignment = alignments[HexFormatter.intValue(buffer[42])];
        this.stats.gold = HexFormatter.intValue(buffer[52], buffer[53]) + HexFormatter.intValue(buffer[54], buffer[55]) * 10000;
        this.stats.experience = HexFormatter.intValue(buffer[124], buffer[125]) + HexFormatter.intValue(buffer[126], buffer[127]) * 10000;
        this.stats.level = HexFormatter.intValue(buffer[132], buffer[133]);
        this.stats.hitsLeft = HexFormatter.intValue(buffer[134], buffer[135]);
        this.stats.hitsMax = HexFormatter.intValue(buffer[136], buffer[137]);
        this.stats.armourClass = buffer[176];
        this.attributes.strength = HexFormatter.intValue(buffer[44]) % 16;
        if (this.attributes.strength < 3) {
            this.attributes.strength += 16;
        }
        this.attributes.array[0] = this.attributes.strength;
        int i1 = HexFormatter.intValue(buffer[44]) / 16;
        int i2 = HexFormatter.intValue(buffer[45]) % 4;
        this.attributes.array[1] = this.attributes.intelligence = i1 / 2 + i2 * 8;
        this.attributes.array[2] = this.attributes.piety = HexFormatter.intValue(buffer[45]) / 4;
        this.attributes.vitality = HexFormatter.intValue(buffer[46]) % 16;
        if (this.attributes.vitality < 3) {
            this.attributes.vitality += 16;
        }
        this.attributes.array[3] = this.attributes.vitality;
        int a1 = HexFormatter.intValue(buffer[46]) / 16;
        int a2 = HexFormatter.intValue(buffer[47]) % 4;
        this.attributes.array[4] = this.attributes.agility = a1 / 2 + a2 * 8;
        this.attributes.array[5] = this.attributes.luck = HexFormatter.intValue(buffer[47]) / 4;
    }

    public void linkItems(List<Item> itemList) {
        int totItems = this.buffer[58];
        this.stats.assetValue = 0;
        int ptr = 60;
        while (totItems > 0) {
            int itemID = HexFormatter.intValue(this.buffer[ptr + 6]);
            if (this.scenario == 3) {
                itemID = (itemID + 24) % 256;
            }
            if (itemID >= 0 && itemID < itemList.size()) {
                Item item = itemList.get(itemID);
                boolean equipped = this.buffer[ptr] == 1;
                boolean identified = this.buffer[ptr + 4] == 1;
                this.baggageList.add(new Baggage(item, equipped, identified));
                this.stats.assetValue = (int)((long)this.stats.assetValue + item.getCost());
                ++item.partyOwns;
            } else {
                System.out.println(String.valueOf(this.name) + " ItemID : " + itemID + " is outside range 0:" + itemList.size());
            }
            ptr += 8;
            --totItems;
        }
    }

    public void linkSpells(List<Spell> spellList) {
        int i = 138;
        while (i < 145) {
            int bit = 0;
            while (bit < 8) {
                byte b = this.buffer[i];
                if ((b >>> bit & 1) == 1) {
                    int index = (i - 138) * 8 + bit;
                    if (index > 0 && index <= spellList.size()) {
                        this.spellBook.add(spellList.get(index - 1));
                    } else {
                        System.out.println(String.valueOf(this.name) + " SpellID : " + index + " is outside range 0:" + spellList.size());
                    }
                }
                ++bit;
            }
            ++i;
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Character name ..... " + this.name);
        text.append("\n\nRace ............... " + this.stats.race);
        text.append("\nType ............... " + this.stats.type);
        text.append("\nAlignment .......... " + this.stats.alignment);
        text.append("\nStatus ............. " + this.stats.status);
        text.append("\nGold ............... " + String.format("%,d", this.stats.gold));
        text.append("\nExperience ......... " + String.format("%,d", this.stats.experience));
        text.append("\nNext level ......... " + String.format("%,d", this.stats.nextLevel));
        text.append("\nLevel .............. " + this.stats.level);
        text.append("\nAge in weeks ....... " + String.format("%,d  (%d)", this.stats.ageInWeeks, this.stats.ageInWeeks / 52));
        text.append("\nHit points left .... " + this.stats.hitsLeft);
        text.append("\nMaximum hits ....... " + this.stats.hitsMax);
        text.append("\nArmour class ....... " + this.stats.armourClass);
        text.append("\nAsset value ........ " + String.format("%,d", this.stats.assetValue));
        text.append("\nAwards ............. " + this.isWinner());
        text.append("\nOut ................ " + this.isOut());
        text.append("\n\nStrength ........... " + this.attributes.strength);
        text.append("\nIntelligence ....... " + this.attributes.intelligence);
        text.append("\nPiety .............. " + this.attributes.piety);
        text.append("\nVitality ........... " + this.attributes.vitality);
        text.append("\nAgility ............ " + this.attributes.agility);
        text.append("\nLuck ............... " + this.attributes.luck);
        int[] spellPoints = this.getMageSpellPoints();
        text.append("\n\nMage spell points ..");
        int i = 0;
        while (i < spellPoints.length) {
            text.append(" " + spellPoints[i]);
            ++i;
        }
        spellPoints = this.getPriestSpellPoints();
        text.append("\nPriest spell points ");
        i = 0;
        while (i < spellPoints.length) {
            text.append(" " + spellPoints[i]);
            ++i;
        }
        text.append("\n\nSpells :");
        for (Spell s : this.spellBook) {
            text.append("\n" + s);
        }
        text.append("\n\nItems :");
        for (Baggage b : this.baggageList) {
            text.append("\n" + b);
        }
        return text.toString();
    }

    public void linkExperience(ExperienceLevel exp) {
        this.stats.nextLevel = exp.getExperiencePoints(this.stats.level);
    }

    public int[] getMageSpellPoints() {
        int[] spells = new int[7];
        int i = 0;
        while (i < 7) {
            spells[i] = this.buffer[146 + i * 2];
            ++i;
        }
        return spells;
    }

    public int[] getPriestSpellPoints() {
        int[] spells = new int[7];
        int i = 0;
        while (i < 7) {
            spells[i] = this.buffer[160 + i * 2];
            ++i;
        }
        return spells;
    }

    public Long getNextLevel() {
        return this.stats.nextLevel;
    }

    public String isWinner() {
        byte v1 = this.buffer[206];
        byte v2 = this.buffer[207];
        if (v1 == 1) {
            return ">";
        }
        if (v1 == 0 && v2 == 0) {
            return "";
        }
        if (v1 == 0 && v2 == 32) {
            return "D";
        }
        if (v1 == 32 && v2 == 32) {
            return "*D";
        }
        if (v1 == 33 && v2 == 96) {
            return ">*DG";
        }
        if (v1 == 33 && v2 == 40) {
            return ">*KD";
        }
        return "Unknown : " + v1 + " " + v2;
    }

    public boolean isOut() {
        return this.buffer[32] == 1;
    }

    public String getType() {
        return this.stats.type;
    }

    public String getRace() {
        return this.stats.race;
    }

    public String getAlignment() {
        return this.stats.alignment;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Statistics getStatistics() {
        return this.stats;
    }

    public Iterator<Baggage> getBaggage() {
        return this.baggageList.iterator();
    }

    public Iterator<Spell> getSpells() {
        return this.spellBook.iterator();
    }

    public String toString() {
        return this.name;
    }

    public class Attributes {
        public int strength;
        public int intelligence;
        public int piety;
        public int vitality;
        public int agility;
        public int luck;
        public int[] array = new int[6];
    }

    public class Baggage {
        public Item item;
        public boolean equipped;
        public boolean identified;

        public Baggage(Item item, boolean equipped, boolean identified) {
            this.item = item;
            this.equipped = equipped;
            this.identified = identified;
        }

        public String toString() {
            return String.format("%s%-15s (%d)", this.equipped ? "*" : " ", this.item.name, this.item.getCost());
        }
    }

    public class Statistics
    implements Cloneable {
        public String race;
        public String type;
        public String alignment;
        public String status;
        public int typeInt;
        public int statusValue;
        public int gold;
        public int experience;
        public long nextLevel;
        public int level;
        public int ageInWeeks;
        public int hitsLeft;
        public int hitsMax;
        public int armourClass;
        public int assetValue;
    }
}

