/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.disk.AbstractSector;

class ProdosIndexSector
extends AbstractSector {
    String name;

    ProdosIndexSector(String name, byte[] buffer) {
        super(buffer);
        this.name = name;
    }

    @Override
    public String createText() {
        StringBuilder text = this.getHeader("Prodos Index Sector : " + this.name);
        int i = 0;
        while (i < 256) {
            text.append(String.format("%02X        %02X %02X", i, this.buffer[i], this.buffer[i + 256]));
            if (this.buffer[i] != 0 || this.buffer[i + 256] != 0) {
                text.append(String.format("         %s%n", "block " + HexFormatter.intValue(this.buffer[i], this.buffer[i + 256])));
            } else {
                text.append("\n");
            }
            ++i;
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }
}

