/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.applefile.BootSector;
import com.bytezone.diskbrowser.disk.AbstractFormattedDisk;
import com.bytezone.diskbrowser.disk.AppleDisk;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.prodos.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.FileEntry;
import com.bytezone.diskbrowser.prodos.ProdosBitMapSector;
import com.bytezone.diskbrowser.prodos.ProdosCatalogSector;
import com.bytezone.diskbrowser.prodos.ProdosExtendedKeySector;
import com.bytezone.diskbrowser.prodos.ProdosIndexSector;
import com.bytezone.diskbrowser.prodos.SubDirectoryHeader;
import com.bytezone.diskbrowser.prodos.VolumeDirectoryHeader;
import java.awt.Color;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class ProdosDisk
extends AbstractFormattedDisk {
    SectorType dosSector = new SectorType("Bootstrap Loader", Color.lightGray);
    SectorType catalogSector = new SectorType("Catalog", new Color(0, 200, 0));
    SectorType volumeMapSector = new SectorType("Volume Map", Color.blue);
    SectorType subcatalogSector = new SectorType("Subcatalog", Color.magenta);
    SectorType masterIndexSector = new SectorType("Master Index", Color.orange);
    SectorType indexSector = new SectorType("Index", Color.cyan);
    SectorType dataSector = new SectorType("Data", Color.red);
    SectorType extendedKeySector = new SectorType("Extended key", Color.gray);
    List<DirectoryHeader> headerEntries = new ArrayList<DirectoryHeader>();
    VolumeDirectoryHeader vdh = null;
    static DateFormat df = DateFormat.getInstance();
    static SimpleDateFormat sdf = new SimpleDateFormat("d-MMM-yy");
    static SimpleDateFormat stf = new SimpleDateFormat("H:mm");

    public ProdosDisk(Disk disk) {
        super(disk);
        this.sectorTypesList.add(this.dosSector);
        this.sectorTypesList.add(this.catalogSector);
        this.sectorTypesList.add(this.subcatalogSector);
        this.sectorTypesList.add(this.volumeMapSector);
        this.sectorTypesList.add(this.masterIndexSector);
        this.sectorTypesList.add(this.indexSector);
        this.sectorTypesList.add(this.dataSector);
        this.sectorTypesList.add(this.extendedKeySector);
        int block = 0;
        while (block < 2) {
            if (!disk.isSectorEmpty(disk.getDiskAddress(block))) {
                this.sectorType[block] = this.dosSector;
            }
            ++block;
        }
        byte[] buffer = disk.readSector(0);
        this.bootSector = new BootSector(buffer, "Prodos");
        DefaultMutableTreeNode root = this.getCatalogTreeRoot();
        DefaultMutableTreeNode volumeNode = new DefaultMutableTreeNode("empty volume node");
        root.add(volumeNode);
        this.processDirectoryBlock(2, null, volumeNode);
        this.makeNodeVisible(volumeNode.getFirstLeaf());
        for (DiskAddress da2 : disk) {
            int blockNo = da2.getBlock();
            if (this.freeBlocks.get(blockNo)) {
                if (this.stillAvailable(da2)) continue;
                ++this.falsePositives;
                continue;
            }
            if (!this.stillAvailable(da2)) continue;
            ++this.falseNegatives;
        }
    }

    private void processDirectoryBlock(int block, FileEntry parent, DefaultMutableTreeNode parentNode) {
        byte[] sectorBuffer;
        DirectoryHeader localHeader = null;
        SectorType currentSectorType = null;
        do {
            sectorBuffer = this.disk.readSector(block);
            this.sectorType[block] = currentSectorType;
            int ptr = 4;
            int max = this.disk.getBlockSize() - 39;
            while (ptr < max) {
                int storageType = (sectorBuffer[ptr] & 0xF0) >> 4;
                if (storageType != 0) {
                    byte[] entry = new byte[39];
                    System.arraycopy(sectorBuffer, ptr, entry, 0, 39);
                    switch (storageType) {
                        case 15: {
                            assert (this.headerEntries.size() == 0);
                            this.vdh = new VolumeDirectoryHeader(this, entry);
                            localHeader = this.vdh;
                            assert (localHeader.entryLength == 39);
                            this.headerEntries.add(localHeader);
                            this.sectorType[block] = currentSectorType = this.catalogSector;
                            int i = 0;
                            while (i < this.vdh.totalBitMapBlocks) {
                                this.sectorType[this.vdh.bitMapBlock + i] = this.volumeMapSector;
                                ++i;
                            }
                            parentNode.setUserObject(this.vdh);
                            break;
                        }
                        case 14: {
                            localHeader = new SubDirectoryHeader(this, entry, parent);
                            this.headerEntries.add(localHeader);
                            this.sectorType[block] = currentSectorType = this.subcatalogSector;
                            break;
                        }
                        case 13: {
                            FileEntry ce = new FileEntry(this, entry, localHeader, block);
                            this.fileEntries.add(ce);
                            DefaultMutableTreeNode directoryNode = new DefaultMutableTreeNode(ce);
                            directoryNode.setAllowsChildren(true);
                            parentNode.add(directoryNode);
                            this.processDirectoryBlock(ce.keyPtr, ce, directoryNode);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            FileEntry fe = new FileEntry(this, entry, localHeader, block);
                            this.fileEntries.add(fe);
                            DefaultMutableTreeNode node = new DefaultMutableTreeNode(fe);
                            node.setAllowsChildren(false);
                            parentNode.add(node);
                            break;
                        }
                        default: {
                            System.out.println("Unknown storage type : " + storageType);
                            System.out.println(HexFormatter.format(entry, 0, entry.length));
                        }
                    }
                }
                ptr += 39;
            }
        } while ((block = HexFormatter.intValue(sectorBuffer[2], sectorBuffer[3])) > 0);
    }

    public static boolean isCorrectFormat(AppleDisk disk) {
        disk.setInterleave(1);
        if (ProdosDisk.checkFormat(disk)) {
            return true;
        }
        disk.setInterleave(0);
        return ProdosDisk.checkFormat(disk);
    }

    public static boolean checkFormat(AppleDisk disk) {
        byte[] buffer = disk.readSector(2);
        if (buffer[35] != 39 || buffer[36] != 13) {
            return false;
        }
        int bitMapBlock = HexFormatter.intValue(buffer[39], buffer[40]);
        return bitMapBlock == 6;
    }

    public DataSource getFile(int fileNo) {
        if (fileNo == 0) {
            return ((VolumeDirectoryHeader)this.headerEntries.get(0)).getDataSource();
        }
        return ((AppleFileSource)this.fileEntries.get(fileNo - 1)).getDataSource();
    }

    @Override
    public AppleFileSource getCatalog() {
        return new DefaultAppleFileSource("Catalog", this.headerEntries.get(0).getDataSource(), (FormattedDisk)this);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        String newLine = String.format("%n", new Object[0]);
        VolumeDirectoryHeader volumeDirectory = (VolumeDirectoryHeader)this.headerEntries.get(0);
        String timeC = volumeDirectory.created == null ? "" : df.format(volumeDirectory.created.getTime());
        text.append("Volume name        : " + volumeDirectory.name + newLine);
        text.append("Creation date      : " + timeC + newLine);
        text.append("ProDOS version     : " + volumeDirectory.version + newLine);
        text.append("Min ProDOS version : " + volumeDirectory.minVersion + newLine);
        text.append("Access rights      : " + volumeDirectory.access + newLine);
        text.append("Entry length       : " + volumeDirectory.entryLength + newLine);
        text.append("Entries per block  : " + volumeDirectory.entriesPerBlock + newLine);
        text.append("File count         : " + volumeDirectory.fileCount + newLine);
        text.append("Bitmap block       : " + volumeDirectory.bitMapBlock + newLine);
        text.append("Total blocks       : " + volumeDirectory.totalBlocks + newLine);
        return text.toString();
    }

    @Override
    public DataSource getFormattedSector(DiskAddress da) {
        if (da.getBlock() == 0) {
            return this.bootSector;
        }
        byte[] buffer = this.disk.readSector(da);
        SectorType type = this.sectorType[da.getBlock()];
        if (type == this.catalogSector || type == this.subcatalogSector) {
            return new ProdosCatalogSector(buffer);
        }
        if (type == this.volumeMapSector) {
            return new ProdosBitMapSector(this, buffer, da);
        }
        if (type == this.masterIndexSector || type == this.indexSector) {
            return new ProdosIndexSector(this.getSectorFilename(da), buffer);
        }
        if (type == this.extendedKeySector) {
            return new ProdosExtendedKeySector(buffer);
        }
        if (type == this.emptySector) {
            return new DefaultSector("Empty sector", buffer);
        }
        if (type == this.usedSector) {
            return new DefaultSector("Orphan sector", buffer);
        }
        if (type == this.dosSector) {
            return new DefaultSector("Boot sector", buffer);
        }
        return new DefaultSector("Data sector : " + this.getSectorFilename(da), buffer);
    }

    @Override
    public String getSectorFilename(DiskAddress da) {
        for (AppleFileSource fe : this.fileEntries) {
            if (!((FileEntry)fe).contains(da)) continue;
            return ((FileEntry)fe).name;
        }
        return null;
    }

    @Override
    public List<DiskAddress> getFileSectors(int fileNo) {
        if (fileNo == 0) {
            return ((VolumeDirectoryHeader)this.headerEntries.get(0)).getSectors();
        }
        return ((AppleFileSource)this.fileEntries.get(fileNo - 1)).getSectors();
    }
}

