/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.prodos.ProdosConstants;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import java.util.GregorianCalendar;

class ProdosDirectory
extends AbstractFile {
    private static final String NO_DATE = "<NO DATE>";
    private static final String newLine = String.format("%n", new Object[0]);
    private static final String newLine2 = String.valueOf(newLine) + newLine;
    private final Disk parent;
    private final int totalBlocks;
    private final int freeBlocks;
    private final int usedBlocks;

    public ProdosDirectory(Disk parent, String name, byte[] buffer, int totalBlocks, int freeBlocks, int usedBlocks) {
        super(name, buffer);
        this.parent = parent;
        this.totalBlocks = totalBlocks;
        this.freeBlocks = freeBlocks;
        this.usedBlocks = usedBlocks;
    }

    @Override
    public String getText() {
        StringBuffer text = new StringBuffer();
        text.append("Disk : " + this.parent.getFile().getAbsolutePath() + newLine2);
        int i = 0;
        while (i < this.buffer.length) {
            int storageType = (this.buffer[i] & 0xF0) >> 4;
            if (storageType != 0) {
                int nameLength = this.buffer[i] & 0xF;
                String filename = HexFormatter.getString(this.buffer, i + 1, nameLength);
                String subType = "";
                switch (storageType) {
                    case 14: 
                    case 15: {
                        text.append("/" + filename + newLine2);
                        text.append(" NAME           TYPE  BLOCKS  MODIFIED         CREATED          ENDFILE SUBTYPE" + newLine2);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 13: {
                        int type = HexFormatter.intValue(this.buffer[i + 16]);
                        int blocks = HexFormatter.intValue(this.buffer[i + 19], this.buffer[i + 20]);
                        GregorianCalendar created = HexFormatter.getAppleDate(this.buffer, i + 24);
                        String dateC = created == null ? NO_DATE : ProdosDisk.sdf.format(created.getTime()).toUpperCase();
                        String timeC = created == null ? "" : ProdosDisk.stf.format(created.getTime());
                        GregorianCalendar modified = HexFormatter.getAppleDate(this.buffer, i + 33);
                        String dateM = modified == null ? NO_DATE : ProdosDisk.sdf.format(modified.getTime()).toUpperCase();
                        String timeM = modified == null ? "" : ProdosDisk.stf.format(modified.getTime());
                        int eof = HexFormatter.intValue(this.buffer[i + 21], this.buffer[i + 22], this.buffer[i + 23]);
                        int fileType = HexFormatter.intValue(this.buffer[i + 16]);
                        String locked = (this.buffer[i + 30] & 0xE0) == 224 ? " " : "*";
                        switch (fileType) {
                            case 4: {
                                int aux = HexFormatter.intValue(this.buffer[i + 31], this.buffer[i + 32]);
                                subType = String.format("R=%5d", aux);
                                break;
                            }
                            case 6: {
                                int aux = HexFormatter.intValue(this.buffer[i + 31], this.buffer[i + 32]);
                                subType = String.format("A=$%4X", aux);
                                break;
                            }
                            case 26: {
                                int aux = HexFormatter.intValue(this.buffer[i + 32], this.buffer[i + 31]);
                                if (aux == 0) break;
                                filename = this.convert(filename, aux);
                                break;
                            }
                            default: {
                                subType = "";
                            }
                        }
                        text.append(String.format("%s%-15s %3s   %5d  %9s %5s  %9s %5s %8d %7s%n", locked, filename, ProdosConstants.fileTypes[type], blocks, dateM, timeM, dateC, timeC, eof, subType));
                        break;
                    }
                    default: {
                        text.append(" <Unknown strage type : " + storageType + newLine);
                    }
                }
            }
            i += 39;
        }
        text.append(String.format("%nBLOCKS FREE:%5d     BLOCKS USED:%5d     TOTAL BLOCKS:%5d%n", this.freeBlocks, this.usedBlocks, this.totalBlocks));
        return text.toString();
    }

    private String convert(String name, int flags) {
        char[] newName = name.toCharArray();
        int i = 0;
        int weight = 32768;
        while (i < 16) {
            if ((flags & weight) != 0) {
                if (newName[i] == '.') {
                    newName[i] = 32;
                } else if (newName[i] >= 'A' && newName[i] <= 'Z') {
                    int n = i;
                    newName[n] = (char)(newName[n] + 32);
                }
            }
            ++i;
            weight >>>= 1;
        }
        return new String(newName);
    }
}

