/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.ApplesoftBasicProgram;
import com.bytezone.diskbrowser.applefile.AppleworksWPFile;
import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.applefile.DefaultAppleFile;
import com.bytezone.diskbrowser.applefile.HiResImage;
import com.bytezone.diskbrowser.applefile.IntegerBasicProgram;
import com.bytezone.diskbrowser.applefile.ShapeTable;
import com.bytezone.diskbrowser.applefile.SimpleText;
import com.bytezone.diskbrowser.applefile.StoredVariables;
import com.bytezone.diskbrowser.applefile.TextBuffer;
import com.bytezone.diskbrowser.applefile.TextFile;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.prodos.CatalogEntry;
import com.bytezone.diskbrowser.prodos.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.ProdosConstants;
import com.bytezone.diskbrowser.prodos.ProdosDirectory;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import com.bytezone.diskbrowser.prodos.VolumeDirectoryHeader;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

class FileEntry
extends CatalogEntry
implements ProdosConstants {
    int fileType;
    int keyPtr;
    int blocksUsed;
    int endOfFile;
    int auxType;
    GregorianCalendar modified;
    int headerPointer;
    DataSource file;
    DiskAddress catalogBlock;
    DiskAddress masterIndexBlock;
    List<DiskAddress> indexBlocks = new ArrayList<DiskAddress>();
    boolean invalid;

    public FileEntry(ProdosDisk fDisk, byte[] entryBuffer, DirectoryHeader parent, int parentBlock) {
        super(fDisk, entryBuffer);
        this.parentDirectory = parent;
        this.catalogBlock = this.disk.getDiskAddress(parentBlock);
        this.fileType = entryBuffer[16] & 0xFF;
        this.keyPtr = HexFormatter.intValue(entryBuffer[17], entryBuffer[18]);
        this.blocksUsed = HexFormatter.intValue(entryBuffer[19], entryBuffer[20]);
        this.endOfFile = HexFormatter.intValue(entryBuffer[21], entryBuffer[22], entryBuffer[23]);
        this.auxType = HexFormatter.intValue(entryBuffer[31], entryBuffer[32]);
        this.modified = HexFormatter.getAppleDate(entryBuffer, 33);
        this.headerPointer = HexFormatter.intValue(entryBuffer[37], entryBuffer[38]);
        switch (this.storageType) {
            case 1: {
                this.parentDisk.setSectorType(this.keyPtr, fDisk.dataSector);
                this.dataBlocks.add(this.disk.getDiskAddress(this.keyPtr));
                break;
            }
            case 2: {
                if (this.isGEOSFile()) {
                    this.traverseGEOSIndex(this.keyPtr);
                    break;
                }
                this.traverseIndex(this.keyPtr);
                break;
            }
            case 3: {
                this.parentDisk.setSectorType(this.keyPtr, fDisk.masterIndexSector);
                this.masterIndexBlock = this.disk.getDiskAddress(this.keyPtr);
                if (this.isGEOSFile()) {
                    this.traverseGEOSMasterIndex(this.keyPtr);
                    break;
                }
                this.traverseMasterIndex(this.keyPtr);
                break;
            }
            case 5: {
                this.parentDisk.setSectorType(this.keyPtr, fDisk.extendedKeySector);
                this.indexBlocks.add(this.disk.getDiskAddress(this.keyPtr));
                byte[] buffer2 = this.disk.readSector(this.keyPtr);
                int i = 0;
                while (i < 512) {
                    int storageType = buffer2[i] & 0xF;
                    int keyBlock = HexFormatter.intValue(buffer2[i + 1], buffer2[i + 2]);
                    switch (storageType) {
                        case 1: {
                            this.parentDisk.setSectorType(keyBlock, fDisk.dataSector);
                            this.dataBlocks.add(this.disk.getDiskAddress(keyBlock));
                            break;
                        }
                        case 2: {
                            this.traverseIndex(keyBlock);
                            break;
                        }
                        default: {
                            System.out.println("fork not a sapling or seedling!!!");
                        }
                    }
                    i += 256;
                }
                break;
            }
            case 13: {
                byte[] buffer;
                int block = this.keyPtr;
                do {
                    this.dataBlocks.add(this.disk.getDiskAddress(block));
                } while ((block = HexFormatter.intValue((buffer = this.disk.readSector(block))[2], buffer[3])) > 0);
            }
        }
    }

    private boolean isGEOSFile() {
        return (this.fileType & 0xF0) == 128;
    }

    private void removeEmptyBlocks() {
        while (this.dataBlocks.size() > 0) {
            DiskAddress da = (DiskAddress)this.dataBlocks.get(this.dataBlocks.size() - 1);
            if (da.getBlock() != 0) break;
            this.dataBlocks.remove(this.dataBlocks.size() - 1);
        }
    }

    private void traverseMasterIndex(int keyPtr) {
        int block;
        byte[] buffer = this.disk.readSector(keyPtr);
        int highestBlock = 0;
        int i = 127;
        while (i >= 0) {
            block = HexFormatter.intValue(buffer[i], buffer[i + 256]);
            if (block > 0) {
                highestBlock = i;
                break;
            }
            --i;
        }
        i = 0;
        while (i <= highestBlock) {
            block = HexFormatter.intValue(buffer[i], buffer[i + 256]);
            if (block != 0) {
                this.traverseIndex(block);
            } else {
                DiskAddress da = this.disk.getDiskAddress(0);
                int j = 0;
                while (j < 256) {
                    this.dataBlocks.add(da);
                    ++j;
                }
            }
            ++i;
        }
        this.removeEmptyBlocks();
    }

    private void traverseIndex(int keyBlock) {
        this.parentDisk.setSectorType(keyBlock, ((ProdosDisk)this.parentDisk).indexSector);
        this.indexBlocks.add(this.disk.getDiskAddress(keyBlock));
        byte[] buffer = this.disk.readSector(keyBlock);
        int i = 0;
        while (i < 256) {
            int block = HexFormatter.intValue(buffer[i], buffer[i + 256]);
            if (!this.disk.isValidAddress(block)) {
                System.out.println("Invalid block in " + this.name + " : " + block);
                this.invalid = true;
                break;
            }
            if (block == 0 && (this.fileType != 4 || this.auxType <= 0)) break;
            if (block != 0) {
                this.parentDisk.setSectorType(block, ((ProdosDisk)this.parentDisk).dataSector);
                this.dataBlocks.add(this.disk.getDiskAddress(block));
            }
            ++i;
        }
    }

    private void traverseGEOSMasterIndex(int keyPtr) {
        byte[] buffer = this.disk.readSector(keyPtr);
        int i = 0;
        while (i < 128) {
            int block = HexFormatter.intValue(buffer[i], buffer[i + 256]);
            if (block == 0) break;
            if (block != 65535) {
                this.traverseGEOSIndex(block);
            }
            ++i;
        }
    }

    private void traverseGEOSIndex(int keyPtr) {
        this.parentDisk.setSectorType(keyPtr, ((ProdosDisk)this.parentDisk).indexSector);
        this.indexBlocks.add(this.disk.getDiskAddress(keyPtr));
        byte[] buffer = this.disk.readSector(keyPtr);
        int i = 0;
        while (i < 128) {
            int block = HexFormatter.intValue(buffer[i], buffer[i + 256]);
            if (block == 0) break;
            if (block != 65535) {
                this.parentDisk.setSectorType(block, ((ProdosDisk)this.parentDisk).dataSector);
                this.dataBlocks.add(this.disk.getDiskAddress(block));
            }
            ++i;
        }
    }

    @Override
    public DataSource getDataSource() {
        if (this.file != null) {
            return this.file;
        }
        if (this.invalid) {
            this.file = new DefaultAppleFile(this.name, null);
            return this.file;
        }
        if (this.fileType == 4 && this.auxType > 0) {
            switch (this.storageType) {
                case 3: {
                    return this.getTreeTextFile();
                }
                case 2: {
                    return this.getSaplingTextFile();
                }
                case 1: {
                    return this.getSeedlingTextFile();
                }
            }
        }
        byte[] buffer = this.isGEOSFile() ? this.getGEOSBuffer() : this.getBuffer();
        byte[] exactBuffer = this.getExactBuffer(buffer);
        switch (this.fileType) {
            case 6: 
            case 254: 
            case 255: {
                if (ShapeTable.isShapeTable(exactBuffer)) {
                    this.file = new ShapeTable(this.name, exactBuffer);
                    break;
                }
                if (SimpleText.isHTML(exactBuffer)) {
                    this.file = new SimpleText(this.name, exactBuffer);
                    break;
                }
                if (HiResImage.isGif(exactBuffer)) {
                    this.file = new HiResImage(this.name, exactBuffer);
                    break;
                }
                if (!(this.endOfFile != 8184 && this.endOfFile != 8191 && this.endOfFile != 8192 && this.endOfFile != 16384 || this.auxType != 8191 && this.auxType != 8192 && this.auxType != 16384)) {
                    this.file = new HiResImage(this.name, exactBuffer);
                    break;
                }
                this.file = new AssemblerProgram(this.name, exactBuffer, this.auxType);
                break;
            }
            case 4: {
                assert (this.auxType == 0);
                this.file = new TextFile(this.name, exactBuffer, this.auxType, this.endOfFile);
                break;
            }
            case 252: {
                this.file = new ApplesoftBasicProgram(this.name, exactBuffer);
                break;
            }
            case 250: {
                this.file = new IntegerBasicProgram(this.name, exactBuffer);
                break;
            }
            case 15: {
                VolumeDirectoryHeader vdh = ((ProdosDisk)this.parentDisk).vdh;
                this.file = new ProdosDirectory(this.disk, this.name, buffer, vdh.totalBlocks, vdh.freeBlocks, vdh.usedBlocks);
                break;
            }
            case 253: {
                if (this.endOfFile == 0) {
                    System.out.println("Stored Variables EOF = 0");
                    this.file = new StoredVariables(this.name, buffer);
                    break;
                }
                this.file = new StoredVariables(this.name, exactBuffer);
                break;
            }
            case 226: {
                this.file = new DefaultAppleFile(String.valueOf(this.name) + " (Appletalk file)", buffer);
                break;
            }
            case 26: {
                this.file = new AppleworksWPFile(String.valueOf(this.name) + " (Appleworks Word Processor)", buffer);
                break;
            }
            case 176: {
                this.file = new SimpleText(this.name, exactBuffer);
                break;
            }
            default: {
                System.out.println("Unknown file type : " + this.fileType);
                this.file = new DefaultAppleFile(this.name, exactBuffer);
            }
        }
        return this.file;
    }

    private byte[] getExactBuffer(byte[] buffer) {
        byte[] exactBuffer;
        if (buffer.length < this.endOfFile) {
            exactBuffer = new byte[buffer.length];
            System.arraycopy(buffer, 0, exactBuffer, 0, buffer.length);
        } else if (buffer.length == this.endOfFile) {
            exactBuffer = buffer;
        } else {
            exactBuffer = new byte[this.endOfFile];
            System.arraycopy(buffer, 0, exactBuffer, 0, this.endOfFile);
        }
        return exactBuffer;
    }

    private TextFile getTreeTextFile() {
        ArrayList<TextBuffer> buffers = new ArrayList<TextBuffer>();
        ArrayList<DiskAddress> addresses = new ArrayList<DiskAddress>();
        int logicalBlock = 0;
        byte[] mainIndexBuffer = this.disk.readSector(this.keyPtr);
        int i = 0;
        while (i < 256) {
            int indexBlock = HexFormatter.intValue(mainIndexBuffer[i], mainIndexBuffer[i + 256]);
            if (indexBlock > 0) {
                logicalBlock = this.readIndexBlock(indexBlock, addresses, buffers, logicalBlock);
            } else {
                if (addresses.size() > 0) {
                    byte[] tempBuffer = this.disk.readSectors(addresses);
                    buffers.add(new TextBuffer(tempBuffer, this.auxType, logicalBlock - addresses.size()));
                    addresses.clear();
                }
                logicalBlock += 256;
            }
            ++i;
        }
        return new TextFile(this.name, buffers, this.auxType, this.endOfFile);
    }

    private TextFile getSaplingTextFile() {
        ArrayList<TextBuffer> buffers = new ArrayList<TextBuffer>();
        ArrayList<DiskAddress> addresses = new ArrayList<DiskAddress>();
        this.readIndexBlock(this.keyPtr, addresses, buffers, 0);
        return new TextFile(this.name, buffers, this.auxType, this.endOfFile);
    }

    private TextFile getSeedlingTextFile() {
        byte[] buffer = this.getBuffer();
        if (this.endOfFile < buffer.length) {
            byte[] exactBuffer = new byte[this.endOfFile];
            System.arraycopy(buffer, 0, exactBuffer, 0, this.endOfFile);
            return new TextFile(this.name, exactBuffer, this.auxType, this.endOfFile);
        }
        return new TextFile(this.name, buffer, this.auxType, this.endOfFile);
    }

    private byte[] getBuffer() {
        switch (this.storageType) {
            case 1: 
            case 2: 
            case 3: {
                return this.disk.readSectors(this.dataBlocks);
            }
            case 5: {
                return this.disk.readSectors(this.dataBlocks);
            }
            case 13: {
                byte[] fullBuffer = new byte[this.dataBlocks.size() * 507];
                int offset = 0;
                for (DiskAddress da : this.dataBlocks) {
                    byte[] buffer = this.disk.readSector(da);
                    System.arraycopy(buffer, 4, fullBuffer, offset, 507);
                    offset += 507;
                }
                return fullBuffer;
            }
        }
        System.out.println("Unknown storage type in getBuffer : " + this.storageType);
        return new byte[512];
    }

    private byte[] getGEOSBuffer() {
        switch (this.storageType) {
            case 1: {
                System.out.println("Seedling GEOS file : " + this.name);
                return this.disk.readSectors(this.dataBlocks);
            }
            case 2: {
                return this.getIndexFile(this.keyPtr);
            }
            case 3: {
                return this.getMasterIndexFile(this.keyPtr);
            }
        }
        System.out.println("Unknown storage type for GEOS file : " + this.storageType);
        return new byte[512];
    }

    private byte[] getMasterIndexFile(int keyPtr) {
        byte[] buffer = this.disk.readSector(keyPtr);
        int length = HexFormatter.intValue(buffer[255], buffer[511]);
        byte[] fileBuffer = new byte[length];
        int ptr = 0;
        int i = 0;
        while (i < 128) {
            int block = HexFormatter.intValue(buffer[i], buffer[i + 256]);
            if (block == 0) break;
            if (block != 65535) {
                byte[] temp = this.getIndexFile(block);
                System.arraycopy(temp, 0, fileBuffer, ptr, temp.length);
                ptr += temp.length;
            }
            ++i;
        }
        return fileBuffer;
    }

    private byte[] getIndexFile(int keyPtr) {
        byte[] buffer = this.disk.readSector(keyPtr);
        int length = HexFormatter.intValue(buffer[255], buffer[511]);
        byte[] fileBuffer = new byte[length];
        int i = 0;
        while (i < 128) {
            int block = HexFormatter.intValue(buffer[i], buffer[i + 256]);
            if (block == 0) break;
            if (block != 65535) {
                byte[] temp = this.disk.readSector(block);
                System.arraycopy(temp, 0, fileBuffer, i * 512, length > 512 ? 512 : length);
                length -= 512;
            }
            ++i;
        }
        return fileBuffer;
    }

    private int readIndexBlock(int indexBlock, List<DiskAddress> addresses, List<TextBuffer> buffers, int logicalBlock) {
        byte[] indexBuffer = this.disk.readSector(indexBlock);
        int j = 0;
        while (j < 256) {
            int block = HexFormatter.intValue(indexBuffer[j], indexBuffer[j + 256]);
            if (block > 0) {
                addresses.add(this.disk.getDiskAddress(block));
            } else if (addresses.size() > 0) {
                byte[] tempBuffer = this.disk.readSectors(addresses);
                buffers.add(new TextBuffer(tempBuffer, this.auxType, logicalBlock - addresses.size()));
                addresses.clear();
            }
            ++logicalBlock;
            ++j;
        }
        return logicalBlock;
    }

    @Override
    public List<DiskAddress> getSectors() {
        ArrayList<DiskAddress> sectors = new ArrayList<DiskAddress>();
        sectors.add(this.catalogBlock);
        if (this.masterIndexBlock != null) {
            sectors.add(this.masterIndexBlock);
        }
        sectors.addAll(this.indexBlocks);
        sectors.addAll(this.dataBlocks);
        return sectors;
    }

    public boolean contains(DiskAddress da) {
        if (da.equals(this.masterIndexBlock)) {
            return true;
        }
        for (DiskAddress block : this.indexBlocks) {
            if (block.compareTo(da) != 0) continue;
            return true;
        }
        for (DiskAddress block : this.dataBlocks) {
            if (block.compareTo(da) != 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (ProdosConstants.fileTypes[this.fileType].equals("DIR")) {
            return this.name;
        }
        String locked = this.access == 0 ? "*" : " ";
        return String.valueOf(String.format("%s  %03d %s", ProdosConstants.fileTypes[this.fileType], this.blocksUsed, locked)) + this.name;
    }
}

