/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.pascal;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.applefile.BootSector;
import com.bytezone.diskbrowser.applefile.Charset;
import com.bytezone.diskbrowser.applefile.DefaultAppleFile;
import com.bytezone.diskbrowser.applefile.PascalCode;
import com.bytezone.diskbrowser.applefile.PascalInfo;
import com.bytezone.diskbrowser.applefile.PascalSegment;
import com.bytezone.diskbrowser.applefile.PascalText;
import com.bytezone.diskbrowser.applefile.WizardryTitle;
import com.bytezone.diskbrowser.disk.AbstractFormattedDisk;
import com.bytezone.diskbrowser.disk.AppleDisk;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.pascal.PascalCatalogSector;
import java.awt.Color;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class PascalDisk
extends AbstractFormattedDisk {
    static final int CATALOG_ENTRY_SIZE = 26;
    private static DateFormat df = DateFormat.getDateInstance(3);
    private final VolumeEntry volume;
    private final PascalCatalogSector diskCatalogSector;
    private final String[] fileTypes = new String[]{"Volume", "Xdsk", "Code", "Text", "Info", "Data", "Graf", "Foto", "SecureDir"};
    SectorType diskBootSector = new SectorType("Boot", Color.lightGray);
    SectorType catalogSector = new SectorType("Catalog", Color.magenta);
    SectorType dataSector = new SectorType("Data", new Color(0, 200, 0));
    SectorType codeSector = new SectorType("Code", Color.red);
    SectorType textSector = new SectorType("Text", Color.blue);
    SectorType infoSector = new SectorType("Info", Color.orange);
    SectorType grafSector = new SectorType("Graf", Color.cyan);
    SectorType fotoSector = new SectorType("Foto", Color.gray);

    public PascalDisk(Disk disk) {
        super(disk);
        this.sectorTypesList.add(this.diskBootSector);
        this.sectorTypesList.add(this.catalogSector);
        this.sectorTypesList.add(this.dataSector);
        this.sectorTypesList.add(this.codeSector);
        this.sectorTypesList.add(this.textSector);
        this.sectorTypesList.add(this.infoSector);
        this.sectorTypesList.add(this.grafSector);
        this.sectorTypesList.add(this.fotoSector);
        List<DiskAddress> blocks = disk.getDiskAddressList(0, 1);
        byte[] buffer = disk.readSectors(blocks);
        this.bootSector = new BootSector(buffer, "Pascal");
        buffer = disk.readSector(2);
        byte[] data = new byte[26];
        System.arraycopy(buffer, 0, data, 0, 26);
        this.volume = new VolumeEntry(data);
        this.sectorType[0] = this.diskBootSector;
        this.sectorType[1] = this.diskBootSector;
        int i = 2;
        while (i < 280) {
            this.freeBlocks.set(i, true);
            ++i;
        }
        ArrayList<DiskAddress> sectors = new ArrayList<DiskAddress>();
        int i2 = 2;
        while (i2 < this.volume.lastBlock) {
            DiskAddress da = disk.getDiskAddress(i2);
            if (!disk.isSectorEmpty(da)) {
                this.sectorType[i2] = this.catalogSector;
            }
            sectors.add(da);
            this.freeBlocks.set(i2, false);
            ++i2;
        }
        buffer = disk.readSectors(sectors);
        this.diskCatalogSector = new PascalCatalogSector(buffer);
        DefaultMutableTreeNode root = this.getCatalogTreeRoot();
        DefaultMutableTreeNode volumeNode = new DefaultMutableTreeNode(this.volume);
        root.add(volumeNode);
        ArrayList<DiskAddress> addresses = new ArrayList<DiskAddress>();
        int i3 = 2;
        while (i3 < this.volume.lastBlock) {
            addresses.add(disk.getDiskAddress(i3));
            ++i3;
        }
        buffer = disk.readSectors(addresses);
        i3 = 1;
        while (i3 <= this.volume.totalFiles) {
            int ptr = i3 * 26;
            data = new byte[26];
            System.arraycopy(buffer, ptr, data, 0, 26);
            FileEntry fe = new FileEntry(data);
            this.fileEntries.add(fe);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(fe);
            if (fe.fileType == 2) {
                node.setAllowsChildren(true);
                PascalCode pc = (PascalCode)fe.getDataSource();
                for (PascalSegment ps : pc) {
                    DefaultMutableTreeNode segmentNode = new DefaultMutableTreeNode(new PascalCodeObject(ps, fe.firstBlock));
                    node.add(segmentNode);
                    segmentNode.setAllowsChildren(false);
                }
            } else {
                node.setAllowsChildren(false);
            }
            volumeNode.add(node);
            int j = fe.firstBlock;
            while (j < fe.lastBlock) {
                this.freeBlocks.set(i3, false);
                ++j;
            }
            ++i3;
        }
        volumeNode.setUserObject(this.getCatalog());
        this.makeNodeVisible(volumeNode.getFirstLeaf());
    }

    public static boolean isCorrectFormat(AppleDisk disk, boolean debug) {
        disk.setInterleave(1);
        if (PascalDisk.checkFormat(disk, debug)) {
            return true;
        }
        disk.setInterleave(0);
        return PascalDisk.checkFormat(disk, debug);
    }

    public static boolean checkFormat(AppleDisk disk, boolean debug) {
        byte[] buffer = disk.readSector(2);
        int nameLength = HexFormatter.intValue(buffer[6]);
        if (nameLength < 1 || nameLength > 7) {
            if (debug) {
                System.out.println("bad name length : " + nameLength);
            }
            return false;
        }
        if (debug) {
            String name = HexFormatter.getPascalString(buffer, 6);
            System.out.println("Name ok : " + name);
        }
        int from = HexFormatter.intValue(buffer[0], buffer[1]);
        int to = HexFormatter.intValue(buffer[2], buffer[3]);
        if (from != 0 || to != 6) {
            return false;
        }
        ArrayList<DiskAddress> addresses = new ArrayList<DiskAddress>();
        int i = 2;
        while (i < to) {
            addresses.add(disk.getDiskAddress(i));
            ++i;
        }
        buffer = disk.readSectors(addresses);
        int blocks = HexFormatter.intValue(buffer[14], buffer[15]);
        if (blocks > 280) {
            return false;
        }
        int files = HexFormatter.intValue(buffer[16], buffer[17]);
        if (files < 0 || files > 77) {
            return false;
        }
        if (debug) {
            System.out.println("Files found : " + files);
        }
        int i2 = 1;
        while (i2 <= files) {
            int ptr = i2 * 26;
            int a = HexFormatter.intValue(buffer[ptr], buffer[ptr + 1]);
            int b = HexFormatter.intValue(buffer[ptr + 2], buffer[ptr + 3]);
            int c = HexFormatter.intValue(buffer[ptr + 4], buffer[ptr + 5]);
            if (b < a) {
                return false;
            }
            if (c == 0) {
                return false;
            }
            nameLength = HexFormatter.intValue(buffer[ptr + 6]);
            if (nameLength < 1 || nameLength > 15) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    @Override
    public DataSource getFormattedSector(DiskAddress da) {
        SectorType st = this.sectorType[da.getBlock()];
        if (st == this.diskBootSector) {
            return this.bootSector;
        }
        if (st == this.catalogSector) {
            return this.diskCatalogSector;
        }
        byte[] buffer = this.disk.readSector(da);
        if (st == this.codeSector) {
            return new DefaultSector("Code sector : " + this.getSectorFilename(da), buffer);
        }
        if (st == this.dataSector) {
            return new DefaultSector("Data sector : " + this.getSectorFilename(da), buffer);
        }
        return new DefaultSector(this.getSectorFilename(da), buffer);
    }

    @Override
    public String getSectorFilename(DiskAddress da) {
        for (AppleFileSource ce : this.fileEntries) {
            if (!((CatalogEntry)ce).contains(da)) continue;
            return ((CatalogEntry)ce).name;
        }
        return null;
    }

    @Override
    public List<DiskAddress> getFileSectors(int fileNo) {
        if (fileNo < 0 || fileNo >= this.fileEntries.size()) {
            return null;
        }
        return ((AppleFileSource)this.fileEntries.get(fileNo)).getSectors();
    }

    public DataSource getFile(int fileNo) {
        if (fileNo < 0 || fileNo >= this.fileEntries.size()) {
            return null;
        }
        return ((AppleFileSource)this.fileEntries.get(fileNo)).getDataSource();
    }

    @Override
    public AppleFileSource getCatalog() {
        String newLine = String.format("%n", new Object[0]);
        String newLine2 = String.valueOf(newLine) + newLine;
        String line = "----   ---------------   ----   --------  -------   ----   ----" + newLine;
        String date = this.volume.date == null ? "--" : df.format(this.volume.date.getTime());
        StringBuilder text = new StringBuilder();
        text.append("Disk : " + this.disk.getFile().getAbsolutePath() + newLine2);
        text.append("Volume : " + this.volume.name + newLine);
        text.append("Date   : " + date + newLine2);
        text.append("Blks   Name              Type     Date     Length   Frst   Last" + newLine);
        text.append(line);
        int usedBlocks = 6;
        for (AppleFileSource fe : this.fileEntries) {
            FileEntry ce = (FileEntry)fe;
            int size = ce.lastBlock - ce.firstBlock;
            usedBlocks += size;
            date = ce.date == null ? "--" : df.format(ce.date.getTime());
            int bytes = (size - 1) * 512 + ce.bytesUsedInLastBlock;
            text.append(String.format(" %3d   %-15s   %s   %8s %,8d   $%03X   $%03X%n", size, ce.name, this.fileTypes[ce.fileType], date, bytes, ce.firstBlock, ce.lastBlock));
        }
        text.append(line);
        text.append(String.format("Blocks free : %3d  Blocks used : %3d  Total blocks : %3d%n", this.volume.totalBlocks - usedBlocks, usedBlocks, this.volume.totalBlocks));
        return new DefaultAppleFileSource(this.volume.name, text.toString(), (FormattedDisk)this);
    }

    private abstract class CatalogEntry
    implements AppleFileSource {
        String name;
        int firstBlock;
        int lastBlock;
        int fileType;
        GregorianCalendar date;
        List<DiskAddress> blocks = new ArrayList<DiskAddress>();
        AbstractFile file;

        public CatalogEntry(byte[] buffer) {
            this.firstBlock = HexFormatter.intValue(buffer[0], buffer[1]);
            this.lastBlock = HexFormatter.intValue(buffer[2], buffer[3]);
            this.fileType = buffer[4] & 0xF;
            this.name = HexFormatter.getPascalString(buffer, 6);
            int i = this.firstBlock;
            while (i < this.lastBlock) {
                this.blocks.add(PascalDisk.this.disk.getDiskAddress(i));
                ++i;
            }
        }

        private boolean contains(DiskAddress da) {
            for (DiskAddress sector : this.blocks) {
                if (sector.compareTo(da) != 0) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            int size = this.lastBlock - this.firstBlock;
            return String.format("%03d  %s  %-15s", size, PascalDisk.this.fileTypes[this.fileType], this.name);
        }

        @Override
        public List<DiskAddress> getSectors() {
            ArrayList<DiskAddress> sectors = new ArrayList<DiskAddress>(this.blocks);
            return sectors;
        }

        @Override
        public FormattedDisk getFormattedDisk() {
            return PascalDisk.this;
        }

        @Override
        public String getUniqueName() {
            return this.name;
        }
    }

    private class FileEntry
    extends CatalogEntry {
        int bytesUsedInLastBlock;

        public FileEntry(byte[] buffer) {
            super(buffer);
            this.bytesUsedInLastBlock = HexFormatter.intValue(buffer[22], buffer[23]);
            this.date = HexFormatter.getPascalDate(buffer, 24);
            int i = this.firstBlock;
            while (i < this.lastBlock) {
                switch (this.fileType) {
                    case 2: {
                        ((PascalDisk)PascalDisk.this).sectorType[i] = PascalDisk.this.codeSector;
                        break;
                    }
                    case 3: {
                        ((PascalDisk)PascalDisk.this).sectorType[i] = PascalDisk.this.textSector;
                        break;
                    }
                    case 4: {
                        ((PascalDisk)PascalDisk.this).sectorType[i] = PascalDisk.this.infoSector;
                        break;
                    }
                    case 5: {
                        ((PascalDisk)PascalDisk.this).sectorType[i] = PascalDisk.this.dataSector;
                        break;
                    }
                    case 6: {
                        ((PascalDisk)PascalDisk.this).sectorType[i] = PascalDisk.this.grafSector;
                        break;
                    }
                    case 7: {
                        ((PascalDisk)PascalDisk.this).sectorType[i] = PascalDisk.this.fotoSector;
                        break;
                    }
                    default: {
                        System.out.println("Unknown pascal file type : " + this.fileType);
                        ((PascalDisk)PascalDisk.this).sectorType[i] = PascalDisk.this.dataSector;
                    }
                }
                ++i;
            }
        }

        @Override
        public AbstractFile getDataSource() {
            if (this.file != null) {
                return this.file;
            }
            byte[] buffer = this.getExactBuffer();
            switch (this.fileType) {
                case 3: {
                    this.file = new PascalText(this.name, buffer);
                    break;
                }
                case 2: {
                    this.file = new PascalCode(this.name, buffer);
                    break;
                }
                case 4: {
                    this.file = new PascalInfo(this.name, buffer);
                    break;
                }
                case 0: {
                    break;
                }
                case 5: {
                    if (this.name.equals("SYSTEM.CHARSET")) {
                        this.file = new Charset(this.name, buffer);
                        break;
                    }
                    if (this.name.equals("WT")) {
                        this.file = new WizardryTitle(this.name, buffer);
                        break;
                    }
                }
                default: {
                    this.file = new DefaultAppleFile(this.name, buffer);
                }
            }
            return this.file;
        }

        private byte[] getExactBuffer() {
            byte[] exactBuffer;
            byte[] buffer = PascalDisk.this.disk.readSectors(this.blocks);
            if (this.bytesUsedInLastBlock < 512) {
                int exactLength = buffer.length - 512 + this.bytesUsedInLastBlock;
                exactBuffer = new byte[exactLength];
                System.arraycopy(buffer, 0, exactBuffer, 0, exactLength);
            } else {
                exactBuffer = buffer;
            }
            return exactBuffer;
        }
    }

    class PascalCodeObject
    implements AppleFileSource {
        private final AbstractFile segment;
        private final List<DiskAddress> blocks;

        public PascalCodeObject(PascalSegment segment, int firstBlock) {
            this.segment = segment;
            this.blocks = new ArrayList<DiskAddress>();
            int lo = firstBlock + segment.blockNo;
            int hi = lo + (segment.size - 1) / 512;
            int i = lo;
            while (i <= hi) {
                this.blocks.add(PascalDisk.this.disk.getDiskAddress(i));
                ++i;
            }
        }

        @Override
        public DataSource getDataSource() {
            return this.segment;
        }

        @Override
        public FormattedDisk getFormattedDisk() {
            return PascalDisk.this;
        }

        @Override
        public List<DiskAddress> getSectors() {
            return this.blocks;
        }

        @Override
        public String getUniqueName() {
            return this.segment.name;
        }

        public String toString() {
            return this.segment.name;
        }
    }

    private class VolumeEntry
    extends CatalogEntry {
        int totalFiles;
        int totalBlocks;

        public VolumeEntry(byte[] buffer) {
            super(buffer);
            this.totalBlocks = HexFormatter.intValue(buffer[14], buffer[15]);
            this.totalFiles = HexFormatter.intValue(buffer[16], buffer[17]);
            this.firstBlock = HexFormatter.intValue(buffer[18], buffer[19]);
            this.date = HexFormatter.getPascalDate(buffer, 20);
            int i = this.firstBlock;
            while (i < this.lastBlock) {
                ((PascalDisk)PascalDisk.this).sectorType[i] = PascalDisk.this.catalogSector;
                ++i;
            }
        }

        @Override
        public AbstractFile getDataSource() {
            System.out.println("in Volume Entry **********************");
            if (this.file != null) {
                return this.file;
            }
            byte[] buffer = PascalDisk.this.disk.readSectors(this.blocks);
            this.file = new DefaultAppleFile(this.name, buffer);
            return this.file;
        }
    }
}

