/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.Instruction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class Routine
extends AbstractFile
implements Iterable<Instruction>,
Comparable<Routine> {
    int startPtr;
    int length;
    int strings;
    int locals;
    Header header;
    List<Parameter> parameters = new ArrayList<Parameter>();
    List<Instruction> instructions = new ArrayList<Instruction>();
    List<Integer> calls = new ArrayList<Integer>();
    List<Integer> calledBy = new ArrayList<Integer>();
    List<Integer> actions = new ArrayList<Integer>();
    private static final String padding = "                             ";

    public Routine(int ptr, Header header, int caller) {
        super(String.format("Routine %05X", ptr), header.buffer);
        Instruction instruction;
        this.header = header;
        this.locals = this.buffer[ptr] & 0xFF;
        if (this.locals > 15) {
            return;
        }
        this.startPtr = ptr++;
        this.calledBy.add(caller);
        int i = 1;
        while (i <= this.locals) {
            this.parameters.add(new Parameter(i, header.getWord(ptr)));
            ptr += 2;
            ++i;
        }
        do {
            if (this.buffer[ptr] == 0 || this.buffer[ptr] == 32 || this.buffer[ptr] == 64) {
                System.out.println("Bad instruction found : " + ptr);
                return;
            }
            instruction = new Instruction(this.buffer, ptr, header);
            this.instructions.add(instruction);
            if (instruction.isCall() && instruction.opcode.callTarget > 0) {
                this.calls.add(instruction.opcode.callTarget);
            }
            if (!instruction.isPrint()) continue;
            ++this.strings;
        } while ((!instruction.isJump() || instruction.target() >= (ptr += instruction.length()) || this.moreCode(ptr)) && (!instruction.isReturn() || this.moreCode(ptr)));
        this.length = ptr - this.startPtr;
        this.hexBlocks.add(new AbstractFile.HexBlock(this.startPtr, this.length, null));
        int endPtr = this.startPtr + this.length;
        for (Instruction ins : this.instructions) {
            int target;
            int n = ins.target() > 256 ? ins.target() : (target = ins.opcode.jumpTarget > 256 ? ins.opcode.jumpTarget : 0);
            if (target == 0) continue;
            if (ins.isBranch() && (target > endPtr || target < this.startPtr)) {
                System.out.println(ins);
            }
            if (!ins.isJump() || target <= endPtr && target >= this.startPtr) continue;
            System.out.println(ins);
        }
    }

    private boolean moreCode(int ptr) {
        for (Instruction ins : this.instructions) {
            if (ins.isBranch() && ins.target() == ptr) {
                return true;
            }
            if (!ins.isJump() || ins.opcode.jumpTarget != ptr) continue;
            return true;
        }
        return false;
    }

    public void addCaller(int caller) {
        this.calledBy.add(caller);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Called by : %3d%n", this.calledBy.size()));
        text.append(String.format("Calls     : %3d%n%n", this.calls.size()));
        text.append(String.format("%s%05X : %d%n", padding, this.startPtr, this.locals));
        for (Parameter parameter : this.parameters) {
            text.append(padding + parameter.toString() + "\n");
        }
        text.append("\n");
        for (Instruction instruction : this.instructions) {
            text.append(instruction + "\n");
        }
        return text.toString();
    }

    @Override
    public Iterator<Instruction> iterator() {
        return this.instructions.iterator();
    }

    @Override
    public int compareTo(Routine o) {
        return this.startPtr - o.startPtr;
    }

    class Parameter {
        int value;
        int sequence;

        public Parameter(int sequence, int value) {
            this.value = value;
            this.sequence = sequence;
        }

        public String toString() {
            return String.format("%05X : L%02d : %d", Routine.this.startPtr + (this.sequence - 1) * 2 + 1, this.sequence, this.value);
        }
    }
}

