/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.ZString;
import java.util.ArrayList;
import java.util.List;

class Instruction {
    Opcode opcode;
    int startPtr;
    byte[] buffer;
    Header header;
    static final String[] name2OP = new String[]{"*bad*", "je", "jl", "jg", "dec_chk", "inc_chk", "jin", "test", "or", "and", "test_attr", "set_attr", "clear_attr", "store", "insert_obj", "loadw", "loadb", "get_prop", "get_prop_addr", "get_next_prop", "add", "sub", "mul", "div", "mod", "call_2s", "call_2n", "set_colour", "throw", "*bad*", "*bad*", "*bad*"};
    static final String[] name1OP = new String[]{"jz", "get_sibling", "get_child", "get_parent", "get_prop_len", "inc", "dec", "print_addr", "call_ls", "remove_obj", "print_obj", "ret", "jump", "print_paddr", "load", "not"};
    static final String[] name0OP = new String[]{"rtrue", "rfalse", "print", "print_ret", "nop", "save", "restore", "restart", "ret_popped", "pop", "quit", "new_line", "show_status", "verify", "", "piracy"};
    static final String[] nameVAR = new String[]{"call", "storew", "storeb", "put_prop", "sread", "print_char", "print_num", "random", "push", "pull", "split_window", "set_window", "call_vs2", "erase_window", "erase_line", "set_cursor", "get_cursor", "set_text_style", "buffer_mode", "output_stream", "input_stream", "sound_effect", "read_char", "scan_table", "not", "call_vn", "call_vn2", "tokenise", "encode_text", "copy_table", "print_table", "check_arg"};

    public Instruction(byte[] buffer, int ptr, Header header) {
        this.buffer = buffer;
        this.startPtr = ptr;
        this.header = header;
        byte b1 = buffer[ptr];
        this.opcode = (b1 & 0x80) == 0 ? new Opcode2OPLong(buffer, ptr) : ((b1 & 0x40) == 0 ? ((b1 & 0x30) == 48 ? new Opcode0OP(buffer, ptr) : new Opcode1OP(buffer, ptr)) : ((b1 & 0x20) == 0 ? new Opcode2OPVar(buffer, ptr) : new OpcodeVar(buffer, ptr)));
    }

    public int length() {
        return this.opcode.length();
    }

    public boolean isReturn() {
        return this.opcode.isReturn;
    }

    public boolean isPrint() {
        return this.opcode.string != null;
    }

    public boolean isCall() {
        return this.opcode.isCall;
    }

    public boolean isJump() {
        return this.opcode instanceof Opcode1OP && this.opcode.opcodeNumber == 12;
    }

    public boolean isBranch() {
        return this.opcode.branch != null;
    }

    public boolean isStore() {
        return this.opcode.store != null;
    }

    public int target() {
        return this.isBranch() ? this.opcode.branch.target : 0;
    }

    public String toString() {
        int max = this.opcode.length();
        String extra = "";
        if (max > 9) {
            max = 9;
            extra = "..";
        }
        String hex = HexFormatter.getHexString(this.buffer, this.startPtr, max);
        return String.format("%-26s%2s %s", hex, extra, this.opcode.toString());
    }

    class ArgumentBranch
    extends Operand {
        int target;
        boolean branchOnTrue;

        public ArgumentBranch(byte value, int offset) {
            this.branchOnTrue = (value & 0x80) == 128;
            int val = value & 0x3F;
            this.target = val <= 1 ? val : val + offset - 1;
            this.length = 1;
        }

        public ArgumentBranch(int value, int offset) {
            this.branchOnTrue = (value & 0x8000) == 32768;
            int val = value & 0x3FFF;
            if (val > 8191) {
                val -= 16384;
            }
            this.target = val + offset;
            this.length = 2;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(" [" + (this.branchOnTrue ? "true" : "false") + "] ");
            if (this.target == 0 || this.target == 1) {
                text.append(this.target == 0 ? "RFALSE" : "RTRUE");
            } else {
                text.append(String.format("%05X", this.target));
            }
            return text.toString();
        }
    }

    class ArgumentString
    extends Operand {
        ZString text;
        int startPtr;
        byte[] buffer;

        public ArgumentString(byte[] buffer, int offset) {
            this.buffer = buffer;
            this.text = new ZString(buffer, offset, Instruction.this.header);
            this.length = this.text.length;
        }

        public String toString() {
            return this.text.value;
        }
    }

    abstract class Opcode {
        int opcodeNumber;
        int opcodeLength;
        List<Operand> operands = new ArrayList<Operand>();
        int totalOperandLength;
        ArgumentBranch branch;
        ArgumentString string;
        OperandVariable store;
        boolean isReturn;
        boolean isCall;
        boolean isExit;
        int jumpTarget;
        int callTarget;

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("%05X : %-12s", Instruction.this.startPtr, this.opcodeName()));
            if (this.jumpTarget != 0) {
                text.append(String.format(" L:%05X", this.jumpTarget));
            } else if (this.isCall) {
                text.append(String.format(" R:%05X (", this.callTarget));
                int count = 0;
                for (Operand op : this.operands) {
                    if (count++ <= 0) continue;
                    text.append(op + ", ");
                }
                if (this.operands.size() > 1) {
                    text.delete(text.length() - 2, text.length());
                }
                text.append(") --> " + this.store);
            } else {
                for (Operand op : this.operands) {
                    text.append(" " + op);
                }
                if (this.branch != null) {
                    text.append(this.branch);
                }
                if (this.store != null) {
                    text.append(" --> " + this.store);
                }
                if (this.string != null) {
                    text.append(" \"" + this.string + "\"");
                }
            }
            return text.toString();
        }

        public int length() {
            int length = this.totalOperandLength + this.opcodeLength;
            if (this.branch != null) {
                length += this.branch.length;
            }
            if (this.store != null) {
                length += this.store.length;
            }
            if (this.string != null) {
                length += this.string.length;
            }
            return length;
        }

        public abstract String opcodeName();

        private void addOperand(Operand operand) {
            this.operands.add(operand);
            this.totalOperandLength += operand.length;
        }

        protected void addOperand(byte[] buffer, int ptr, boolean bit1, boolean bit2) {
            int offset = ptr + this.totalOperandLength;
            if (bit1) {
                if (!bit2) {
                    this.addOperand(new OperandVariable(buffer[offset]));
                }
            } else if (bit2) {
                this.addOperand(new OperandByte(buffer[offset]));
            } else {
                this.addOperand(new OperandWord(Instruction.this.header.getWord(offset)));
            }
        }

        protected void addOperand(byte[] buffer, int ptr, boolean bit) {
            int address = ptr + this.totalOperandLength;
            if (address >= buffer.length) {
                System.out.println("Illegal byte address : " + address);
                return;
            }
            if (bit) {
                this.addOperand(new OperandVariable(buffer[address]));
            } else {
                this.addOperand(new OperandByte(buffer[address]));
            }
        }

        protected void setVariableOperands(int ptr) {
            int value = Instruction.this.buffer[ptr + 1] & 0xFF;
            int i = 0;
            while (i < 4) {
                boolean bit2;
                boolean bit1 = (value & 0x80) == 128;
                boolean bl = bit2 = (value & 0x40) == 64;
                if (bit1 && bit2) break;
                this.addOperand(Instruction.this.buffer, ptr + 2, bit1, bit2);
                value <<= 2;
                ++i;
            }
        }

        protected void setStore(byte[] buffer) {
            this.store = new OperandVariable(buffer[Instruction.this.startPtr + this.totalOperandLength + this.opcodeLength]);
        }

        protected void setBranch(byte[] buffer) {
            int offset = Instruction.this.startPtr + this.totalOperandLength + (this.store == null ? 0 : 1) + this.opcodeLength;
            this.branch = (buffer[offset] & 0x40) == 64 ? new ArgumentBranch(buffer[offset], offset) : new ArgumentBranch(Instruction.this.header.getWord(offset), offset);
        }

        protected void setZString(byte[] buffer) {
            int offset = Instruction.this.startPtr + this.totalOperandLength + this.opcodeLength;
            this.string = new ArgumentString(buffer, offset);
        }
    }

    class Opcode0OP
    extends Opcode {
        public Opcode0OP(byte[] buffer, int ptr) {
            this.opcodeNumber = buffer[ptr] & 0xF;
            this.opcodeLength = 1;
            if (this.opcodeNumber == 5 || this.opcodeNumber == 6 || this.opcodeNumber == 13) {
                this.setBranch(buffer);
            }
            if (this.opcodeNumber == 0 || this.opcodeNumber == 1 || this.opcodeNumber == 3 || this.opcodeNumber == 8) {
                this.isReturn = true;
            }
            if (this.opcodeNumber == 2 || this.opcodeNumber == 3) {
                this.setZString(buffer);
            }
            if (this.opcodeNumber == 7 || this.opcodeNumber == 10) {
                this.isExit = true;
            }
        }

        @Override
        public String opcodeName() {
            return name0OP[this.opcodeNumber];
        }
    }

    class Opcode1OP
    extends Opcode {
        public Opcode1OP(byte[] buffer, int ptr) {
            this.opcodeNumber = buffer[ptr] & 0xF;
            this.opcodeLength = 1;
            boolean bit1 = (buffer[ptr] & 0x20) == 32;
            boolean bit2 = (buffer[ptr] & 0x10) == 16;
            this.addOperand(buffer, ptr + 1, bit1, bit2);
            if (this.opcodeNumber >= 1 && this.opcodeNumber <= 4 || this.opcodeNumber == 8 || this.opcodeNumber == 14 || this.opcodeNumber == 15) {
                this.setStore(buffer);
            }
            if (this.opcodeNumber <= 2) {
                this.setBranch(buffer);
            }
            if (this.opcodeNumber == 12) {
                this.jumpTarget = (short)((Operand)this.operands.get((int)0)).value + Instruction.this.startPtr - 2 + this.length();
            }
            if (this.opcodeNumber == 11) {
                this.isReturn = true;
            }
        }

        @Override
        public String opcodeName() {
            return name1OP[this.opcodeNumber];
        }
    }

    abstract class Opcode2OP
    extends Opcode {
        public Opcode2OP() {
            this.opcodeLength = 1;
        }

        public void setArguments(byte[] buffer) {
            if (this.opcodeNumber >= 1 && this.opcodeNumber <= 7 || this.opcodeNumber == 10) {
                this.setBranch(buffer);
            } else if (this.opcodeNumber >= 15 && this.opcodeNumber <= 25 || this.opcodeNumber == 8 || this.opcodeNumber == 9) {
                this.setStore(buffer);
            }
        }

        @Override
        public String opcodeName() {
            return name2OP[this.opcodeNumber];
        }
    }

    class Opcode2OPLong
    extends Opcode2OP {
        public Opcode2OPLong(byte[] buffer, int ptr) {
            this.opcodeNumber = buffer[ptr] & 0x1F;
            boolean bit1 = (buffer[ptr] & 0x40) == 64;
            boolean bit2 = (buffer[ptr] & 0x20) == 32;
            this.addOperand(buffer, ptr + 1, bit1);
            this.addOperand(buffer, ptr + 1, bit2);
            this.setArguments(buffer);
        }
    }

    class Opcode2OPVar
    extends Opcode2OP {
        public Opcode2OPVar(byte[] buffer, int ptr) {
            this.opcodeNumber = buffer[ptr] & 0x1F;
            this.opcodeLength = 2;
            this.setVariableOperands(ptr);
            this.setArguments(buffer);
        }
    }

    class OpcodeVar
    extends Opcode {
        public OpcodeVar(byte[] buffer, int ptr) {
            this.opcodeNumber = buffer[ptr] & 0x1F;
            this.opcodeLength = 2;
            this.setVariableOperands(ptr);
            if (this.opcodeNumber == 0 || this.opcodeNumber == 7) {
                this.setStore(buffer);
            }
            if (this.opcodeNumber == 0) {
                this.isCall = true;
                this.callTarget = ((Operand)this.operands.get((int)0)).value * 2;
            }
        }

        @Override
        public String opcodeName() {
            return nameVAR[this.opcodeNumber];
        }
    }

    abstract class Operand {
        int length;
        int value;

        Operand() {
        }
    }

    class OperandByte
    extends Operand {
        public OperandByte(byte value) {
            this.value = value & 0xFF;
            this.length = 1;
        }

        public String toString() {
            return String.format("#%03d", this.value);
        }
    }

    class OperandVariable
    extends Operand {
        public OperandVariable(byte value) {
            this.value = value & 0xFF;
            this.length = 1;
        }

        public String toString() {
            if (this.value == 0) {
                return "ToS";
            }
            if (this.value <= 15) {
                return String.format("L%02d", this.value);
            }
            return String.format("G%03d", this.value - 15);
        }
    }

    class OperandWord
    extends Operand {
        public OperandWord(int value) {
            this.value = value;
            this.length = 2;
        }

        public String toString() {
            return String.format("#%05d", this.value);
        }
    }
}

