/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.AbstractFormattedDisk;
import com.bytezone.diskbrowser.disk.AppleDisk;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.infocom.AttributeManager;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.PropertyManager;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

public class InfocomDisk
extends AbstractFormattedDisk {
    private static final int BLOCK_SIZE = 256;
    private static final boolean TYPE_NODE = true;
    private static final boolean TYPE_LEAF = false;
    private byte[] data;
    int version;
    Header header;
    Color green = new Color(0, 200, 0);
    SectorType bootSector = new SectorType("Boot code", Color.lightGray);
    SectorType stringsSector = new SectorType("Strings", Color.magenta);
    SectorType objectsSector = new SectorType("Objects", this.green);
    SectorType dictionarySector = new SectorType("Dictionary", Color.blue);
    SectorType abbreviationsSector = new SectorType("Abbreviations", Color.red);
    SectorType codeSector = new SectorType("Code", Color.orange);
    SectorType headerSector = new SectorType("Header", Color.cyan);
    SectorType globalsSector = new SectorType("Globals", Color.darkGray);
    SectorType grammarSector = new SectorType("Grammar", Color.gray);

    public InfocomDisk(Disk disk) {
        super(disk);
        this.setSectorTypes();
        this.data = disk.readSector(3, 0);
        this.data = this.getBuffer(this.getWord(26) * 2);
        DefaultMutableTreeNode root = this.getCatalogTreeRoot();
        DefaultMutableTreeNode codeNode = null;
        DefaultMutableTreeNode objectNode = null;
        this.header = new Header("Header", this.data, disk.getFile());
        this.addToTree(root, "Header", this.header, false);
        this.addToTree(root, "Abbreviations", this.header.abbreviations, false);
        objectNode = this.addToTree(root, "Objects", this.header.objectManager, true);
        this.header.objectManager.addNodes(objectNode, this);
        this.addToTree(root, "Globals", this.header.globals, false);
        this.addToTree(root, "Grammar", this.header.grammar, false);
        this.addToTree(root, "Dictionary", this.header.dictionary, false);
        codeNode = this.addToTree(root, "Code", this.header.codeManager, true);
        this.header.codeManager.addNodes(codeNode, this);
        this.addToTree(root, "Strings", this.header.stringManager, false);
        PropertyManager pm = new PropertyManager("Properties", this.data, this.header);
        pm.addNodes(this.addToTree(objectNode, "Properties", pm, true), this);
        AttributeManager am = new AttributeManager("Attributes", this.data, this.header);
        am.addNodes(this.addToTree(objectNode, "Attributes", am, true), this);
        this.sectorType[48] = this.headerSector;
        this.setSectors(this.header.abbreviationsTable, this.header.objectTable, this.abbreviationsSector);
        this.setSectors(this.header.objectTable, this.header.globalsOffset, this.objectsSector);
        this.setSectors(this.header.globalsOffset, this.header.staticMemory, this.globalsSector);
        this.setSectors(this.header.staticMemory, this.header.dictionaryOffset, this.grammarSector);
        this.setSectors(this.header.dictionaryOffset, this.header.highMemory, this.dictionarySector);
        this.setSectors(this.header.highMemory, this.header.stringPointer, this.codeSector);
        this.setSectors(this.header.stringPointer, this.header.fileLength, this.stringsSector);
    }

    private void setSectorTypes() {
        this.sectorTypesList.add(this.bootSector);
        this.sectorTypesList.add(this.headerSector);
        this.sectorTypesList.add(this.abbreviationsSector);
        this.sectorTypesList.add(this.objectsSector);
        this.sectorTypesList.add(this.globalsSector);
        this.sectorTypesList.add(this.grammarSector);
        this.sectorTypesList.add(this.dictionarySector);
        this.sectorTypesList.add(this.codeSector);
        this.sectorTypesList.add(this.stringsSector);
        int track = 0;
        while (track < 3) {
            int sector = 0;
            while (sector < 16) {
                if (!this.disk.isSectorEmpty(track, sector)) {
                    this.sectorType[track * 16 + sector] = this.bootSector;
                }
                ++sector;
            }
            ++track;
        }
    }

    private void setSectors(int sectorFrom, int sectorTo, SectorType type) {
        int blockNo = sectorFrom / this.disk.getBlockSize() + 48;
        int blockTo = sectorTo / this.disk.getBlockSize() + 48;
        while (blockNo <= blockTo) {
            if (!this.disk.isSectorEmpty(blockNo)) {
                this.sectorType[blockNo] = type;
            }
            ++blockNo;
        }
    }

    private int getFileSize() {
        byte[] buffer = null;
        int startBlock = this.getWord(4) / 256 + 48;
        int fileSize = 0;
        for (DiskAddress da : this.disk) {
            if (da.getBlock() <= startBlock || !this.disk.isSectorEmpty(da)) continue;
            System.out.println("Empty : " + da);
            buffer = this.disk.readSector(da.getBlock() - 1);
            fileSize = (da.getBlock() - 48) * this.disk.getBlockSize();
            break;
        }
        int ptr = 255;
        while (buffer[ptr--] == 0) {
            --fileSize;
        }
        return fileSize;
    }

    private byte[] getBuffer(int fileSize) {
        if (fileSize == 0) {
            fileSize = this.getFileSize();
        }
        System.out.println("File size : " + fileSize);
        this.data = new byte[fileSize];
        int track = 3;
        int ptr = 0;
        while (track < 35) {
            int sector = 0;
            while (sector < 16) {
                byte[] temp = this.disk.readSector(track, sector);
                int spaceLeft = fileSize - ptr;
                if (spaceLeft <= 256) {
                    System.arraycopy(temp, 0, this.data, ptr, spaceLeft);
                    return this.data;
                }
                System.arraycopy(temp, 0, this.data, ptr, 256);
                ++sector;
                ptr += 256;
            }
            ++track;
        }
        return this.data;
    }

    private DefaultMutableTreeNode addToTree(DefaultMutableTreeNode root, String title, DataSource af, boolean allowsChildren) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new DefaultAppleFileSource(title, af, (FormattedDisk)this));
        node.setAllowsChildren(allowsChildren);
        root.add(node);
        return node;
    }

    @Override
    public List<DiskAddress> getFileSectors(int fileNo) {
        return null;
    }

    @Override
    public AppleFileSource getCatalog() {
        return new DefaultAppleFileSource(this.header.getText(), this);
    }

    public static boolean isCorrectFormat(AppleDisk disk) {
        disk.setInterleave(2);
        return InfocomDisk.checkFormat(disk);
    }

    public static boolean checkFormat(AppleDisk disk) {
        byte[] buffer = disk.readSector(3, 0);
        int version = buffer[0] & 0xFF;
        int highMemory = HexFormatter.intValue(buffer[5], buffer[4]);
        int programCounter = HexFormatter.intValue(buffer[7], buffer[6]);
        int dictionary = HexFormatter.intValue(buffer[9], buffer[8]);
        int objectTable = HexFormatter.intValue(buffer[11], buffer[10]);
        int globals = HexFormatter.intValue(buffer[13], buffer[12]);
        int staticMemory = HexFormatter.intValue(buffer[15], buffer[14]);
        int abbreviationsTable = HexFormatter.intValue(buffer[25], buffer[24]);
        int fileLength = HexFormatter.intValue(buffer[27], buffer[26]);
        if (abbreviationsTable >= objectTable) {
            return false;
        }
        if (objectTable >= globals) {
            return false;
        }
        if (globals >= staticMemory) {
            return false;
        }
        if (staticMemory >= dictionary) {
            return false;
        }
        if (dictionary >= highMemory) {
            return false;
        }
        if (version < 2 || version > 3) {
            System.out.println("Incorrect format : " + version);
            JOptionPane.showMessageDialog(null, "This appears to be an Infocom disk, but version " + version + " is not supported", "Unknown disk format", 1);
            return false;
        }
        return true;
    }

    private int getWord(int offset) {
        return this.data[offset] << 8 & 0xFF00 | this.data[offset + 1] & 0xFF;
    }

    private void createStoryFile(String fileName) {
        File f = new File(fileName);
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(this.data);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

