/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.infocom.Abbreviations;
import com.bytezone.diskbrowser.infocom.CodeManager;
import com.bytezone.diskbrowser.infocom.Dictionary;
import com.bytezone.diskbrowser.infocom.Globals;
import com.bytezone.diskbrowser.infocom.Grammar;
import com.bytezone.diskbrowser.infocom.ObjectManager;
import com.bytezone.diskbrowser.infocom.StringManager;
import java.io.File;

class Header
extends AbstractFile {
    final String[] propertyNames = new String[32];
    File file;
    int version;
    int highMemory;
    int programCounter;
    int dictionaryOffset;
    int objectTable;
    int globalsOffset;
    int staticMemory;
    int abbreviationsTable;
    int fileLength;
    int checksum;
    int stringPointer;
    Abbreviations abbreviations;
    Dictionary dictionary;
    ObjectManager objectManager;
    StringManager stringManager;
    CodeManager codeManager;
    Globals globals;
    Grammar grammar;

    public Header(String name, byte[] buffer, File file) {
        super(name, buffer);
        this.file = file;
        this.version = this.getByte(0);
        this.highMemory = this.getWord(4);
        this.programCounter = this.getWord(6);
        this.dictionaryOffset = this.getWord(8);
        this.objectTable = this.getWord(10);
        this.globalsOffset = this.getWord(12);
        this.staticMemory = this.getWord(14);
        this.abbreviationsTable = this.getWord(24);
        this.checksum = this.getWord(28);
        this.fileLength = this.getWord(26) * 2;
        if (this.fileLength == 0) {
            this.fileLength = buffer.length;
        }
        this.abbreviations = new Abbreviations(this);
        this.dictionary = new Dictionary(this);
        this.globals = new Globals(this);
        this.codeManager = new CodeManager(this);
        this.grammar = new Grammar("Grammar", buffer, this);
        this.objectManager = new ObjectManager(this);
        this.stringManager = new StringManager("Strings", buffer, this);
        this.codeManager.addRoutine(this.programCounter - 1, 0);
        this.codeManager.addActionRoutines();
        this.codeManager.addCodeRoutines();
        this.codeManager.addMissingRoutines();
        this.hexBlocks.add(new AbstractFile.HexBlock(0, 64, "Header data:"));
    }

    public String getAbbreviation(int index) {
        return this.abbreviations.getAbbreviation(index);
    }

    public boolean containsWordAt(int address) {
        return this.dictionary.containsWordAt(address);
    }

    public String wordAt(int address) {
        return this.dictionary.wordAt(address);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Disk name                %s%n", this.file.getName()));
        text.append(String.format("Version                  %d%n", this.version));
        text.append("\nDynamic memory:\n");
        text.append(String.format("  Abbreviation table     %04X  %,6d%n", this.abbreviationsTable, this.abbreviationsTable));
        text.append(String.format("  Objects table          %04X  %,6d%n", this.objectTable, this.objectTable));
        text.append(String.format("  Global variables       %04X  %,6d%n", this.globalsOffset, this.globalsOffset));
        text.append("\nStatic memory:\n");
        text.append(String.format("  Grammar table etc      %04X  %,6d%n", this.staticMemory, this.staticMemory));
        text.append(String.format("  Dictionary             %04X  %,6d%n", this.dictionaryOffset, this.dictionaryOffset));
        text.append("\nHigh memory:\n");
        text.append(String.format("  ZCode                  %04X  %,6d%n", this.highMemory, this.highMemory));
        text.append(String.format("  Program counter        %04X  %,6d%n", this.programCounter, this.programCounter));
        text.append(String.format("\nFile length             %05X  %,6d%n", this.fileLength, this.fileLength));
        text.append(String.format("Checksum                 %04X  %,6d%n", this.checksum, this.checksum));
        text.append(String.format("%nZString offset          %05X  %,6d%n", this.stringPointer, this.stringPointer));
        text.append(String.format("Total strings                     %d%n", this.stringManager.strings.size()));
        text.append(String.format("Total objects                     %d%n", this.objectManager.list.size()));
        return text.toString();
    }

    int getByte(int offset) {
        return this.buffer[offset] & 0xFF;
    }

    int getWord(int offset) {
        return this.buffer[offset] << 8 & 0xFF00 | this.buffer[offset + 1] & 0xFF;
    }
}

