/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.Routine;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;

class CodeManager
extends AbstractFile {
    Header header;
    int codeSize;
    Map<Integer, Routine> routines = new TreeMap<Integer, Routine>();

    public CodeManager(Header header) {
        super("Code", header.buffer);
        this.header = header;
    }

    public void addNodes(DefaultMutableTreeNode root, FormattedDisk disk) {
        root.setAllowsChildren(true);
        this.codeSize = this.header.stringPointer - this.header.highMemory;
        int count = 0;
        for (Routine routine : this.routines.values()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new DefaultAppleFileSource(String.format("%3d %s (%04X)", ++count, routine.name, routine.startPtr / 2), routine, disk));
            node.setAllowsChildren(false);
            root.add(node);
        }
    }

    public void addMissingRoutines() {
        System.out.printf("%nWalking the code block%n%n", new Object[0]);
        int total = 0;
        int ptr = this.header.highMemory;
        while (ptr < this.header.stringPointer) {
            if (ptr % 2 == 1) {
                ++ptr;
            }
            if (this.containsRoutineAt(ptr)) {
                ptr += this.getRoutine((int)ptr).length;
                continue;
            }
            Routine routine = this.addRoutine(ptr, 0);
            if (routine == null) {
                System.out.printf("Invalid routine found : %05X%n", ptr);
                ptr = this.findNextRoutine(ptr + 1);
                System.out.printf("skipping to %05X%n", ptr);
                if (ptr != 0) continue;
                break;
            }
            ++total;
            ptr += routine.length;
        }
        System.out.printf("%n%d new routines found by walking the code block%n%n", total);
    }

    private int findNextRoutine(int address) {
        for (Routine routine : this.routines.values()) {
            if (routine.startPtr <= address) continue;
            return routine.startPtr;
        }
        return 0;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        int count = 0;
        int nextAddress = this.header.highMemory;
        text.append("  #   Address   Size   Lines  Strings   Called   Calls   Gap   Pack\n");
        text.append("---   -------   ----   -----  -------   ------   -----   ---   ----\n");
        for (Routine r : this.routines.values()) {
            int gap = r.startPtr - nextAddress;
            text.append(String.format("%3d    %05X   %5d     %3d      %2d      %3d     %3d   %4d   %04X%n", ++count, r.startPtr, r.length, r.instructions.size(), r.strings, r.calledBy.size(), r.calls.size(), gap, r.startPtr / 2));
            nextAddress = r.startPtr + r.length;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    public boolean containsRoutineAt(int address) {
        return this.routines.containsKey(address);
    }

    public void addCodeRoutines() {
        List<Integer> routines = this.header.objectManager.getCodeRoutines();
        System.out.println("Adding " + routines.size() + " code routines");
        for (Integer address : routines) {
            this.addRoutine(address, 0);
        }
    }

    public void addActionRoutines() {
        List<Integer> routines = this.header.grammar.getActionRoutines();
        System.out.println("Adding " + routines.size() + " action routines");
        for (Integer address : routines) {
            this.addRoutine(address, 0);
        }
    }

    public Routine addRoutine(int address, int caller) {
        if (address == 0) {
            return null;
        }
        if (address > this.header.fileLength) {
            return null;
        }
        if (this.routines.containsKey(address)) {
            Routine routine = this.routines.get(address);
            routine.addCaller(caller);
            return routine;
        }
        Routine r = new Routine(address, this.header, caller);
        if (r.length == 0) {
            return null;
        }
        this.routines.put(address, r);
        for (int ptr : r.calls) {
            this.addRoutine(ptr, address);
        }
        return r;
    }

    public Routine getRoutine(int address) {
        return this.routines.get(address);
    }

    @Override
    public String getHexDump() {
        return HexFormatter.format(this.buffer, this.header.highMemory, this.codeSize);
    }
}

