/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.common.Platform;
import com.bytezone.diskbrowser.gui.DiskLayoutPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

class ScrollRuler
extends JComponent {
    public static final int HEIGHT = 20;
    public static final int WIDTH = 40;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final Font font = Platform.getFont(Platform.FontType.SANS_SERIF, Platform.FontSize.BASE);
    int orientation;
    boolean isHex = true;
    boolean isTrackMode;
    DiskLayoutPanel.LayoutDetails layoutDetails;
    JComponent image;

    public ScrollRuler(JComponent image, int orientation) {
        this.orientation = orientation;
        this.image = image;
        if (orientation == 0) {
            this.setPreferredSize(new Dimension(0, 20));
        } else {
            this.setPreferredSize(new Dimension(40, 0));
        }
    }

    public void setLayout(DiskLayoutPanel.LayoutDetails layout) {
        this.layoutDetails = layout;
        if (this.orientation == 0) {
            this.setPreferredSize(new Dimension(layout.block.width * layout.grid.width + 1, 20));
        } else {
            this.setPreferredSize(new Dimension(40, layout.block.height * layout.grid.height + 1));
        }
        this.setTrackMode(layout.grid.width == 16);
    }

    public void setHex(boolean hex) {
        this.isHex = hex;
        this.repaint();
    }

    public void setTrackMode(boolean trackMode) {
        this.isTrackMode = trackMode;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle clipRect = g.getClipBounds();
        g.setColor(Color.WHITE);
        g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        if (this.layoutDetails == null) {
            return;
        }
        g.setFont(font);
        g.setColor(Color.black);
        if (this.orientation == 0) {
            this.drawHorizontal(g, clipRect, this.layoutDetails.block.width);
        } else {
            this.drawVertical(g, clipRect, this.layoutDetails.block.height);
        }
    }

    private void drawHorizontal(Graphics g, Rectangle clipRect, int width) {
        int offset;
        String format;
        int start = clipRect.x / width;
        int end = start + clipRect.width / width;
        end = Math.min(end, this.image.getWidth() / width - 1);
        if (this.layoutDetails.block.width <= 15) {
            format = this.isHex ? "%1X" : "%1d";
            offset = this.isHex ? 4 : 0;
        } else {
            format = this.isHex ? "%02X" : "%02d";
            offset = 7;
        }
        int i = start;
        while (i <= end) {
            g.drawString(String.format(format, i), i * width + offset, 15);
            ++i;
        }
    }

    private void drawVertical(Graphics g, Rectangle clipRect, int height) {
        int start = clipRect.y / height;
        int end = start + clipRect.height / height;
        end = Math.min(end, this.image.getHeight() / height - 1);
        String format = this.isHex ? "%04X" : "%04d";
        int i = start;
        while (i <= end) {
            int value = this.isTrackMode ? i : i * this.layoutDetails.grid.width;
            g.drawString(String.format(format, value), 4, i * height + 13);
            ++i;
        }
    }
}

