/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.common.DefaultAction;
import com.bytezone.diskbrowser.disk.DiskFactory;
import com.bytezone.diskbrowser.gui.CatalogPanel;
import com.bytezone.diskbrowser.gui.DiskBrowser;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;

class OpenFileAction
extends DefaultAction {
    CatalogPanel catalogPanel;

    public OpenFileAction(DiskBrowser owner, CatalogPanel catalogPanel) {
        super("Open disk...", "Opens a single disk image", "/com/bytezone/diskbrowser/icons/");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control O"));
        this.putValue("MnemonicKey", 79);
        this.catalogPanel = catalogPanel;
        this.setIcon("SmallIcon", "Open16.gif");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        JFileChooser chooser = new JFileChooser("C:/");
        chooser.setDialogTitle("Select disk image");
        FileNameExtensionFilter filter = new FileNameExtensionFilter("DSK & PO Images", "dsk", "po");
        chooser.setFileFilter(filter);
        int result = chooser.showOpenDialog(null);
        if (result == 0 && (file = chooser.getSelectedFile()) != null) {
            this.catalogPanel.addDiskPanel(DiskFactory.createDisk(file.getAbsolutePath()), null, true);
        }
    }
}

