/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.common.OSXAdapter;
import com.bytezone.common.Platform;
import com.bytezone.diskbrowser.disk.DataDisk;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.CreateDatabaseAction;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.EnvironmentAction;
import com.bytezone.diskbrowser.gui.ExecuteDiskAction;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.FileSelectionListener;
import com.bytezone.diskbrowser.gui.InterleaveAction;
import com.bytezone.diskbrowser.gui.QuitAction;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class MenuHandler
implements DiskSelectionListener,
FileSelectionListener,
QuitAction.QuitListener {
    private static final String PREFS_LINE_WRAP = "line wrap";
    private static final String PREFS_SHOW_CATALOG = "show catalog";
    private static final String PREFS_SHOW_LAYOUT = "show layout";
    private static final String PREFS_SHOW_FREE_SECTORS = "show free sectors";
    FormattedDisk currentDisk;
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu("File");
    JMenu formatMenu = new JMenu("Format");
    JMenu helpMenu = new JMenu("Help");
    JMenuItem openItem = new JMenuItem("Open disk...");
    JMenuItem rootItem = new JMenuItem("Set root folder...");
    JMenuItem refreshTreeItem = new JMenuItem("Refresh current tree");
    JMenuItem executeDiskItem;
    JMenuItem printItem = new JMenuItem("Print output panel...");
    public final JMenuItem createCatalogFileItem = new JMenuItem("Create catalog file...");
    public final JMenuItem createDiskFileItem = new JMenuItem("Create disk file...");
    JMenuItem dbItem = new JMenuItem(new CreateDatabaseAction());
    JMenuItem lineWrapItem = new JCheckBoxMenuItem("Line wrap");
    JMenuItem showLayoutItem = new JCheckBoxMenuItem("Show layout panel");
    JMenuItem showCatalogItem = new JCheckBoxMenuItem("Show catalog panel");
    JMenuItem showFreeSectorsItem = new JCheckBoxMenuItem("Show free sectors");
    JMenuItem sector256Item = new JRadioButtonMenuItem("256 byte sectors");
    JMenuItem sector512Item = new JRadioButtonMenuItem("512 byte blocks");
    JMenuItem interleave0Item = new JRadioButtonMenuItem(new InterleaveAction(0));
    JMenuItem interleave1Item = new JRadioButtonMenuItem(new InterleaveAction(1));
    JMenuItem interleave2Item = new JRadioButtonMenuItem(new InterleaveAction(2));

    public MenuHandler(Preferences prefs) {
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.formatMenu);
        this.menuBar.add(this.helpMenu);
        this.fileMenu.add(this.rootItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.refreshTreeItem);
        this.addLauncherMenu();
        this.fileMenu.add(this.printItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.createCatalogFileItem);
        this.fileMenu.add(this.createDiskFileItem);
        this.fileMenu.add(this.dbItem);
        this.formatMenu.add(this.lineWrapItem);
        this.formatMenu.add(this.showCatalogItem);
        this.formatMenu.add(this.showLayoutItem);
        this.formatMenu.add(this.showFreeSectorsItem);
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.sector256Item);
        this.formatMenu.add(this.sector512Item);
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.interleave0Item);
        this.formatMenu.add(this.interleave1Item);
        this.formatMenu.add(this.interleave2Item);
        this.helpMenu.add(new JMenuItem(new EnvironmentAction()));
        this.sector256Item.setActionCommand("256");
        this.sector256Item.setAccelerator(KeyStroke.getKeyStroke("alt 4"));
        this.sector512Item.setActionCommand("512");
        this.sector512Item.setAccelerator(KeyStroke.getKeyStroke("alt 5"));
        this.lineWrapItem.setAccelerator(KeyStroke.getKeyStroke("alt W"));
        this.printItem.setAccelerator(KeyStroke.getKeyStroke("control P"));
        ButtonGroup sectorGroup = new ButtonGroup();
        ButtonGroup interleaveGroup = new ButtonGroup();
        sectorGroup.add(this.sector256Item);
        sectorGroup.add(this.sector512Item);
        interleaveGroup.add(this.interleave0Item);
        interleaveGroup.add(this.interleave1Item);
        interleaveGroup.add(this.interleave2Item);
        this.dbItem.setEnabled(false);
        this.lineWrapItem.setSelected(prefs.getBoolean(PREFS_LINE_WRAP, true));
        this.showLayoutItem.setSelected(prefs.getBoolean(PREFS_SHOW_LAYOUT, true));
        this.showCatalogItem.setSelected(prefs.getBoolean(PREFS_SHOW_CATALOG, true));
        this.showFreeSectorsItem.setSelected(prefs.getBoolean(PREFS_SHOW_FREE_SECTORS, false));
    }

    public void setQuitAction(QuitAction quitAction) {
        if (Platform.MAC) {
            try {
                OSXAdapter.setQuitHandler(quitAction, quitAction.getClass().getDeclaredMethod("quit", null));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.fileMenu.addSeparator();
            this.fileMenu.add(new JMenuItem(quitAction));
        }
    }

    void addHelpMenuAction(Action action, String functionName) {
        if (Platform.MAC) {
            try {
                if (functionName.equals("about")) {
                    OSXAdapter.setAboutHandler(action, action.getClass().getDeclaredMethod(functionName, null));
                } else if (functionName.equals("prefs")) {
                    OSXAdapter.setPreferencesHandler(action, action.getClass().getDeclaredMethod(functionName, null));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.helpMenu.add(new JMenuItem(action));
        }
    }

    private void addLauncherMenu() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        boolean openSupported = false;
        Desktop.Action[] actionArray = Desktop.Action.values();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Desktop.Action action = actionArray[n2];
            if (action.toString().equals("OPEN")) {
                openSupported = true;
                break;
            }
            ++n2;
        }
        if (!openSupported) {
            return;
        }
        this.executeDiskItem = new JMenuItem(new ExecuteDiskAction(this));
        this.fileMenu.add(this.executeDiskItem);
        this.fileMenu.addSeparator();
    }

    @Override
    public void quit(Preferences prefs) {
        prefs.putBoolean(PREFS_LINE_WRAP, this.lineWrapItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_LAYOUT, this.showLayoutItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_CATALOG, this.showCatalogItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_FREE_SECTORS, this.showFreeSectorsItem.isSelected());
    }

    @Override
    public void diskSelected(DiskSelectedEvent event) {
        this.currentDisk = event.getFormattedDisk();
        this.adjustMenus(this.currentDisk);
    }

    @Override
    public void fileSelected(FileSelectedEvent event) {
        if (event.file.getFormattedDisk() != this.currentDisk) {
            this.currentDisk = event.file.getFormattedDisk();
            this.adjustMenus(this.currentDisk);
        }
    }

    private void adjustMenus(final FormattedDisk disk) {
        if (disk != null) {
            this.sector256Item.setSelected(disk.getDisk().getBlockSize() == 256);
            this.sector512Item.setSelected(disk.getDisk().getBlockSize() == 512);
            this.interleave0Item.setSelected(disk.getDisk().getInterleave() == 0);
            this.interleave1Item.setSelected(disk.getDisk().getInterleave() == 1);
            this.interleave2Item.setSelected(disk.getDisk().getInterleave() == 2);
        }
        boolean isDataDisk = disk instanceof DataDisk;
        this.sector256Item.setEnabled(isDataDisk);
        this.sector512Item.setEnabled(isDataDisk);
        this.interleave0Item.setEnabled(isDataDisk);
        this.interleave1Item.setEnabled(isDataDisk);
        this.interleave2Item.setEnabled(isDataDisk);
        if (isDataDisk) {
            ActionListener sectorListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int size = Integer.parseInt(e.getActionCommand());
                    disk.getDisk().setBlockSize(size);
                }
            };
            this.sector256Item.addActionListener(sectorListener);
            this.sector512Item.addActionListener(sectorListener);
            ((InterleaveAction)this.interleave0Item.getAction()).setDisk(this.currentDisk);
            ((InterleaveAction)this.interleave1Item.getAction()).setDisk(this.currentDisk);
            ((InterleaveAction)this.interleave2Item.getAction()).setDisk(this.currentDisk);
        }
    }
}

