/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.DiskFactory;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.AbstractTab;
import com.bytezone.diskbrowser.gui.DiskAndFileSelector;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.NoDisksFoundException;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.TreeBuilder;
import java.awt.Font;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class FileSystemTab
extends AbstractTab {
    File rootFolder;

    public FileSystemTab(File folder, DiskAndFileSelector selector, RedoHandler navMan, Font font, DiskSelectedEvent diskEvent) throws NoDisksFoundException {
        super(navMan, selector, font);
        this.rootFolder = folder;
        TreeBuilder tb = new TreeBuilder(folder);
        if (tb.totalDisks == 0) {
            throw new NoDisksFoundException();
        }
        this.setTree(tb.tree);
        this.setSelectionListener(this.tree);
        if (diskEvent == null) {
            TreeBuilder.FileNode fn = (TreeBuilder.FileNode)this.findFirstLeafNode().getUserObject();
            diskEvent = new DiskSelectedEvent(this, DiskFactory.createDisk(fn.file));
        }
        if (diskEvent != null) {
            navMan.diskSelected(diskEvent);
        } else {
            System.out.println("No disk event");
        }
    }

    public FileSystemTab(File folder, DiskAndFileSelector selector, RedoHandler navMan, Font font) throws NoDisksFoundException {
        this(folder, selector, navMan, font, null);
    }

    @Override
    public void activate() {
        this.tree.setSelectionPath(null);
        this.navMan.setCurrentData(this.redoData);
    }

    @Override
    public void refresh() {
        String currentDiskName = ((TreeBuilder.FileNode)this.getSelectedObject()).file.getAbsolutePath();
        TreeBuilder tb = new TreeBuilder(this.rootFolder);
        this.setTree(tb.tree);
        if (currentDiskName != null) {
            this.showNode(this.findNode(currentDiskName));
        }
        this.setSelectionListener(this.tree);
    }

    void redoEvent(RedoHandler.RedoEvent event) {
        FormattedDisk disk = ((DiskSelectedEvent)event.value).getFormattedDisk();
        DefaultMutableTreeNode node = this.findNode(disk.getDisk().getFile().getAbsolutePath());
        if (node == null) {
            node = this.findNode(2);
        }
        if (node != null) {
            this.showNode(node);
        } else {
            System.out.println("Disk node not found");
        }
    }

    private DefaultMutableTreeNode findNode(String absolutePath) {
        DefaultMutableTreeNode rootNode = this.getRootNode();
        Enumeration<TreeNode> children = rootNode.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            TreeBuilder.FileNode fn = (TreeBuilder.FileNode)node.getUserObject();
            if (!fn.file.getAbsolutePath().equals(absolutePath)) continue;
            return node;
        }
        System.out.println("Node not found : " + absolutePath);
        return null;
    }

    public void replaceDisk(FormattedDisk disk) {
        TreeBuilder.FileNode fn = (TreeBuilder.FileNode)this.getSelectedObject();
        if (fn != null && fn.replaceDisk(disk)) {
            return;
        }
        DefaultMutableTreeNode rootNode = this.getRootNode();
        Enumeration<TreeNode> children = rootNode.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            fn = (TreeBuilder.FileNode)node.getUserObject();
            if (fn.replaceDisk(disk)) break;
        }
    }

    private void setSelectionListener(JTree tree) {
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeBuilder.FileNode fn = (TreeBuilder.FileNode)FileSystemTab.this.getSelectedObject();
                if (fn != null && !fn.file.isDirectory()) {
                    FileSystemTab.this.eventHandler.fireDiskSelectionEvent(fn.formattedDisk());
                }
            }
        });
    }
}

