/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.DualDosDisk;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.DiskLayoutImage;
import com.bytezone.diskbrowser.gui.DiskLegendPanel;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.FileSelectionListener;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.ScrollRuler;
import com.bytezone.diskbrowser.gui.SectorSelectedEvent;
import com.bytezone.diskbrowser.gui.SectorSelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class DiskLayoutPanel
extends JPanel
implements DiskSelectionListener,
FileSelectionListener,
RedoHandler.RedoListener {
    private static final int SIZE = 15;
    private final DiskLayoutImage image = new DiskLayoutImage();
    private final ScrollRuler verticalRuler = new ScrollRuler(this.image, 1);
    private final ScrollRuler horizontalRuler = new ScrollRuler(this.image, 0);
    private final DiskLegendPanel legendPanel = new DiskLegendPanel();
    private final JScrollPane sp;
    private LayoutDetails layout;

    public DiskLayoutPanel() {
        super(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.sp = new JScrollPane(this.image, 22, 32);
        this.sp.setBackground(Color.WHITE);
        this.sp.setOpaque(true);
        this.sp.setColumnHeaderView(this.horizontalRuler);
        this.sp.setRowHeaderView(this.verticalRuler);
        this.sp.setBorder(null);
        this.sp.setCorner("UPPER_LEFT_CORNER", new Corner(true));
        this.sp.setCorner("LOWER_LEFT_CORNER", new Corner(false));
        this.sp.setCorner("UPPER_RIGHT_CORNER", new Corner(false));
        this.sp.setCorner("LOWER_RIGHT_CORNER", new Corner(false));
        this.add((Component)this.sp, "Center");
        this.add((Component)this.legendPanel, "South");
    }

    public DiskLayoutPanel(FormattedDisk disk) {
        this();
        this.setDisk(disk);
    }

    public void setDisk(final FormattedDisk disk) {
        this.layout = new LayoutDetails(disk);
        this.image.setDisk(disk, this.layout);
        this.verticalRuler.setLayout(this.layout);
        this.horizontalRuler.setLayout(this.layout);
        this.legendPanel.setDisk(disk, this.layout);
        this.sp.setViewportView(this.image);
        disk.getDisk().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutDetails layout = new LayoutDetails(disk);
                DiskLayoutPanel.this.image.setDisk(disk, layout);
                ((DiskLayoutPanel)DiskLayoutPanel.this).legendPanel.layoutDetails = layout;
                DiskLayoutPanel.this.legendPanel.repaint();
                DiskLayoutPanel.this.verticalRuler.setLayout(layout);
                DiskLayoutPanel.this.horizontalRuler.setLayout(layout);
            }
        });
        this.repaint();
    }

    public void setHex(boolean hex) {
        this.verticalRuler.setHex(hex);
        this.horizontalRuler.setHex(hex);
    }

    public void setBlock(boolean block) {
        this.verticalRuler.setTrackMode(block);
        this.horizontalRuler.setTrackMode(block);
    }

    public void setFree(boolean free) {
        this.image.setShowFreeSectors(free);
    }

    public void addSectorSelectionListener(SectorSelectionListener listener) {
        this.image.addSectorSelectionListener(listener);
    }

    public void removeSectorSelectionListener(SectorSelectionListener listener) {
        this.image.removeSectorSelectionListener(listener);
    }

    @Override
    public void diskSelected(DiskSelectedEvent event) {
        this.setDisk(event.getFormattedDisk());
    }

    @Override
    public void fileSelected(FileSelectedEvent event) {
        this.checkCorrectDisk(event.file.getFormattedDisk());
        this.image.setSelection(event.file.getSectors());
    }

    @Override
    public void redo(RedoHandler.RedoEvent event) {
        if (!event.type.equals("SectorEvent")) {
            return;
        }
        this.checkCorrectDisk(((SectorSelectedEvent)event.value).getFormattedDisk());
        this.image.redoEvent(event);
    }

    private void checkCorrectDisk(FormattedDisk newDisk) {
        if (newDisk instanceof DualDosDisk) {
            newDisk = ((DualDosDisk)newDisk).getCurrentDisk();
        }
        if (newDisk != this.image.disk) {
            LayoutDetails layout = new LayoutDetails(newDisk);
            this.image.setDisk(newDisk, layout);
            this.legendPanel.setDisk(newDisk, layout);
        }
    }

    class Corner
    extends JComponent {
        Color backgroundColor = Color.WHITE;
        boolean showHex = true;

        public Corner(boolean click) {
            if (click) {
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        Corner.this.showHex = !Corner.this.showHex;
                        DiskLayoutPanel.this.verticalRuler.setHex(Corner.this.showHex);
                        DiskLayoutPanel.this.horizontalRuler.setHex(Corner.this.showHex);
                    }
                });
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    class LayoutDetails {
        Dimension block;
        Dimension grid;

        public LayoutDetails(FormattedDisk formattedDisk) {
            Disk disk = formattedDisk.getDisk();
            this.block = new Dimension(disk.getBlockSize() == 256 ? 15 : 30, 15);
            this.grid = formattedDisk.getGridLayout();
        }

        public Rectangle getLocation(DiskAddress da) {
            int y = da.getBlock() / this.grid.width;
            int x = da.getBlock() % this.grid.width;
            Rectangle r = new Rectangle(x * this.block.width, y * this.block.height, this.block.width, this.block.height);
            return r;
        }
    }
}

