/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.DiskFactory;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.FileSelectionListener;
import java.io.File;
import javax.swing.event.EventListenerList;

class DiskAndFileSelector {
    EventListenerList listenerList = new EventListenerList();
    FormattedDisk currentDisk;
    boolean redo;

    DiskAndFileSelector() {
    }

    public void addDiskSelectionListener(DiskSelectionListener listener) {
        this.listenerList.add(DiskSelectionListener.class, listener);
    }

    public void removeDiskSelectionListener(DiskSelectionListener listener) {
        this.listenerList.remove(DiskSelectionListener.class, listener);
    }

    public void fireDiskSelectionEvent(File file) {
        if (file.isDirectory()) {
            return;
        }
        if (this.currentDisk != null) {
            System.out.println(this.currentDisk.getDisk().getFile().getAbsolutePath());
            System.out.println(file.getAbsolutePath());
        }
        if (this.currentDisk != null && this.currentDisk.getDisk().getFile().getAbsolutePath().equals(file.getAbsolutePath())) {
            this.fireDiskSelectionEvent(this.currentDisk);
        } else {
            System.out.println("  creating disk from a file");
            this.fireDiskSelectionEvent(DiskFactory.createDisk(file.getAbsolutePath()));
        }
    }

    public void fireDiskSelectionEvent(FormattedDisk disk) {
        DiskSelectionListener[] listeners;
        if (disk == this.currentDisk) {
            System.out.println("Disk event duplicated");
            return;
        }
        DiskSelectedEvent e = new DiskSelectedEvent(this, disk);
        e.redo = this.redo;
        DiskSelectionListener[] diskSelectionListenerArray = listeners = (DiskSelectionListener[])this.listenerList.getListeners(DiskSelectionListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            DiskSelectionListener listener = diskSelectionListenerArray[n2];
            listener.diskSelected(e);
            ++n2;
        }
        this.currentDisk = disk;
    }

    public void addFileSelectionListener(FileSelectionListener listener) {
        this.listenerList.add(FileSelectionListener.class, listener);
    }

    public void removeFileSelectionListener(FileSelectionListener listener) {
        this.listenerList.remove(FileSelectionListener.class, listener);
    }

    public void fireFileSelectionEvent(AppleFileSource file) {
        FileSelectionListener[] listeners;
        assert (file != null);
        FileSelectedEvent e = new FileSelectedEvent(this, file);
        e.redo = this.redo;
        FileSelectionListener[] fileSelectionListenerArray = listeners = (FileSelectionListener[])this.listenerList.getListeners(FileSelectionListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            FileSelectionListener listener = fileSelectionListenerArray[n2];
            listener.fileSelected(e);
            ++n2;
        }
    }
}

