/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.SectorList;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.FileSelectionListener;
import com.bytezone.diskbrowser.gui.LineWrapAction;
import com.bytezone.diskbrowser.gui.MenuHandler;
import com.bytezone.diskbrowser.gui.SectorSelectedEvent;
import com.bytezone.diskbrowser.gui.SectorSelectionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DataPanel
extends JTabbedPane
implements DiskSelectionListener,
FileSelectionListener,
SectorSelectionListener,
PreferenceChangeListener {
    private static final int TEXT_WIDTH = 90;
    JTextArea hexText;
    JTextArea disassemblyText;
    JScrollPane formattedPane;
    JScrollPane imagePane;
    JTextArea formattedText;
    ImagePanel imagePanel;
    boolean imageVisible = false;
    boolean formattedTextValid;
    boolean hexTextValid;
    boolean assemblerTextValid;
    DataSource currentDataSource;
    private Font font;
    final MenuHandler menuHandler;

    public DataPanel(MenuHandler mh, Preferences prefs) {
        String dataFontName = prefs.get("DataFont", "Lucida Sans Typewriter");
        int dataFontSize = prefs.getInt("DataFontSize", 12);
        this.font = new Font(dataFontName, 0, dataFontSize);
        this.menuHandler = mh;
        this.setTabPlacement(3);
        this.formattedText = new JTextArea(10, 90);
        this.formattedPane = this.setPanel(this.formattedText, this.font, "Formatted");
        this.formattedText.setLineWrap(mh.lineWrapItem.isSelected());
        this.formattedText.setText("Please use the 'File->Set root folder' command to tell DiskBrowser where your Apple disks are located.\n\nTo see the contents of a disk in more detail, double-click the disk. You will then be able to select individual files to view completely.");
        this.hexText = new JTextArea(10, 90);
        this.setPanel(this.hexText, this.font, "Hex dump");
        this.disassemblyText = new JTextArea(10, 90);
        this.setPanel(this.disassemblyText, this.font, "Disassembly");
        this.imagePanel = new ImagePanel();
        this.imagePane = new JScrollPane(this.imagePanel, 22, 31);
        this.setTabsFont(this.font);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                switch (DataPanel.this.getSelectedIndex()) {
                    case 0: {
                        if (DataPanel.this.formattedTextValid) break;
                        if (DataPanel.this.currentDataSource == null) {
                            DataPanel.this.formattedText.setText("");
                        } else {
                            DataPanel.this.setText(DataPanel.this.formattedText, DataPanel.this.currentDataSource.getText());
                        }
                        DataPanel.this.formattedTextValid = true;
                        break;
                    }
                    case 1: {
                        if (DataPanel.this.hexTextValid) break;
                        if (DataPanel.this.currentDataSource == null) {
                            DataPanel.this.hexText.setText("");
                        } else {
                            DataPanel.this.setText(DataPanel.this.hexText, DataPanel.this.currentDataSource.getHexDump());
                        }
                        DataPanel.this.hexTextValid = true;
                        break;
                    }
                    case 2: {
                        if (DataPanel.this.assemblerTextValid) break;
                        if (DataPanel.this.currentDataSource == null) {
                            DataPanel.this.disassemblyText.setText("");
                        } else {
                            DataPanel.this.setText(DataPanel.this.disassemblyText, DataPanel.this.currentDataSource.getAssembler());
                        }
                        DataPanel.this.assemblerTextValid = true;
                        break;
                    }
                    default: {
                        System.out.println("Invalid index selected in DataPanel");
                    }
                }
            }
        });
        mh.lineWrapItem.setAction(new LineWrapAction(this.formattedText));
    }

    private void setTabsFont(Font font) {
        this.formattedText.setFont(font);
        this.hexText.setFont(font);
        this.disassemblyText.setFont(font);
        this.imagePane.getVerticalScrollBar().setUnitIncrement(font.getSize());
    }

    public String getCurrentText() {
        int index = this.getSelectedIndex();
        return index == 0 ? this.formattedText.getText() : (index == 1 ? this.hexText.getText() : this.disassemblyText.getText());
    }

    private JScrollPane setPanel(JTextArea outputPanel, Font f, String tabName) {
        outputPanel.setEditable(false);
        outputPanel.setMargin(new Insets(5, 5, 5, 5));
        JScrollPane outputScrollPane = new JScrollPane(outputPanel, 22, 30);
        outputScrollPane.setBorder(null);
        this.add((Component)outputScrollPane, tabName);
        return outputScrollPane;
    }

    private void setDataSource(DataSource dataSource) {
        this.currentDataSource = dataSource;
        if (dataSource == null) {
            this.formattedText.setText("");
            this.hexText.setText("");
            this.disassemblyText.setText("");
            this.checkImage();
            return;
        }
        switch (this.getSelectedIndex()) {
            case 0: {
                this.setText(this.formattedText, dataSource.getText());
                this.hexTextValid = false;
                this.assemblerTextValid = false;
                break;
            }
            case 1: {
                this.setText(this.hexText, dataSource.getHexDump());
                this.formattedTextValid = false;
                this.assemblerTextValid = false;
                break;
            }
            case 2: {
                this.setText(this.disassemblyText, dataSource.getAssembler());
                this.hexTextValid = false;
                this.formattedTextValid = false;
                break;
            }
            default: {
                System.out.println("Invalid index selected in DataPanel");
            }
        }
        BufferedImage image = dataSource.getImage();
        if (image == null) {
            this.checkImage();
        } else {
            this.imagePanel.setImage(image);
            this.imagePane.setViewportView(this.imagePanel);
            if (!this.imageVisible) {
                int selected = this.getSelectedIndex();
                this.remove(this.formattedPane);
                this.add(this.imagePane, "Formatted", 0);
                this.setSelectedIndex(selected);
                this.imageVisible = true;
            }
        }
    }

    private void checkImage() {
        if (this.imageVisible) {
            int selected = this.getSelectedIndex();
            this.remove(this.imagePane);
            this.add(this.formattedPane, "Formatted", 0);
            this.setSelectedIndex(selected);
            this.imageVisible = false;
        }
    }

    private void setText(JTextArea textArea, String text) {
        textArea.setText(text);
        textArea.setCaretPosition(0);
    }

    @Override
    public void diskSelected(DiskSelectedEvent event) {
        this.setSelectedIndex(0);
        this.setDataSource(null);
        if (event.getFormattedDisk() != null) {
            this.setDataSource(event.getFormattedDisk().getCatalog().getDataSource());
        }
    }

    @Override
    public void fileSelected(FileSelectedEvent event) {
        this.setDataSource(event.file.getDataSource());
    }

    @Override
    public void sectorSelected(SectorSelectedEvent event) {
        List<DiskAddress> sectors = event.getSectors();
        if (sectors == null || sectors.size() == 0) {
            return;
        }
        if (sectors.size() == 1) {
            this.setDataSource(event.getFormattedDisk().getFormattedSector(sectors.get(0)));
        } else {
            this.setDataSource(new SectorList(event.getFormattedDisk(), sectors));
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals("DataFont")) {
            this.font = new Font(evt.getNewValue(), 0, this.font.getSize());
        }
        if (evt.getKey().equals("DataFontSize")) {
            this.font = new Font(this.font.getFontName(), 0, Integer.parseInt(evt.getNewValue()));
        }
        this.setTabsFont(this.font);
    }

    private class ImagePanel
    extends JPanel {
        private BufferedImage image;
        private int scale = 1;

        public ImagePanel() {
            this.setBackground(Color.gray);
        }

        private void setImage(BufferedImage image) {
            this.image = image;
            if (image != null) {
                Graphics2D g2 = image.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            int width = image.getWidth();
            int height = image.getHeight();
            if (width < 560) {
                this.scale = 560 / width;
            }
            if (this.scale > 4) {
                this.scale = 4;
            }
            this.setPreferredSize(new Dimension(width * this.scale, height * this.scale));
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image != null) {
                Graphics2D g2 = (Graphics2D)g;
                g2.transform(AffineTransform.getScaleInstance(this.scale, this.scale));
                g2.drawImage((Image)this.image, (this.getWidth() - this.image.getWidth() * this.scale) / 2 / this.scale, 4, this);
            }
        }
    }
}

