/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.dos;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.disk.AbstractSector;
import com.bytezone.diskbrowser.dos.DosDisk;

class DosVTOCSector
extends AbstractSector {
    DosDisk parentDisk;
    int volume;
    int DOSVersion;
    int maxTSPairs;
    int lastAllocTrack;
    int direction;
    int freeSectors;
    int usedSectors;

    public DosVTOCSector(DosDisk parentDisk, byte[] buffer) {
        super(buffer);
        this.parentDisk = parentDisk;
        this.DOSVersion = buffer[3];
        this.volume = HexFormatter.intValue(buffer[6]);
        this.maxTSPairs = buffer[39];
        this.lastAllocTrack = buffer[48];
        this.direction = buffer[49];
        this.flagSectors();
    }

    @Override
    public String createText() {
        StringBuilder text = this.getHeader("VTOC Sector");
        this.addText(text, this.buffer, 0, 1, "Not used");
        this.addText(text, this.buffer, 1, 2, "First directory track/sector");
        this.addText(text, this.buffer, 3, 1, "DOS release number");
        this.addText(text, this.buffer, 4, 2, "Not used");
        this.addTextAndDecimal(text, this.buffer, 6, 1, "Diskette volume");
        this.addTextAndDecimal(text, this.buffer, 39, 1, "Maximum TS pairs");
        this.addText(text, this.buffer, 40, 4, "Not used");
        this.addText(text, this.buffer, 44, 4, "Not used");
        this.addText(text, this.buffer, 48, 1, "Last allocated track");
        this.addText(text, this.buffer, 49, 1, "Direction to look when allocating the next file");
        this.addText(text, this.buffer, 50, 2, "Not used");
        this.addTextAndDecimal(text, this.buffer, 52, 1, "Maximum tracks");
        this.addTextAndDecimal(text, this.buffer, 53, 1, "Maximum sectors");
        this.addTextAndDecimal(text, this.buffer, 54, 2, "Bytes per sector");
        int i = 56;
        while (i <= 195) {
            String extra = i <= 64 ? "(DOS)" : (i == 124 ? "(VTOC and Catalog)" : "");
            this.addText(text, this.buffer, i, 4, String.format("Track %02X  %s  %s", (i - 56) / 4, this.getBitmap(this.buffer[i], this.buffer[i + 1]), extra));
            i += 4;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    private String getBitmap(byte left, byte right) {
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < 8) {
            if ((right & 1) == 1) {
                text.append(".");
            } else {
                text.append("X");
            }
            right = (byte)(right >> 1);
            ++i;
        }
        i = 0;
        while (i < 8) {
            if ((left & 1) == 1) {
                text.append(".");
            } else {
                text.append("X");
            }
            left = (byte)(left >> 1);
            ++i;
        }
        return text.toString();
    }

    public void flagSectors() {
        int block = 0;
        int i = 56;
        while (i <= 195) {
            block = this.check(this.buffer[i + 1], block);
            block = this.check(this.buffer[i], block);
            i += 4;
        }
    }

    private int check(byte b, int block) {
        int i = 0;
        while (i < 8) {
            if ((b & 1) == 1) {
                this.parentDisk.setSectorFree(block, true);
                ++this.freeSectors;
            } else {
                this.parentDisk.setSectorFree(block, false);
                ++this.usedSectors;
            }
            ++block;
            b = (byte)(b >> 1);
            ++i;
        }
        return block;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("DOS version      : 3." + this.DOSVersion);
        text.append("\nVolume           : " + this.volume);
        text.append("\nMax TS pairs     : " + this.maxTSPairs);
        text.append("\nLast allocated T : " + this.lastAllocTrack);
        text.append("\nDirection        : " + this.direction);
        return text.toString();
    }
}

