/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.dos;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.disk.AbstractSector;

class DosTSListSector
extends AbstractSector {
    String name;

    public DosTSListSector(String name, byte[] buffer) {
        super(buffer);
        this.name = name;
    }

    @Override
    public String createText() {
        StringBuilder text = this.getHeader("TS List Sector : " + this.name);
        this.addText(text, this.buffer, 0, 1, "Not used");
        this.addText(text, this.buffer, 1, 2, "Next TS list track/sector");
        this.addText(text, this.buffer, 3, 2, "Not used");
        this.addTextAndDecimal(text, this.buffer, 5, 2, "Sector base number");
        this.addText(text, this.buffer, 7, 4, "Not used");
        this.addText(text, this.buffer, 11, 1, "Not used");
        int sectorBase = HexFormatter.intValue(this.buffer[5], this.buffer[6]);
        int i = 12;
        while (i <= 255) {
            String message = this.buffer[i] == 0 && this.buffer[i + 1] == 0 ? "" : "Track/sector of file sector " + ((i - 10) / 2 + sectorBase);
            this.addText(text, this.buffer, i, 2, message);
            i += 2;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }
}

