/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.dos;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.applefile.ApplesoftBasicProgram;
import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.applefile.BootSector;
import com.bytezone.diskbrowser.applefile.DefaultAppleFile;
import com.bytezone.diskbrowser.applefile.HiResImage;
import com.bytezone.diskbrowser.applefile.IntegerBasicProgram;
import com.bytezone.diskbrowser.applefile.ShapeTable;
import com.bytezone.diskbrowser.applefile.SimpleText2;
import com.bytezone.diskbrowser.applefile.TextFile;
import com.bytezone.diskbrowser.disk.AbstractFormattedDisk;
import com.bytezone.diskbrowser.disk.AppleDisk;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.dos.DosCatalogSector;
import com.bytezone.diskbrowser.dos.DosTSListSector;
import com.bytezone.diskbrowser.dos.DosVTOCSector;
import com.bytezone.diskbrowser.gui.DataSource;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class DosDisk
extends AbstractFormattedDisk {
    DosVTOCSector dosVTOCSector;
    int maxTracks;
    int maxSectors;
    int sectorSize;
    int version;
    static final int ENTRY_SIZE = 35;
    static final int CATALOG_TRACK = 17;
    Color green = new Color(0, 200, 0);
    int freeSectors;
    int usedSectors;
    SectorType vtocSector = new SectorType("VTOC", Color.magenta);
    SectorType catalogSector = new SectorType("Catalog", this.green);
    SectorType tsListSector = new SectorType("TSList", Color.blue);
    SectorType dataSector = new SectorType("Data", Color.red);

    public DosDisk(Disk disk) {
        super(disk);
        int sector;
        int track;
        this.sectorTypesList.add(this.dosSector);
        this.sectorTypesList.add(this.vtocSector);
        this.sectorTypesList.add(this.catalogSector);
        this.sectorTypesList.add(this.tsListSector);
        this.sectorTypesList.add(this.dataSector);
        byte[] sectorBuffer = disk.readSector(0, 0);
        this.bootSector = new BootSector(sectorBuffer, "DOS");
        sectorBuffer = disk.readSector(17, 0);
        this.dosVTOCSector = new DosVTOCSector(this, sectorBuffer);
        DiskAddress catalogStart = disk.getDiskAddress(sectorBuffer[1], sectorBuffer[2]);
        this.version = sectorBuffer[3];
        this.maxTracks = sectorBuffer[52];
        this.maxSectors = sectorBuffer[53];
        this.sectorSize = HexFormatter.intValue(sectorBuffer[54], sectorBuffer[55]);
        if (this.sectorSize != disk.getBlockSize()) {
            System.out.println("Invalid sector size : " + this.sectorSize);
        }
        this.sectorType[272] = this.vtocSector;
        assert (this.maxSectors == disk.getSectorsPerTrack());
        assert (catalogStart.getTrack() == 17);
        DefaultMutableTreeNode rootNode = this.getCatalogTreeRoot();
        DefaultMutableTreeNode volumeNode = new DefaultMutableTreeNode();
        rootNode.add(volumeNode);
        DiskAddress da = disk.getDiskAddress(catalogStart.getBlock());
        do {
            if ((sectorBuffer = disk.readSector(da))[0] != 0 && (sectorBuffer[0] & 0xFF) != 255) {
                System.out.println("Dos catalog sector buffer byte #0 invalid : " + sectorBuffer[0]);
                break;
            }
            this.sectorType[da.getBlock()] = this.catalogSector;
        } while (disk.isValidAddress(track = sectorBuffer[1] & 0xFF, sector = sectorBuffer[2] & 0xFF) && (da = disk.getDiskAddress(track, sector)).getBlock() != 0);
        da = disk.getDiskAddress(catalogStart.getBlock());
        block1: do {
            sectorBuffer = disk.readSector(da);
            int ptr = 11;
            while (ptr < 256) {
                if (sectorBuffer[ptr] == 0) break block1;
                if (sectorBuffer[ptr] != -1) {
                    byte[] entry = new byte[35];
                    System.arraycopy(sectorBuffer, ptr, entry, 0, 35);
                    CatalogEntry catalogEntry = new CatalogEntry(da, entry);
                    this.fileEntries.add(catalogEntry);
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(catalogEntry);
                    node.setAllowsChildren(false);
                    volumeNode.add(node);
                }
                ptr += 35;
            }
        } while (disk.isValidAddress(track = sectorBuffer[1] & 0xFF, sector = sectorBuffer[2] & 0xFF) && (da = disk.getDiskAddress(sectorBuffer[1], sectorBuffer[2])).getBlock() != 0);
        for (DiskAddress da2 : disk) {
            int blockNo = da2.getBlock();
            if (blockNo < 48) {
                if (this.freeBlocks.get(blockNo)) {
                    ++this.freeSectors;
                } else {
                    ++this.usedSectors;
                    if (this.sectorType[blockNo] == this.usedSector) {
                        this.sectorType[blockNo] = this.dosSector;
                    }
                }
            } else if (this.stillAvailable(da2)) {
                ++this.freeSectors;
            } else {
                ++this.usedSectors;
            }
            if (this.freeBlocks.get(blockNo) && !this.stillAvailable(da2)) {
                ++this.falsePositives;
            }
            if (this.freeBlocks.get(blockNo) || !this.stillAvailable(da2)) continue;
            ++this.falseNegatives;
        }
        volumeNode.setUserObject(this.getCatalog());
        this.makeNodeVisible(volumeNode.getFirstLeaf());
    }

    public static boolean isCorrectFormat(AppleDisk disk) {
        disk.setInterleave(0);
        int catalogBlocks = DosDisk.checkFormat(disk);
        if (catalogBlocks > 3) {
            return true;
        }
        disk.setInterleave(1);
        if (DosDisk.checkFormat(disk) > catalogBlocks) {
            return true;
        }
        if (catalogBlocks > 0) {
            disk.setInterleave(0);
            return true;
        }
        return false;
    }

    private static int checkFormat(AppleDisk disk) {
        byte[] buffer = disk.readSector(17, 0);
        if (buffer[1] != 17) {
            return 0;
        }
        if (buffer[53] != 16) {
            System.out.println("VTOC tracks per sector : " + buffer[53]);
            return 0;
        }
        if (buffer[49] < -1 || buffer[49] > 1) {
            System.out.println("Bad direction : " + buffer[49]);
            return 0;
        }
        byte version = buffer[3];
        if (version < -1 || version > 4) {
            System.out.println("Bad version : " + buffer[3]);
            return 0;
        }
        return DosDisk.countCatalogBlocks(disk, buffer);
    }

    private static int countCatalogBlocks(AppleDisk disk, byte[] buffer) {
        DiskAddress catalogStart = disk.getDiskAddress(buffer[1], buffer[2]);
        int catalogBlocks = 0;
        DiskAddress da = disk.getDiskAddress(catalogStart.getBlock());
        while (disk.isValidAddress(da)) {
            buffer = disk.readSector(da);
            if (!disk.isValidAddress(buffer[1], buffer[2])) {
                System.out.printf("Invalid address : %02X / %02X%n", buffer[1], buffer[2]);
                break;
            }
            ++catalogBlocks;
            da = disk.getDiskAddress(buffer[1], buffer[2]);
            if (da.getBlock() != 0) continue;
        }
        return catalogBlocks;
    }

    public String toString() {
        StringBuffer text = new StringBuffer(this.dosVTOCSector.toString());
        return text.toString();
    }

    @Override
    public DataSource getFormattedSector(DiskAddress da) {
        SectorType type = this.sectorType[da.getBlock()];
        if (type == this.vtocSector) {
            return this.dosVTOCSector;
        }
        if (da.getBlock() == 0) {
            return this.bootSector;
        }
        byte[] buffer = this.disk.readSector(da);
        if (type == this.tsListSector) {
            return new DosTSListSector(this.getSectorFilename(da), buffer);
        }
        if (type == this.catalogSector) {
            return new DosCatalogSector(buffer);
        }
        if (type == this.dataSector) {
            return new DefaultSector("Data Sector : " + this.getSectorFilename(da), buffer);
        }
        if (type == this.dosSector) {
            return new DefaultSector("DOS sector", buffer);
        }
        if (type == this.emptySector) {
            return new DefaultSector("Empty sector", buffer);
        }
        if (type == this.usedSector) {
            return new DefaultSector("Orphan sector", buffer);
        }
        return new DefaultSector("!! Unknown sector type !!", buffer);
    }

    @Override
    public String getSectorFilename(DiskAddress da) {
        for (AppleFileSource ce : this.fileEntries) {
            if (!((CatalogEntry)ce).contains(da)) continue;
            return ((CatalogEntry)ce).name;
        }
        return null;
    }

    @Override
    public List<DiskAddress> getFileSectors(int fileNo) {
        if (this.fileEntries.size() > 0 && this.fileEntries.size() > fileNo) {
            return ((AppleFileSource)this.fileEntries.get(fileNo)).getSectors();
        }
        return null;
    }

    @Override
    public AppleFileSource getCatalog() {
        String newLine = String.format("%n", new Object[0]);
        String line = "- --- ---  ------------------------------  -----  -------------  -- ----  ----------------" + newLine;
        StringBuilder text = new StringBuilder();
        text.append(String.format("Disk : %s%n%n", this.disk.getFile().getAbsolutePath()));
        text.append("L Typ Len  Name                            Addr   Length         TS Data  Comment" + newLine);
        text.append(line);
        for (AppleFileSource ce : this.fileEntries) {
            text.append(String.valueOf(((CatalogEntry)ce).getDetails()) + newLine);
        }
        text.append(line);
        text.append(String.format("           Free sectors: %3d    Used sectors: %3d    Total sectors: %3d%n", this.dosVTOCSector.freeSectors, this.dosVTOCSector.usedSectors, this.dosVTOCSector.freeSectors + this.dosVTOCSector.usedSectors));
        if (this.dosVTOCSector.freeSectors != this.freeSectors) {
            text.append(String.format("Actual:    Free sectors: %3d    Used sectors: %3d    Total sectors: %3d%n", this.freeSectors, this.usedSectors, this.usedSectors + this.freeSectors));
        }
        return new DefaultAppleFileSource("Volume " + this.dosVTOCSector.volume, text.toString(), (FormattedDisk)this);
    }

    private class CatalogEntry
    implements AppleFileSource {
        String name;
        String catalogName;
        String shortName;
        FileType fileType;
        int reportedSize;
        boolean locked;
        private final List<DiskAddress> dataSectors = new ArrayList<DiskAddress>();
        private final List<DiskAddress> tsSectors = new ArrayList<DiskAddress>();
        int textFileGaps;
        private final DiskAddress catalogSectorDA;
        private DataSource appleFile;
        int length;
        int address;

        public CatalogEntry(DiskAddress catalogSector, byte[] entryBuffer) {
            DiskAddress da;
            this.catalogSectorDA = catalogSector;
            this.reportedSize = HexFormatter.intValue(entryBuffer[33], entryBuffer[34]);
            int type = HexFormatter.intValue(entryBuffer[2]);
            boolean bl = this.locked = (type & 0x80) > 0;
            if ((type & 0x7F) == 0) {
                this.fileType = FileType.Text;
            } else if ((type & 1) > 0) {
                this.fileType = FileType.IntegerBasic;
            } else if ((type & 2) > 0) {
                this.fileType = FileType.ApplesoftBasic;
            } else if ((type & 4) > 0) {
                this.fileType = FileType.Binary;
            } else if ((type & 8) > 0) {
                this.fileType = FileType.SS;
            } else if ((type & 0x10) > 0) {
                this.fileType = FileType.Relocatable;
            } else if ((type & 0x20) > 0) {
                this.fileType = FileType.AA;
            } else if ((type & 0x40) > 0) {
                this.fileType = FileType.BB;
            } else {
                System.out.println("Unknown file type : " + (type & 0x7F));
            }
            this.name = this.getName(entryBuffer, 0);
            this.catalogName = this.getCatalogName(entryBuffer, true);
            this.shortName = this.getCatalogName(entryBuffer, false);
            if (this.reportedSize > 0 && DosDisk.this.disk.isValidAddress(entryBuffer[0], entryBuffer[1])) {
                da = DosDisk.this.disk.getDiskAddress(entryBuffer[0], entryBuffer[1]);
                block4: while (da.getBlock() > 0) {
                    int startPtr;
                    if (DosDisk.this.stillAvailable(da)) {
                        ((DosDisk)DosDisk.this).sectorType[da.getBlock()] = DosDisk.this.tsListSector;
                    } else {
                        System.out.print("Attempt to assign TS sector to occupied sector : " + da);
                        System.out.println(" from " + this.name);
                    }
                    this.tsSectors.add(da);
                    byte[] sectorBuffer = DosDisk.this.disk.readSector(da);
                    int i = startPtr = 12;
                    int max = DosDisk.this.disk.getBlockSize();
                    while (i < max) {
                        da = this.getValidAddress(sectorBuffer, i);
                        if (da == null) {
                            System.out.print("T/S list in sector " + da);
                            System.out.printf(" contains an invalid address : %02X, %02X (file %s)%n", sectorBuffer[i], sectorBuffer[i + 1], this.name.trim());
                            break block4;
                        }
                        if (da.getBlock() == 0) {
                            if (this.fileType != FileType.Text) break;
                            ++this.textFileGaps;
                            this.dataSectors.add(null);
                        } else {
                            this.dataSectors.add(da);
                            if (DosDisk.this.stillAvailable(da)) {
                                ((DosDisk)DosDisk.this).sectorType[da.getBlock()] = DosDisk.this.dataSector;
                            } else {
                                System.out.print("Attempt to assign Data sector to occupied sector : " + da);
                                System.out.println(" from " + this.name);
                            }
                        }
                        i += 2;
                    }
                    da = this.getValidAddress(sectorBuffer, 1);
                    if (da != null) continue;
                    System.out.print("Next T/S list in sector " + da);
                    System.out.printf(" is invalid : %02X, %02X%n", sectorBuffer[1], sectorBuffer[2]);
                    break;
                }
            }
            if (this.fileType == FileType.Text) {
                while (this.dataSectors.size() > 0) {
                    da = this.dataSectors.get(this.dataSectors.size() - 1);
                    if (da != null) break;
                    this.dataSectors.remove(this.dataSectors.size() - 1);
                    --this.textFileGaps;
                }
            }
            if (this.dataSectors.size() > 0 && this.fileType != FileType.Text) {
                byte[] buffer = DosDisk.this.disk.readSector(this.dataSectors.get(0));
                switch (this.fileType) {
                    case IntegerBasic: {
                        this.length = HexFormatter.intValue(buffer[0], buffer[1]);
                        break;
                    }
                    case ApplesoftBasic: {
                        this.length = HexFormatter.intValue(buffer[0], buffer[1]);
                        break;
                    }
                    default: {
                        this.address = HexFormatter.intValue(buffer[0], buffer[1]);
                        this.length = HexFormatter.intValue(buffer[2], buffer[3]);
                    }
                }
            }
        }

        private String getName(byte[] buffer, int offset) {
            StringBuilder text = new StringBuilder();
            int i = 3;
            while (i < 33) {
                int c = HexFormatter.intValue(buffer[i + offset]);
                if (c == 136) {
                    if (text.length() > 0) {
                        text.deleteCharAt(text.length() - 1);
                    }
                } else {
                    if (c > 127) {
                        c = c < 160 ? (c -= 64) : (c -= 128);
                    }
                    if (c < 32) {
                        text.append("^" + (char)(c + 64));
                    } else {
                        text.append((char)c);
                    }
                }
                ++i;
            }
            return text.toString();
        }

        private DiskAddress getValidAddress(byte[] buffer, int offset) {
            if (DosDisk.this.disk.isValidAddress(buffer[offset], buffer[offset + 1])) {
                return DosDisk.this.disk.getDiskAddress(buffer[offset], buffer[offset + 1]);
            }
            return null;
        }

        private String getCatalogName(byte[] entryBuffer, boolean includeSize) {
            StringBuffer text = new StringBuffer();
            if (includeSize) {
                text.append(String.format("%s%s %03d ", this.locked ? "*" : " ", this.getFileType(), this.reportedSize));
            }
            int i = 3;
            while (i < 33) {
                int c = HexFormatter.intValue(entryBuffer[i]);
                if (c == 136) {
                    if (text.length() > 0) {
                        text.deleteCharAt(text.length() - 1);
                    }
                } else {
                    if (c > 127) {
                        c = c < 160 ? (c -= 64) : (c -= 128);
                    }
                    if (c < 32) {
                        text.append((char)(c + 64));
                    } else {
                        text.append((char)c);
                    }
                }
                ++i;
            }
            return text.toString();
        }

        private String getFileType() {
            switch (this.fileType) {
                case Text: {
                    return "T";
                }
                case IntegerBasic: {
                    return "I";
                }
                case ApplesoftBasic: {
                    return "A";
                }
                case Binary: {
                    return "B";
                }
                case SS: {
                    return "S";
                }
                case Relocatable: {
                    return "R";
                }
                case AA: {
                    return "A";
                }
                case BB: {
                    return "B";
                }
            }
            System.out.println("Unknown file type : " + (Object)((Object)this.fileType));
            return "?";
        }

        private boolean contains(DiskAddress da) {
            for (DiskAddress sector : this.tsSectors) {
                if (sector.compareTo(da) != 0) continue;
                return true;
            }
            for (DiskAddress sector : this.dataSectors) {
                if (sector == null || sector.compareTo(da) != 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public DataSource getDataSource() {
            if (this.appleFile != null) {
                return this.appleFile;
            }
            byte[] buffer = DosDisk.this.disk.readSectors(this.dataSectors);
            if (buffer.length == 0) {
                this.appleFile = new DefaultAppleFile(this.name, buffer);
                return this.appleFile;
            }
            switch (this.fileType) {
                case Text: {
                    this.appleFile = new TextFile(this.name, buffer);
                    break;
                }
                case IntegerBasic: {
                    int reportedLength = HexFormatter.intValue(buffer[0], buffer[1]);
                    byte[] exactBuffer = new byte[reportedLength];
                    System.arraycopy(buffer, 2, exactBuffer, 0, reportedLength);
                    this.appleFile = new IntegerBasicProgram(this.name, exactBuffer);
                    break;
                }
                case ApplesoftBasic: {
                    int reportedLength = HexFormatter.intValue(buffer[0], buffer[1]);
                    byte[] exactBuffer = new byte[reportedLength];
                    if (reportedLength > buffer.length) {
                        reportedLength = buffer.length - 2;
                    }
                    System.arraycopy(buffer, 2, exactBuffer, 0, reportedLength);
                    this.appleFile = new ApplesoftBasicProgram(this.name, exactBuffer);
                    break;
                }
                case Binary: 
                case Relocatable: {
                    if (buffer.length == 0) {
                        this.appleFile = new AssemblerProgram(this.name, buffer, 0);
                        break;
                    }
                    int loadAddress = HexFormatter.intValue(buffer[0], buffer[1]);
                    int reportedLength = HexFormatter.intValue(buffer[2], buffer[3]);
                    if (reportedLength == 0) {
                        System.out.println(String.valueOf(this.name.trim()) + " reported length : 0 - reverting to " + (buffer.length - 4));
                        reportedLength = buffer.length - 4;
                    }
                    byte[] exactBuffer = new byte[reportedLength];
                    if (buffer.length - 4 < reportedLength) {
                        System.arraycopy(buffer, 4, exactBuffer, 0, buffer.length - 4);
                    } else {
                        System.arraycopy(buffer, 4, exactBuffer, 0, reportedLength);
                    }
                    if (ShapeTable.isShapeTable(exactBuffer)) {
                        this.appleFile = new ShapeTable(this.name, exactBuffer);
                        break;
                    }
                    if (HiResImage.isGif(exactBuffer)) {
                        this.appleFile = new HiResImage(this.name, exactBuffer);
                        break;
                    }
                    if (loadAddress == 8192 || loadAddress == 16384) {
                        if (reportedLength > 7936 && reportedLength <= 16384) {
                            this.appleFile = new HiResImage(this.name, exactBuffer);
                            break;
                        }
                        if (this.name.trim().equals("FLY LOGO")) {
                            exactBuffer = this.unscrunch(exactBuffer);
                            this.appleFile = new HiResImage(this.name, exactBuffer);
                            break;
                        }
                        this.appleFile = new AssemblerProgram(this.name, exactBuffer, loadAddress);
                        break;
                    }
                    this.appleFile = new AssemblerProgram(this.name, exactBuffer, loadAddress);
                    break;
                }
                case SS: {
                    System.out.println("SS file");
                    this.appleFile = new DefaultAppleFile(this.name, buffer);
                    break;
                }
                case AA: {
                    System.out.println("AA file");
                    this.appleFile = new DefaultAppleFile(this.name, buffer);
                    break;
                }
                case BB: {
                    int loadAddress = HexFormatter.intValue(buffer[0], buffer[1]);
                    int reportedLength = HexFormatter.intValue(buffer[2], buffer[3]);
                    byte[] exactBuffer = new byte[reportedLength];
                    System.arraycopy(buffer, 4, exactBuffer, 0, reportedLength);
                    this.appleFile = new SimpleText2(this.name, exactBuffer, loadAddress);
                    break;
                }
                default: {
                    System.out.println("Unknown file type : " + (Object)((Object)this.fileType));
                    this.appleFile = new DefaultAppleFile(this.name, buffer);
                }
            }
            return this.appleFile;
        }

        private byte[] unscrunch(byte[] src) {
            byte[] dst = new byte[8192];
            int p1 = 0;
            int p2 = 0;
            while (p1 < dst.length) {
                byte b;
                if ((b = src[p2++]) == -128 || b == -1) {
                    b = (byte)(b & 0x7F);
                    int rpt = src[p2++];
                    int i = 0;
                    while (i < rpt) {
                        dst[p1++] = b;
                        ++i;
                    }
                    continue;
                }
                dst[p1++] = b;
            }
            return dst;
        }

        @Override
        public List<DiskAddress> getSectors() {
            ArrayList<DiskAddress> sectors = new ArrayList<DiskAddress>();
            sectors.add(this.catalogSectorDA);
            sectors.addAll(this.tsSectors);
            sectors.addAll(this.dataSectors);
            return sectors;
        }

        public String getDetails() {
            String lockedFlag;
            int actualSize = this.dataSectors.size() + this.tsSectors.size() - this.textFileGaps;
            String addressText = this.address == 0 ? "" : String.format("$%4X", this.address);
            String lengthText = this.length == 0 ? "" : String.format("$%4X  %,6d", this.length, this.length);
            String message = "";
            String string = lockedFlag = this.locked ? "*" : " ";
            if (this.reportedSize != actualSize) {
                message = String.valueOf(message) + "Bad size ";
            }
            if (this.dataSectors.size() == 0) {
                message = String.valueOf(message) + "No data ";
            }
            return String.format("%1s  %1s  %03d  %-30s  %-5s  %-13s  %2d %3d   %s", lockedFlag, this.getFileType(), this.reportedSize, this.shortName, addressText, lengthText, this.tsSectors.size(), this.dataSectors.size() - this.textFileGaps, message.trim());
        }

        public String toString() {
            return this.catalogName;
        }

        @Override
        public FormattedDisk getFormattedDisk() {
            return DosDisk.this;
        }

        @Override
        public String getUniqueName() {
            return this.name;
        }
    }

    private static enum FileType {
        Text,
        ApplesoftBasic,
        IntegerBasic,
        Binary,
        Relocatable,
        SS,
        AA,
        BB;

    }
}

