/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.dos;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.disk.AbstractSector;

class DosCatalogSector
extends AbstractSector {
    private static final String[] fileTypes = new String[]{"Text file", "Integer Basic program", "Applesoft Basic program", "Binary file", "SS file", "Relocatable file", "AA file", "BB file"};
    private static int CATALOG_ENTRY_SIZE = 35;

    public DosCatalogSector(byte[] buffer) {
        super(buffer);
    }

    @Override
    public String createText() {
        StringBuilder text = this.getHeader("Catalog Sector");
        this.addText(text, this.buffer, 0, 1, "Not used");
        this.addText(text, this.buffer, 1, 2, "Next catalog track/sector");
        this.addText(text, this.buffer, 3, 4, "Not used");
        this.addText(text, this.buffer, 7, 4, "Not used");
        int i = 11;
        while (i <= 255) {
            text.append("\n");
            if (this.buffer[i] == -1) {
                this.addText(text, this.buffer, i + 0, 2, "Deleted file @ " + HexFormatter.format2(this.buffer[i + 32]) + " " + HexFormatter.format2(this.buffer[i + 1]));
            } else {
                this.addText(text, this.buffer, i + 0, 2, "TS list track/sector");
            }
            this.addText(text, this.buffer, i + 2, 1, "File type " + this.getType(this.buffer[i + 2]));
            if (this.buffer[i + 3] == 0) {
                this.addText(text, this.buffer, i + 3, 4, "");
            } else {
                this.addText(text, this.buffer, i + 3, 4, this.getName(this.buffer, i));
            }
            this.addTextAndDecimal(text, this.buffer, i + 33, 2, "Sector count");
            i += CATALOG_ENTRY_SIZE;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    private String getName(byte[] buffer, int offset) {
        StringBuilder text = new StringBuilder();
        int i = 3;
        while (i < 33) {
            int c = HexFormatter.intValue(buffer[i + offset]);
            if (c == 136) {
                if (text.length() > 0) {
                    text.deleteCharAt(text.length() - 1);
                }
            } else {
                if (c > 127) {
                    c = c < 160 ? (c -= 64) : (c -= 128);
                }
                if (c < 32) {
                    text.append("^" + (char)(c + 64));
                } else {
                    text.append((char)c);
                }
            }
            ++i;
        }
        return text.toString();
    }

    private String getType(byte value) {
        int type = value & 0x7F;
        boolean locked = (value & 0x80) > 0;
        int val = 7;
        int i = 64;
        while (i > type) {
            --val;
            i /= 2;
        }
        return "(" + fileTypes[val] + (locked ? ", locked)" : ", unlocked)");
    }
}

