/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import java.util.ArrayList;
import java.util.List;

public class SectorListConverter {
    public final List<DiskAddress> sectors;
    public final String sectorText;

    public SectorListConverter(String text, Disk disk) {
        String[] blocks;
        this.sectors = new ArrayList<DiskAddress>();
        this.sectorText = text;
        String[] stringArray = blocks = text.split(";");
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int pos = s.indexOf(45);
            if (pos > 0) {
                int lo = Integer.parseInt(s.substring(0, pos));
                int hi = Integer.parseInt(s.substring(pos + 1));
                int i = lo;
                while (i <= hi) {
                    this.sectors.add(disk.getDiskAddress(i));
                    ++i;
                }
            } else {
                this.sectors.add(disk.getDiskAddress(Integer.parseInt(s)));
            }
            ++n2;
        }
    }

    public SectorListConverter(List<DiskAddress> sectors) {
        this.sectors = sectors;
        StringBuilder text = new StringBuilder();
        int firstBlock = -2;
        int runLength = 0;
        for (DiskAddress da : sectors) {
            if (da.getBlock() == firstBlock + 1 + runLength) {
                ++runLength;
                continue;
            }
            if (firstBlock >= 0) {
                this.addToText(text, firstBlock, runLength);
            }
            firstBlock = da.getBlock();
            runLength = 0;
        }
        this.addToText(text, firstBlock, runLength);
        this.sectorText = text.deleteCharAt(text.length() - 1).toString();
    }

    private void addToText(StringBuilder text, int firstBlock, int runLength) {
        if (runLength == 0) {
            text.append(String.valueOf(firstBlock) + ";");
        } else {
            text.append(String.valueOf(firstBlock) + "-" + (firstBlock + runLength) + ";");
        }
    }
}

