/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.FileSelectionListener;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class DualDosDisk
implements FormattedDisk,
FileSelectionListener {
    private final FormattedDisk[] disks = new FormattedDisk[2];
    private int currentDisk;
    private final JTree tree;

    public DualDosDisk(FormattedDisk disk0, FormattedDisk disk1) {
        String diskName = disk0.getDisk().getFile().getName();
        String text = "This disk contains both DOS and Prodos files. Isn't that clever?\n\n" + disk0.getDisk() + "\n" + disk1.getDisk();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new DefaultAppleFileSource(diskName, text, (FormattedDisk)this));
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(treeModel);
        treeModel.setAsksAllowsChildren(true);
        this.disks[0] = disk0;
        this.disks[1] = disk1;
        disk0.setParent(this);
        disk1.setParent(this);
        DefaultMutableTreeNode root0 = (DefaultMutableTreeNode)disk0.getCatalogTree().getModel().getRoot();
        DefaultMutableTreeNode root1 = (DefaultMutableTreeNode)disk1.getCatalogTree().getModel().getRoot();
        root.add((DefaultMutableTreeNode)root0.getChildAt(0));
        root.add((DefaultMutableTreeNode)root1.getChildAt(0));
    }

    @Override
    public JTree getCatalogTree() {
        return this.tree;
    }

    @Override
    public List<DiskAddress> getFileSectors(int fileNo) {
        return this.disks[this.currentDisk].getFileSectors(fileNo);
    }

    @Override
    public List<AppleFileSource> getCatalogList() {
        return this.disks[this.currentDisk].getCatalogList();
    }

    @Override
    public DataSource getFormattedSector(DiskAddress da) {
        return this.disks[this.currentDisk].getFormattedSector(da);
    }

    @Override
    public SectorType getSectorType(DiskAddress da) {
        return this.disks[this.currentDisk].getSectorType(da);
    }

    @Override
    public SectorType getSectorType(int track, int sector) {
        return this.disks[this.currentDisk].getSectorType(track, sector);
    }

    @Override
    public SectorType getSectorType(int block) {
        return this.disks[this.currentDisk].getSectorType(block);
    }

    @Override
    public List<SectorType> getSectorTypeList() {
        return this.disks[this.currentDisk].getSectorTypeList();
    }

    @Override
    public Disk getDisk() {
        return this.disks[this.currentDisk].getDisk();
    }

    public void setCurrentDisk(AppleFileSource afs) {
        FormattedDisk fd = afs.getFormattedDisk();
        if (this.disks[0] == fd && this.currentDisk != 0) {
            this.currentDisk = 0;
        } else if (this.disks[1] == fd && this.currentDisk != 1) {
            this.currentDisk = 1;
        }
        System.out.println("AFS : " + afs);
        System.out.println("1. Setting current disk to : " + this.currentDisk);
    }

    public void setCurrentDiskNo(int n) {
        this.currentDisk = n;
        System.out.println("2. Setting current disk to : " + this.currentDisk);
    }

    public int getCurrentDiskNo() {
        return this.currentDisk;
    }

    public FormattedDisk getCurrentDisk() {
        return this.disks[this.currentDisk];
    }

    @Override
    public void writeFile(AbstractFile file) {
        this.disks[this.currentDisk].writeFile(file);
    }

    @Override
    public AppleFileSource getCatalog() {
        return new DefaultAppleFileSource("text", String.valueOf(this.disks[0].getCatalog().getDataSource().getText()) + "\n\n" + this.disks[1].getCatalog().getDataSource().getText(), (FormattedDisk)this);
    }

    @Override
    public AppleFileSource getFile(String uniqueName) {
        return this.disks[this.currentDisk].getFile(uniqueName);
    }

    @Override
    public int clearOrphans() {
        return this.disks[this.currentDisk].clearOrphans();
    }

    @Override
    public boolean isSectorFree(DiskAddress da) {
        return this.disks[this.currentDisk].isSectorFree(da);
    }

    @Override
    public void verify() {
        this.disks[this.currentDisk].verify();
    }

    @Override
    public boolean stillAvailable(DiskAddress da) {
        return this.disks[this.currentDisk].stillAvailable(da);
    }

    @Override
    public void setSectorType(int block, SectorType type) {
        this.disks[this.currentDisk].setSectorType(block, type);
    }

    @Override
    public void setSectorFree(int block, boolean free) {
        this.disks[this.currentDisk].setSectorFree(block, free);
    }

    @Override
    public int falseNegativeBlocks() {
        return this.disks[this.currentDisk].falseNegativeBlocks();
    }

    @Override
    public int falsePositiveBlocks() {
        return this.disks[this.currentDisk].falsePositiveBlocks();
    }

    @Override
    public Dimension getGridLayout() {
        return this.disks[this.currentDisk].getGridLayout();
    }

    @Override
    public boolean isSectorFree(int block) {
        return this.disks[this.currentDisk].isSectorFree(block);
    }

    @Override
    public boolean stillAvailable(int block) {
        return this.disks[this.currentDisk].stillAvailable(block);
    }

    @Override
    public String getAbsolutePath() {
        return this.disks[this.currentDisk].getAbsolutePath();
    }

    @Override
    public FormattedDisk getParent() {
        return this.disks[this.currentDisk].getParent();
    }

    @Override
    public void setParent(FormattedDisk disk) {
        this.disks[this.currentDisk].setParent(disk);
    }

    @Override
    public void fileSelected(FileSelectedEvent event) {
        System.out.println("In DDD - file selected : " + event.file);
    }

    @Override
    public String getSectorFilename(DiskAddress da) {
        return this.disks[this.currentDisk].getSectorFilename(da);
    }

    @Override
    public String getName() {
        return this.disks[this.currentDisk].getName();
    }
}

