/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.disk.AbstractFormattedDisk;
import com.bytezone.diskbrowser.disk.AppleDisk;
import com.bytezone.diskbrowser.disk.DataDisk;
import com.bytezone.diskbrowser.disk.DualDosDisk;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.dos.DosDisk;
import com.bytezone.diskbrowser.infocom.InfocomDisk;
import com.bytezone.diskbrowser.pascal.PascalDisk;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import com.bytezone.diskbrowser.wizardry.WizardryScenarioDisk;
import java.io.File;

public class DiskFactory {
    private static boolean debug = false;

    private DiskFactory() {
    }

    public static FormattedDisk createDisk(File file) {
        return DiskFactory.createDisk(file.getAbsolutePath());
    }

    public static FormattedDisk createDisk(String path) {
        File file;
        if (debug) {
            System.out.println("Factory : " + path);
        }
        if (!(file = new File(path)).exists()) {
            return null;
        }
        String suffix = path.substring(path.lastIndexOf(".") + 1);
        FormattedDisk disk = null;
        AbstractFormattedDisk disk2 = null;
        if (suffix.equalsIgnoreCase("hdv")) {
            return DiskFactory.checkHardDisk(path);
        }
        if (file.length() != 143360L) {
            System.out.println("invalid file length : " + file.length());
            return null;
        }
        if (suffix.equalsIgnoreCase("dsk") || suffix.equalsIgnoreCase("do")) {
            disk = DiskFactory.checkDos(path);
            if (disk == null) {
                disk = DiskFactory.checkProdos(path);
            } else {
                if (debug) {
                    System.out.println("Checking DualDos disk");
                }
                if ((disk2 = DiskFactory.checkProdos(path)) != null) {
                    disk = new DualDosDisk(disk, disk2);
                }
            }
        } else if (suffix.equalsIgnoreCase("po") && (disk = DiskFactory.checkProdos(path)) == null) {
            disk = DiskFactory.checkDos(path);
        }
        if (disk == null) {
            disk = DiskFactory.checkPascalDisk(path);
        }
        if ((disk2 = DiskFactory.checkInfocomDisk(path)) != null) {
            disk = disk2;
        }
        if (disk == null) {
            disk = new DataDisk(new AppleDisk(new File(path), 35, 16));
        }
        if (debug) {
            System.out.println("  Factory creating disk : " + disk.getDisk().getFile().getAbsolutePath());
        }
        return disk;
    }

    private static DosDisk checkDos(String path) {
        AppleDisk disk;
        if (debug) {
            System.out.println("Checking DOS disk");
        }
        if (DosDisk.isCorrectFormat(disk = new AppleDisk(new File(path), 35, 16))) {
            return new DosDisk(disk);
        }
        if (debug) {
            System.out.println("Not a DOS disk");
        }
        return null;
    }

    private static ProdosDisk checkProdos(String path) {
        AppleDisk disk;
        if (debug) {
            System.out.println("Checking Prodos disk");
        }
        if (ProdosDisk.isCorrectFormat(disk = new AppleDisk(new File(path), 35, 8))) {
            return new ProdosDisk(disk);
        }
        if (debug) {
            System.out.println("Not a Prodos disk");
        }
        return null;
    }

    private static ProdosDisk checkHardDisk(String path) {
        AppleDisk disk;
        File f;
        if (debug) {
            System.out.println("Checking Prodos hard disk");
        }
        if ((f = new File(path)).length() % 512L != 0L) {
            if (debug) {
                System.out.println("invalid file size : " + f.length());
            }
            return null;
        }
        if (debug) {
            System.out.printf("Total tracks : %d%n", f.length() / 4096L);
        }
        if (ProdosDisk.isCorrectFormat(disk = new AppleDisk(f, (int)f.length() / 4096, 8))) {
            return new ProdosDisk(disk);
        }
        if (debug) {
            System.out.println("Not a Prodos hard disk");
        }
        return null;
    }

    private static FormattedDisk checkPascalDisk(String path) {
        AppleDisk disk;
        if (debug) {
            System.out.println("Checking Pascal disk");
        }
        if (!PascalDisk.isCorrectFormat(disk = new AppleDisk(new File(path), 35, 8), debug)) {
            return null;
        }
        if (debug) {
            System.out.println("Pascal disk OK - Checking Wizardry disk");
        }
        if (WizardryScenarioDisk.isWizardryFormat(disk, debug)) {
            if (debug) {
                System.out.println("Wizardry disk OK");
            }
            return new WizardryScenarioDisk(disk);
        }
        if (debug) {
            System.out.println("Not a Wizardry disk");
        }
        return new PascalDisk(disk);
    }

    private static InfocomDisk checkInfocomDisk(String path) {
        AppleDisk disk;
        if (debug) {
            System.out.println("Checking Infocom disk");
        }
        if (InfocomDisk.isCorrectFormat(disk = new AppleDisk(new File(path), 35, 16))) {
            return new InfocomDisk(disk);
        }
        if (debug) {
            System.out.println("Not an InfocomDisk disk");
        }
        return null;
    }
}

