/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;

public class AppleDiskAddress
implements DiskAddress {
    private final int block;
    private final int track;
    private final int sector;
    public final Disk owner;

    public AppleDiskAddress(int block, Disk owner) {
        this.owner = owner;
        this.block = block;
        int sectorsPerTrack = owner.getSectorsPerTrack();
        this.track = block / sectorsPerTrack;
        this.sector = block % sectorsPerTrack;
    }

    public AppleDiskAddress(int track, int sector, Disk owner) {
        this.owner = owner;
        this.track = track;
        this.sector = sector;
        this.block = track * owner.getSectorsPerTrack() + sector;
    }

    public String toString() {
        return String.format("[Block=%3d, Track=%2d, Sector=%2d]", this.block, this.track, this.sector);
    }

    @Override
    public int compareTo(DiskAddress that) {
        return this.block - that.getBlock();
    }

    @Override
    public int getBlock() {
        return this.block;
    }

    @Override
    public int getSector() {
        return this.sector;
    }

    @Override
    public int getTrack() {
        return this.track;
    }

    @Override
    public Disk getDisk() {
        return this.owner;
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.block == ((AppleDiskAddress)other).block;
    }
}

