/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.AppleDiskAddress;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AppleDisk
implements Disk {
    static final String newLine = String.format("%n", new Object[0]);
    static final int MAX_INTERLEAVE = 2;
    public final File path;
    private final byte[] diskBuffer;
    private final int tracks;
    private int sectors;
    private int blocks;
    private final int trackSize;
    public int sectorSize;
    private int interleave = 0;
    private static int[][] interleaveSector;
    private boolean[] hasData;
    private ActionListener actionListenerList;
    private List<DiskAddress> blockList;

    static {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[16];
        nArray2[1] = 14;
        nArray2[2] = 13;
        nArray2[3] = 12;
        nArray2[4] = 11;
        nArray2[5] = 10;
        nArray2[6] = 9;
        nArray2[7] = 8;
        nArray2[8] = 7;
        nArray2[9] = 6;
        nArray2[10] = 5;
        nArray2[11] = 4;
        nArray2[12] = 3;
        nArray2[13] = 2;
        nArray2[14] = 1;
        nArray2[15] = 15;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[16];
        nArray3[1] = 13;
        nArray3[2] = 11;
        nArray3[3] = 9;
        nArray3[4] = 7;
        nArray3[5] = 5;
        nArray3[6] = 3;
        nArray3[7] = 1;
        nArray3[8] = 14;
        nArray3[9] = 12;
        nArray3[10] = 10;
        nArray3[11] = 8;
        nArray3[12] = 6;
        nArray3[13] = 4;
        nArray3[14] = 2;
        nArray3[15] = 15;
        nArrayArray[2] = nArray3;
        interleaveSector = nArrayArray;
    }

    public AppleDisk(File path, int tracks, int sectors) {
        assert (path.exists()) : "No such path :" + path.getAbsolutePath();
        assert (!path.isDirectory()) : "File is directory :" + path.getAbsolutePath();
        assert (path.length() <= Integer.MAX_VALUE) : "File too large";
        assert (path.length() != 0L) : "File empty";
        this.blocks = tracks * sectors;
        this.sectorSize = (int)path.length() / this.blocks;
        this.trackSize = sectors * this.sectorSize;
        assert (this.sectorSize == 256 || this.sectorSize == 512) : "Invalid sector size : " + this.sectorSize;
        this.path = path;
        this.tracks = tracks;
        this.sectors = sectors;
        this.diskBuffer = new byte[tracks * sectors * this.sectorSize];
        this.hasData = new boolean[this.blocks];
        try {
            BufferedInputStream file = new BufferedInputStream(new FileInputStream(path));
            file.read(this.diskBuffer);
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.checkSectorsForData();
    }

    private void checkSectorsForData() {
        this.blockList = null;
        block0: for (DiskAddress da : this) {
            byte[] buffer = this.readSector(da);
            this.hasData[da.getBlock()] = false;
            int i = 0;
            while (i < this.sectorSize) {
                if (buffer[i] != 0) {
                    this.hasData[da.getBlock()] = true;
                    continue block0;
                }
                ++i;
            }
        }
    }

    @Override
    public int getSectorsPerTrack() {
        return this.trackSize / this.sectorSize;
    }

    @Override
    public int getTrackSize() {
        return this.trackSize;
    }

    @Override
    public int getBlockSize() {
        return this.sectorSize;
    }

    @Override
    public int getTotalBlocks() {
        return this.blocks;
    }

    @Override
    public int getTotalTracks() {
        return this.tracks;
    }

    @Override
    public boolean isSectorEmpty(DiskAddress da) {
        return !this.hasData[da.getBlock()];
    }

    @Override
    public boolean isSectorEmpty(int block) {
        return !this.hasData[block];
    }

    @Override
    public boolean isSectorEmpty(int track, int sector) {
        return !this.hasData[this.getDiskAddress(track, sector).getBlock()];
    }

    @Override
    public File getFile() {
        return this.path;
    }

    @Override
    public byte[] readSector(DiskAddress da) {
        byte[] buffer = new byte[this.sectorSize];
        this.readBuffer(da, buffer, 0);
        return buffer;
    }

    @Override
    public byte[] readSectors(List<DiskAddress> daList) {
        byte[] buffer = new byte[daList.size() * this.sectorSize];
        int bufferOffset = 0;
        for (DiskAddress da : daList) {
            if (da != null) {
                this.readBuffer(da, buffer, bufferOffset);
            }
            bufferOffset += this.sectorSize;
        }
        return buffer;
    }

    @Override
    public byte[] readSector(int track, int sector) {
        return this.readSector(this.getDiskAddress(track, sector));
    }

    @Override
    public byte[] readSector(int block) {
        return this.readSector(this.getDiskAddress(block));
    }

    @Override
    public int writeSector(DiskAddress da, byte[] buffer) {
        System.out.println("Not yet implemented");
        return -1;
    }

    @Override
    public void setInterleave(int interleave) {
        assert (interleave >= 0 && interleave <= 2) : "Invalid interleave";
        this.interleave = interleave;
        this.checkSectorsForData();
        if (this.actionListenerList != null) {
            this.notifyListeners("Interleave changed");
        }
    }

    @Override
    public int getInterleave() {
        return this.interleave;
    }

    @Override
    public void setBlockSize(int size) {
        assert (size == 256 || size == 512) : "Invalid sector size : " + size;
        if (this.sectorSize == size) {
            return;
        }
        this.sectorSize = size;
        this.sectors = this.trackSize / this.sectorSize;
        this.blocks = this.tracks * this.sectors;
        this.hasData = new boolean[this.blocks];
        this.checkSectorsForData();
        if (this.actionListenerList != null) {
            this.notifyListeners("Sector size changed");
        }
    }

    @Override
    public DiskAddress getDiskAddress(int block) {
        assert (this.isValidAddress(block)) : "Invalid block : " + block;
        return new AppleDiskAddress(block, this);
    }

    @Override
    public List<DiskAddress> getDiskAddressList(int ... blocks) {
        ArrayList<DiskAddress> addressList = new ArrayList<DiskAddress>();
        int[] nArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            int block = nArray[n2];
            assert (this.isValidAddress(block)) : "Invalid block : " + block;
            addressList.add(new AppleDiskAddress(block, this));
            ++n2;
        }
        return addressList;
    }

    @Override
    public DiskAddress getDiskAddress(int track, int sector) {
        assert (this.isValidAddress(track, sector)) : "Invalid address : " + track + ", " + sector;
        return new AppleDiskAddress(track, sector, this);
    }

    @Override
    public boolean isValidAddress(int block) {
        return block >= 0 && block < this.blocks;
    }

    @Override
    public boolean isValidAddress(int track, int sector) {
        if (track < 0 || track >= this.tracks) {
            return false;
        }
        return sector >= 0 && sector < this.sectors;
    }

    @Override
    public boolean isValidAddress(DiskAddress da) {
        return this.isValidAddress(da.getTrack(), da.getSector());
    }

    private void readBuffer(DiskAddress da, byte[] buffer, int bufferOffset) {
        if (da.getDisk() != this) {
            System.out.println(da.getDisk());
            System.out.println(this);
        }
        assert (da.getDisk() == this) : "Disk address not applicable to this disk";
        assert (this.sectorSize == 256 || this.sectorSize == 512) : "Invalid sector size : " + this.sectorSize;
        assert (this.interleave >= 0 && this.interleave <= 2) : "Invalid interleave : " + this.interleave;
        if (this.sectorSize == 256) {
            int diskOffset = da.getTrack() * this.trackSize + interleaveSector[this.interleave][da.getSector()] * this.sectorSize;
            System.arraycopy(this.diskBuffer, diskOffset, buffer, bufferOffset, this.sectorSize);
        } else if (this.sectorSize == 512) {
            int diskOffset = da.getTrack() * this.trackSize + interleaveSector[this.interleave][da.getSector() * 2] * 256;
            System.arraycopy(this.diskBuffer, diskOffset, buffer, bufferOffset, 256);
            diskOffset = da.getTrack() * this.trackSize + interleaveSector[this.interleave][da.getSector() * 2 + 1] * 256;
            System.arraycopy(this.diskBuffer, diskOffset, buffer, bufferOffset + 256, 256);
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListenerList = AWTEventMulticaster.add(this.actionListenerList, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.actionListenerList = AWTEventMulticaster.remove(this.actionListenerList, actionListener);
    }

    public void notifyListeners(String text) {
        if (this.actionListenerList != null) {
            this.actionListenerList.actionPerformed(new ActionEvent(this, 1001, text));
        }
    }

    public AppleFileSource getDetails() {
        return new DefaultAppleFileSource(this.toString(), this.path.getName(), null);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("Path............ " + this.path.getAbsolutePath() + newLine);
        text.append("Tracks.......... " + this.tracks + newLine);
        text.append("Sectors......... " + this.sectors + newLine);
        text.append("Blocks.......... " + this.blocks + newLine);
        text.append("Sector size..... " + this.sectorSize + newLine);
        text.append("Interleave...... " + this.interleave + newLine);
        return text.toString();
    }

    @Override
    public Iterator<DiskAddress> iterator() {
        if (this.blockList == null) {
            this.blockList = new ArrayList<DiskAddress>(this.blocks);
            int block = 0;
            while (block < this.blocks) {
                this.blockList.add(new AppleDiskAddress(block, this));
                ++block;
            }
        }
        return this.blockList.iterator();
    }
}

