/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.catalog;

import com.bytezone.diskbrowser.catalog.AbstractCatalogCreator;
import com.bytezone.diskbrowser.disk.DiskFactory;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.TreeBuilder;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class TextCatalogCreator
extends AbstractCatalogCreator {
    @Override
    public void createCatalog() {
        Object o = this.node.getUserObject();
        if (!(o instanceof TreeBuilder.FileNode)) {
            JOptionPane.showMessageDialog(null, "Please select a folder from the Disk Tree", "Info", 1);
            return;
        }
        File f = ((TreeBuilder.FileNode)o).file;
        final File f2 = new File(String.valueOf(f.getAbsolutePath()) + "/Catalog.txt");
        JOptionPane.showMessageDialog(null, "About to create file : " + f2.getAbsolutePath(), "Info", 1);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileWriter out = null;
                try {
                    try {
                        out = new FileWriter(f2);
                        this.printDescendants(TextCatalogCreator.this.node, out);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(null, "Error creating catalog : " + e.getMessage(), "Bugger", 1);
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            private void printDescendants(DefaultMutableTreeNode root, FileWriter out) throws IOException {
                Enumeration<TreeNode> children;
                File f;
                Object o = root.getUserObject();
                if (o instanceof TreeBuilder.FileNode && !(f = ((TreeBuilder.FileNode)root.getUserObject()).file).isDirectory()) {
                    FormattedDisk fd = DiskFactory.createDisk(f.getAbsolutePath());
                    out.write(String.valueOf(fd.getCatalog().getDataSource().getText()) + String.format("%n", new Object[0]));
                }
                if ((children = root.children()) != null) {
                    while (children.hasMoreElements()) {
                        this.printDescendants((DefaultMutableTreeNode)children.nextElement(), out);
                    }
                }
            }
        });
    }

    @Override
    public String getMenuText() {
        return "Create catalog text";
    }
}

