/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;

public class ShapeTable
extends AbstractFile {
    public ShapeTable(String name, byte[] buffer) {
        super(name, buffer);
    }

    @Override
    public String getText() {
        StringBuffer text = new StringBuffer();
        int totalShapes = this.buffer[0] & 0xFF;
        int i = 0;
        while (i < totalShapes) {
            int offset = HexFormatter.intValue(this.buffer[i * 2 + 2], this.buffer[i * 2 + 3]);
            int[][] grid = new int[150][150];
            int row = 74;
            int col = 74;
            if (i > 0) {
                text.append("\n");
            }
            text.append("Shape " + i + " :\n");
            while (this.buffer[offset++] != 0) {
                int value = HexFormatter.intValue(this.buffer[offset - 1]);
                int v1 = value >> 6;
                int v2 = (value & 0x38) >> 3;
                int v3 = value & 7;
                if (v3 >= 4) {
                    grid[row][col] = 1;
                    int[] nArray = grid[0];
                    int n = col;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = grid[row];
                    nArray2[0] = nArray2[0] + 1;
                }
                if (v3 == 0 || v3 == 4) {
                    --row;
                } else if (v3 == 1 || v3 == 5) {
                    ++col;
                } else if (v3 == 2 || v3 == 6) {
                    ++row;
                } else {
                    --col;
                }
                if (v2 >= 4) {
                    grid[row][col] = 1;
                    int[] nArray = grid[0];
                    int n = col;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray3 = grid[row];
                    nArray3[0] = nArray3[0] + 1;
                }
                if (v2 == 0 && v1 != 0) {
                    --row;
                } else if (v2 == 4) {
                    --row;
                } else if (v2 == 1 || v2 == 5) {
                    ++col;
                } else if (v2 == 2 || v2 == 6) {
                    ++row;
                } else if (v2 == 3 || v2 == 7) {
                    --col;
                }
                if (v1 == 1) {
                    ++col;
                    continue;
                }
                if (v1 == 2) {
                    ++row;
                    continue;
                }
                if (v1 != 3) continue;
                --col;
            }
            text.append("\n");
            int minRow = 99;
            int maxRow = 0;
            int minCol = 99;
            int maxCol = 0;
            row = 1;
            while (row < grid.length) {
                if (grid[row][0] > 0) {
                    if (row < minRow) {
                        minRow = row;
                    }
                    if (row > maxRow) {
                        maxRow = row;
                    }
                }
                ++row;
            }
            col = 1;
            while (col < grid[0].length) {
                if (grid[0][col] > 0) {
                    if (col < minCol) {
                        minCol = col;
                    }
                    if (col > maxCol) {
                        maxCol = col;
                    }
                }
                ++col;
            }
            row = minRow;
            while (row <= maxRow) {
                col = minCol;
                while (col <= maxCol) {
                    if (grid[row][col] == 0) {
                        text.append("  ");
                    } else {
                        text.append(" X");
                    }
                    ++col;
                }
                text.append("\n");
                ++row;
            }
            ++i;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    public static boolean isShapeTable(byte[] buffer) {
        if (buffer.length == 0) {
            return false;
        }
        int totalShapes = buffer[0] & 0xFF;
        if (totalShapes == 0) {
            return false;
        }
        int lastOffset = 0;
        int i = 0;
        while (i < totalShapes) {
            int ptr = i * 2 + 2;
            if (ptr >= buffer.length - 1) {
                return false;
            }
            int offset = HexFormatter.intValue(buffer[ptr], buffer[ptr + 1]);
            if (offset == 0 || offset < lastOffset || offset >= buffer.length) {
                return false;
            }
            lastOffset = offset;
            ++i;
        }
        return true;
    }
}

