/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;

public class PascalText
extends AbstractFile {
    public PascalText(String name, byte[] buffer) {
        super(name, buffer);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder(this.getHeader());
        int ptr = 1024;
        while (ptr < this.buffer.length) {
            if (this.buffer[ptr] == 0) {
                ++ptr;
                continue;
            }
            if (this.buffer[ptr] == 16) {
                int tab = this.buffer[ptr + 1] - 32;
                while (tab-- > 0) {
                    text.append(" ");
                }
                ptr += 2;
            }
            String line = this.getLine(ptr);
            text.append(String.valueOf(line) + "\n");
            ptr += line.length() + 1;
        }
        return text.toString();
    }

    private String getHeader() {
        return "Name : " + this.name + "\n\n";
    }

    private String getLine(int ptr) {
        StringBuilder line = new StringBuilder();
        while (this.buffer[ptr] != 13) {
            line.append((char)this.buffer[ptr++]);
        }
        return line.toString();
    }
}

