/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.PascalConstants;
import java.util.ArrayList;
import java.util.List;

public class PascalCodeStatement
implements PascalConstants {
    private static final String[] compValue = new String[]{"invalid", "", "REAL", "", "STR", "", "BOOL", "", "POWR", "", "BYT", "", "WORD"};
    int length;
    int val;
    int p1;
    int p2;
    int p3;
    String mnemonic;
    String extras = "";
    String description;
    String text;
    int ptr;
    byte[] buffer;
    boolean jumpTarget;
    List<Jump> jumps = new ArrayList<Jump>();

    public PascalCodeStatement(byte[] buffer, int ptr, int procPtr) {
        this.ptr = ptr;
        this.buffer = buffer;
        this.length = 1;
        this.val = buffer[ptr] & 0xFF;
        if (this.val <= 127) {
            this.mnemonic = "SLDC";
            this.extras = "#" + this.val;
            this.description = "Short load constant - push #" + this.val;
        } else if (this.val >= 248) {
            this.mnemonic = "SIND";
            this.extras = "#" + (this.val - 248);
            this.description = "Short index load - push word *ToS + #" + (this.val - 248);
        } else if (this.val >= 232) {
            this.mnemonic = "SLDO";
            this.extras = "#" + (this.val - 231);
            this.description = "Short load global - push BASE + #" + (this.val - 231);
        } else if (this.val >= 216) {
            this.mnemonic = "SLDL";
            this.extras = "#" + (this.val - 215);
            this.description = "Short load local - push MP + #" + (this.val - 215);
        } else {
            this.mnemonic = mnemonics[this.val - 128];
            this.description = descriptions[this.val - 128];
            this.length = mnemonicSize[this.val - 128];
            if (this.length != 1) {
                switch (this.val) {
                    case 172: {
                        int padding = ptr % 2 == 0 ? 1 : 0;
                        this.p1 = this.getWord(buffer, ptr + padding + 1);
                        this.p2 = this.getWord(buffer, ptr + padding + 3);
                        this.p3 = this.getWord(buffer, ptr + padding + 5);
                        this.length = (this.p2 - this.p1 + 1) * 2 + 7 + padding;
                        this.setParameters(this.p1, this.p2, String.format("%04X", this.p3));
                        int v = this.p1;
                        int min = ptr + padding + 7;
                        int max = min + (this.p2 - this.p1) * 2;
                        int i = min;
                        while (i <= max) {
                            this.jumps.add(new Jump(i, i - HexFormatter.intValue(buffer[i], buffer[i + 1]), v++));
                            i += 2;
                        }
                        break;
                    }
                    case 179: {
                        this.p1 = buffer[ptr + 1] & 0xFF;
                        int padding = ptr % 2 == 0 ? 0 : 1;
                        this.length = this.p1 * 2 + padding + 2;
                        this.setParameters(this.p1);
                        break;
                    }
                    case 166: 
                    case 208: {
                        this.p1 = buffer[ptr + 1] & 0xFF;
                        this.length = this.p1 + 2;
                        if (this.val != 166) break;
                        this.text = HexFormatter.getPascalString(buffer, ptr + 1);
                        this.description = String.valueOf(this.description) + ": " + this.text;
                        break;
                    }
                    case 199: {
                        this.p1 = this.getWord(buffer, ptr + 1);
                        this.setParameters(this.p1);
                        break;
                    }
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 168: 
                    case 169: 
                    case 171: 
                    case 198: 
                    case 202: 
                    case 204: 
                    case 213: {
                        this.length = this.getLengthOfB(buffer[ptr + 1]) + 1;
                        this.p1 = this.getValueOfB(buffer, ptr + 1, this.length - 1);
                        this.setParameters(this.p1);
                        break;
                    }
                    case 157: 
                    case 167: 
                    case 178: 
                    case 182: 
                    case 184: 
                    case 209: {
                        this.length = this.getLengthOfB(buffer[ptr + 2]) + 2;
                        this.p1 = buffer[ptr + 1] & 0xFF;
                        this.p2 = this.getValueOfB(buffer, ptr + 2, this.length - 2);
                        this.setParameters(this.p1, this.p2);
                        break;
                    }
                    case 192: 
                    case 205: {
                        this.p1 = buffer[ptr + 1] & 0xFF;
                        this.p2 = buffer[ptr + 2] & 0xFF;
                        this.setParameters(this.p1, this.p2);
                        break;
                    }
                    case 161: 
                    case 173: 
                    case 185: 
                    case 193: 
                    case 211: 
                    case 212: {
                        this.p1 = buffer[ptr + 1];
                        if (this.val == 173 || this.val == 193) {
                            this.setParameters(this.p1);
                            break;
                        }
                        if (this.p1 < 0) {
                            int address = procPtr + this.p1;
                            int ptr2 = address - ((buffer[address + 1] & 0xFF) * 256 + (buffer[address] & 0xFF));
                            this.extras = String.format("$%04X", ptr2);
                            this.jumps.add(new Jump(ptr, ptr2));
                            break;
                        }
                        int address = ptr + this.length + this.p1;
                        this.extras = String.format("$%04X", address);
                        this.jumps.add(new Jump(ptr, address));
                        break;
                    }
                    case 160: 
                    case 170: 
                    case 174: 
                    case 188: 
                    case 189: 
                    case 194: 
                    case 206: 
                    case 207: {
                        this.p1 = buffer[ptr + 1] & 0xFF;
                        this.setParameters(this.p1);
                        break;
                    }
                    case 158: {
                        this.p1 = buffer[ptr + 1];
                        this.description = "Call standard procedure - " + CSP[this.p1];
                        break;
                    }
                    case 175: 
                    case 176: 
                    case 177: 
                    case 180: 
                    case 181: 
                    case 183: {
                        this.p1 = buffer[ptr + 1];
                        if (this.p1 < 0 || this.p1 >= compValue.length) {
                            System.out.printf("%d  %d  %d%n", this.val, this.p1, ptr);
                            this.mnemonic = String.valueOf(this.mnemonic) + "******************************";
                            break;
                        }
                        this.mnemonic = String.valueOf(this.mnemonic) + compValue[this.p1];
                        if (this.p1 != 10 && this.p1 != 12) break;
                        this.length = this.getLengthOfB(buffer[ptr + 2]) + 2;
                        this.p2 = this.getValueOfB(buffer, ptr + 2, this.length - 2);
                        this.setParameters(this.p2);
                        break;
                    }
                    default: {
                        System.out.println("Forgot : " + this.val);
                    }
                }
            }
        }
    }

    private int getWord(byte[] buffer, int ptr) {
        return (buffer[ptr + 1] & 0xFF) * 256 + (buffer[ptr] & 0xFF);
    }

    private int getLengthOfB(byte b) {
        return (b & 0x80) == 128 ? 2 : 1;
    }

    private int getValueOfB(byte[] buffer, int ptr, int length) {
        if (length == 2) {
            return (buffer[ptr] & 0x7F) * 256 + (buffer[ptr + 1] & 0xFF);
        }
        return buffer[ptr] & 0xFF;
    }

    private void setParameters(int p1) {
        this.description = this.description.replaceFirst(":1", String.valueOf(p1));
        this.extras = "#" + p1;
    }

    private void setParameters(int p1, int p2) {
        this.setParameters(p1);
        this.extras = String.valueOf(this.extras) + ", #" + p2;
        this.description = this.description.replaceFirst(":2", String.valueOf(p2));
    }

    private void setParameters(int p1, int p2, String p3) {
        this.setParameters(p1, p2);
        this.description = this.description.replaceFirst(":3", p3);
    }

    public String toString() {
        String hex = this.getHex(this.buffer, this.ptr, this.length > 4 ? 4 : this.length);
        StringBuilder text = new StringBuilder();
        text.append(String.format("%2s%05X: %-11s  %-6s %-8s   %s%n", this.jumpTarget ? "->" : "", this.ptr, hex, this.mnemonic, this.extras, this.description));
        if (this.length > 4) {
            int bytesLeft = this.length - 4;
            int jmp = 0;
            int p = this.ptr + 4;
            while (bytesLeft > 0) {
                String line = this.getHex(this.buffer, p, bytesLeft > 4 ? 4 : bytesLeft);
                text.append("         " + line);
                if (this.jumps.size() > 0) {
                    if (jmp < this.jumps.size()) {
                        text.append("                     " + this.jumps.get(jmp++));
                    }
                    if (jmp < this.jumps.size()) {
                        text.append("   " + this.jumps.get(jmp++));
                    }
                }
                text.append("\n");
                bytesLeft -= 4;
                p += 4;
            }
        }
        return text.toString();
    }

    private String getHex(byte[] buffer, int offset, int length) {
        if (offset + length >= buffer.length) {
            System.out.println("too many");
            return "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        }
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < length) {
            text.append(String.format("%02X ", buffer[offset + i]));
            ++i;
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    class Jump {
        int addressFrom;
        int addressTo;
        boolean caseJump;
        int caseValue;

        public Jump(int addressFrom, int addressTo) {
            this.addressFrom = addressFrom;
            this.addressTo = addressTo;
        }

        public Jump(int addressFrom, int addressTo, int value) {
            this(addressFrom, addressTo);
            this.caseValue = value;
            this.caseJump = true;
        }

        public String toString() {
            if (this.caseJump) {
                return String.format("%3d: %04X", this.caseValue, this.addressTo);
            }
            return String.format("%04X", this.addressTo);
        }
    }
}

