/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AssemblerConstants;
import java.util.Arrays;
import java.util.Comparator;

public class AssemblerStatement {
    public byte value;
    public String mnemonic;
    public String operand;
    public int size;
    public int mode;
    public int opcode;
    public int location;
    public int offset;
    public String comment;

    public static void print() {
        AssemblerStatement as;
        AssemblerStatement[] statements = new AssemblerStatement[256];
        int i = 0;
        while (i < 256) {
            if (i % 16 == 0 && i > 0) {
                System.out.println();
            }
            statements[i] = as = new AssemblerStatement((byte)i);
            if (as.size == 1) {
                as.addData();
            } else if (as.size == 2) {
                as.addData((byte)1);
            } else if (as.size == 3) {
                as.addData((byte)1, (byte)1);
            }
            if (i / 8 % 2 == 0) {
                System.out.printf("%02X %s", i, as);
            }
            ++i;
        }
        Arrays.sort(statements, new Comparator<AssemblerStatement>(){

            @Override
            public int compare(AssemblerStatement o1, AssemblerStatement o2) {
                if (o1.mnemonic.equals(o2.mnemonic)) {
                    return o1.mode == o2.mode ? 0 : (o1.mode < o2.mode ? -1 : 1);
                }
                return o1.mnemonic.compareTo(o2.mnemonic);
            }
        });
        String lastMnemonic = "";
        AssemblerStatement[] assemblerStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            as = assemblerStatementArray[n2];
            if (as.size > 0) {
                if (!as.mnemonic.equals(lastMnemonic)) {
                    lastMnemonic = as.mnemonic;
                    System.out.println();
                }
                System.out.printf("%3s  %-15s  %s%n", as.mnemonic, AssemblerConstants.mode[as.mode], as);
            }
            ++n2;
        }
    }

    public AssemblerStatement(byte opcode) {
        this.value = opcode;
        this.opcode = HexFormatter.intValue(opcode);
        this.mnemonic = AssemblerConstants.mnemonics[this.opcode];
        this.size = AssemblerConstants.sizes2[this.opcode];
        this.operand = "";
    }

    public void addData() {
        switch (this.opcode) {
            case 0: 
            case 8: 
            case 24: 
            case 40: 
            case 56: 
            case 64: 
            case 72: 
            case 88: 
            case 90: 
            case 96: 
            case 104: 
            case 120: 
            case 122: 
            case 136: 
            case 138: 
            case 152: 
            case 154: 
            case 168: 
            case 170: 
            case 184: 
            case 186: 
            case 200: 
            case 202: 
            case 216: 
            case 218: 
            case 232: 
            case 234: 
            case 248: 
            case 250: {
                this.mode = 0;
                break;
            }
            case 10: 
            case 26: 
            case 42: 
            case 58: 
            case 74: 
            case 106: {
                this.mode = 1;
                break;
            }
            default: {
                System.out.println("Not found (0) : " + this.opcode);
            }
        }
    }

    public void addData(byte b) {
        String address = "$" + HexFormatter.format2(b);
        if (this.mnemonic.equals("JSR")) {
            this.location = HexFormatter.intValue(b);
        }
        switch (this.opcode) {
            case 9: 
            case 41: 
            case 73: 
            case 105: 
            case 137: 
            case 160: 
            case 162: 
            case 169: 
            case 192: 
            case 201: 
            case 224: 
            case 233: {
                this.operand = "#" + address;
                this.mode = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 20: 
            case 36: 
            case 37: 
            case 38: 
            case 69: 
            case 70: 
            case 100: 
            case 101: 
            case 102: 
            case 132: 
            case 133: 
            case 134: 
            case 164: 
            case 165: 
            case 166: 
            case 196: 
            case 197: 
            case 198: 
            case 228: 
            case 229: 
            case 230: {
                this.operand = address;
                this.mode = 8;
                break;
            }
            case 21: 
            case 22: 
            case 52: 
            case 53: 
            case 54: 
            case 85: 
            case 86: 
            case 116: 
            case 117: 
            case 118: 
            case 148: 
            case 149: 
            case 180: 
            case 181: 
            case 213: 
            case 214: 
            case 245: 
            case 246: {
                this.operand = String.valueOf(address) + ",X";
                this.mode = 9;
                break;
            }
            case 150: 
            case 182: {
                this.operand = String.valueOf(address) + ",Y";
                this.mode = 10;
                break;
            }
            case 1: 
            case 33: 
            case 65: 
            case 97: 
            case 129: 
            case 161: 
            case 193: 
            case 225: {
                this.operand = "(" + address + ",X)";
                this.mode = 11;
                break;
            }
            case 17: 
            case 49: 
            case 81: 
            case 113: 
            case 145: 
            case 177: 
            case 209: 
            case 241: {
                this.operand = "(" + address + "),Y";
                this.mode = 12;
                break;
            }
            case 18: 
            case 50: 
            case 82: 
            case 114: 
            case 146: 
            case 178: 
            case 210: 
            case 242: {
                this.operand = "(" + address + ")";
                this.mode = 13;
                break;
            }
            case 16: 
            case 48: 
            case 80: 
            case 112: 
            case 128: 
            case 144: 
            case 176: 
            case 208: 
            case 240: {
                this.offset = b;
                this.mode = 14;
                break;
            }
            default: {
                System.out.println("Not found (1) : " + this.opcode);
            }
        }
    }

    public void addData(byte b1, byte b2) {
        String address = "$" + HexFormatter.format2(b2) + HexFormatter.format2(b1);
        if (this.mnemonic.equals("JSR") || this.mnemonic.equals("JMP")) {
            this.location = HexFormatter.intValue(b1, b2);
        }
        switch (this.opcode) {
            case 12: 
            case 13: 
            case 14: 
            case 28: 
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 76: 
            case 77: 
            case 78: 
            case 109: 
            case 110: 
            case 140: 
            case 141: 
            case 142: 
            case 156: 
            case 172: 
            case 173: 
            case 174: 
            case 204: 
            case 205: 
            case 206: 
            case 236: 
            case 237: 
            case 238: {
                this.operand = address;
                this.mode = 3;
                break;
            }
            case 29: 
            case 30: 
            case 60: 
            case 61: 
            case 62: 
            case 93: 
            case 94: 
            case 125: 
            case 126: 
            case 157: 
            case 158: 
            case 188: 
            case 189: 
            case 221: 
            case 222: 
            case 253: 
            case 254: {
                this.operand = String.valueOf(address) + ",X";
                this.mode = 4;
                break;
            }
            case 25: 
            case 57: 
            case 89: 
            case 121: 
            case 153: 
            case 185: 
            case 190: 
            case 217: 
            case 249: {
                this.operand = String.valueOf(address) + ",Y";
                this.mode = 5;
                break;
            }
            case 124: {
                this.operand = "(" + address + ",X)";
                this.mode = 6;
                break;
            }
            case 108: {
                this.operand = "(" + address + ")";
                this.mode = 7;
                break;
            }
            default: {
                System.out.println("Not found (2) : " + this.opcode);
            }
        }
    }

    public String toString() {
        if (this.offset == 0) {
            return String.format("%d  %3s %-10s %02X", this.size, this.mnemonic, this.operand, this.value);
        }
        return String.format("%d  %3s %-10s %02X", this.size, this.mnemonic, String.valueOf(this.operand) + "+" + this.offset, this.value);
    }
}

