/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.ApplesoftConstants;
import com.bytezone.diskbrowser.applefile.AssemblerStatement;

public class AssemblerProgram
extends AbstractFile {
    private final int loadAddress;
    private int executeOffset;

    public AssemblerProgram(String name, byte[] buffer, int address) {
        super(name, buffer);
        this.loadAddress = address;
    }

    public AssemblerProgram(String name, byte[] buffer, int address, int executeOffset) {
        this(name, buffer, address);
        this.executeOffset = executeOffset;
    }

    @Override
    public String getText() {
        StringBuffer pgm = new StringBuffer();
        pgm.append(String.format("Name    : %s%n", this.name));
        pgm.append(String.format("Length  : $%04X (%,d)%n", this.buffer.length, this.buffer.length));
        pgm.append(String.format("Load at : $%04X%n", this.loadAddress));
        int ptr = this.executeOffset;
        int address = this.loadAddress + this.executeOffset;
        int i = 0;
        while (i < this.executeOffset) {
            pgm.append(String.format("%n%04X: %02X", this.loadAddress + i, this.buffer[i]));
            ++i;
        }
        while (ptr < this.buffer.length) {
            StringBuffer line = new StringBuffer();
            AssemblerStatement cmd = new AssemblerStatement(this.buffer[ptr]);
            if (cmd.size == 2 && ptr < this.buffer.length - 1) {
                cmd.addData(this.buffer[ptr + 1]);
            } else if (cmd.size == 3 && ptr < this.buffer.length - 2) {
                cmd.addData(this.buffer[ptr + 1], this.buffer[ptr + 2]);
            } else {
                cmd.size = 1;
            }
            line.append(String.format("%n%04X: ", address));
            int i2 = 0;
            while (i2 < cmd.size) {
                line.append(String.format("%02X ", this.buffer[ptr + i2]));
                ++i2;
            }
            while (line.length() < 20) {
                line.append(" ");
            }
            line.append(String.valueOf(cmd.mnemonic) + " " + cmd.operand);
            if (cmd.offset != 0) {
                line.append(String.format("$%04X", address + cmd.offset + 2));
            }
            if (cmd.location > 0 && (cmd.location < this.loadAddress - 1 || cmd.location > this.loadAddress + this.buffer.length)) {
                while (line.length() < 40) {
                    line.append(" ");
                }
                block0 : switch (cmd.location) {
                    case 177: {
                        line.append("; CHRGET");
                        break;
                    }
                    case 183: {
                        line.append("; CHRGOT");
                        break;
                    }
                    case 1002: {
                        line.append("; VECT");
                        break;
                    }
                    case 42350: {
                        line.append("; catalog routine");
                        break;
                    }
                    case 56679: {
                        line.append("; FRMNUM");
                        break;
                    }
                    case 56122: {
                        line.append("; output a string - STROUT");
                        break;
                    }
                    case 56156: {
                        line.append("; output a character");
                        break;
                    }
                    case 57022: {
                        line.append("; CHKCOM");
                        break;
                    }
                    case 57024: {
                        line.append("; SYNCHR");
                        break;
                    }
                    case 57033: {
                        line.append("; syntax error");
                        break;
                    }
                    case 57315: {
                        line.append("; PTRGET");
                        break;
                    }
                    case 57427: {
                        line.append("; find a variable");
                        break;
                    }
                    case 57612: {
                        line.append("; convert FP to INT");
                        break;
                    }
                    case 58098: {
                        line.append("; convert ACC to FP");
                        break;
                    }
                    case 58113: {
                        line.append("; SNGFLT");
                        break;
                    }
                    case 58343: {
                        line.append("; FPSTR2");
                        break;
                    }
                    case 59128: {
                        line.append("; GETBYTE");
                        break;
                    }
                    case 59212: {
                        line.append("; COMBYTE");
                        break;
                    }
                    case 59218: {
                        line.append("; GETADR");
                        break;
                    }
                    case 60153: {
                        line.append("; move (A,Y) to FAC");
                        break;
                    }
                    case 60708: {
                        line.append("; PRNTLNNO");
                        break;
                    }
                    case 60718: {
                        line.append("; PRNTFAC");
                        break;
                    }
                    case 60724: {
                        line.append("; FPSTR1");
                        break;
                    }
                    case 63161: {
                        line.append("; HFNS");
                        break;
                    }
                    case 64166: {
                        line.append("; reboot DOS");
                        break;
                    }
                    case 64449: {
                        line.append("; BASCALC");
                        break;
                    }
                    case 64600: {
                        line.append("; clear screen");
                        break;
                    }
                    case 65005: {
                        line.append("; output a character - COUT");
                        break;
                    }
                    case 65008: {
                        line.append("; output a character - COUT1");
                        break;
                    }
                    case 64986: {
                        line.append("; print ACC in hex");
                        break;
                    }
                    case 64910: {
                        line.append("; generate a return - CROUT");
                        break;
                    }
                    case 63809: {
                        line.append("; print ACC and X-reg - PRNTAX");
                        break;
                    }
                    case 64795: {
                        line.append("; keyin");
                        break;
                    }
                    case 62481: {
                        line.append("; map x,y location on hi-res 1 ??");
                        break;
                    }
                    case 62567: {
                        line.append("; LEFT EQU");
                        break;
                    }
                    case 62602: {
                        line.append("; RIGHT EQU");
                        break;
                    }
                    case 62677: {
                        line.append("; UP EQU");
                        break;
                    }
                    case 62724: {
                        line.append("; DOWN EQU");
                        break;
                    }
                    case 64303: {
                        line.append("; initialise text screen");
                        break;
                    }
                    case 64313: {
                        line.append("; text mode - SETTXT");
                        break;
                    }
                    case 64367: {
                        line.append("; set powerup checksum");
                        break;
                    }
                    case 64477: {
                        line.append("; BEEP");
                        break;
                    }
                    case 64907: {
                        line.append("; generate a return with clear - CROUT1");
                        break;
                    }
                    case 65068: {
                        line.append("; move a block of memory");
                        break;
                    }
                    case 65161: 
                    case 65171: {
                        line.append("; disconnect DOS from I/O links");
                        break;
                    }
                    case 65338: {
                        line.append("; BELL");
                        break;
                    }
                    case 65369: {
                        line.append("; Monitor cold entry point");
                        break;
                    }
                    default: {
                        i2 = 0;
                        while (i2 < ApplesoftConstants.tokenAddresses.length) {
                            if (cmd.location == ApplesoftConstants.tokenAddresses[i2]) {
                                line.append("; Applesoft - " + ApplesoftConstants.tokens[i2]);
                                break block0;
                            }
                            ++i2;
                        }
                        break block0;
                    }
                }
            }
            pgm.append(line.toString());
            address += cmd.size;
            ptr += cmd.size;
        }
        return pgm.toString();
    }

    @Override
    public String getAssembler() {
        return this.getText();
    }
}

