/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.GregorianCalendar;

public class HexFormatter {
    private static String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private static MathContext mathContext = new MathContext(9);

    public static String format(byte[] buffer, int offset, int length) {
        return HexFormatter.format(buffer, offset, length, true, 0);
    }

    public static String format(byte[] buffer, int offset, int length, int startingAddress) {
        return HexFormatter.format(buffer, offset, length, true, startingAddress);
    }

    public static String formatNoHeader(byte[] buffer, int offset, int length) {
        return HexFormatter.format(buffer, offset, length, false, 0);
    }

    public static String formatNoHeader(byte[] buffer, int offset, int length, int startingAddress) {
        return HexFormatter.format(buffer, offset, length, false, startingAddress);
    }

    public static String format(byte[] buffer, int offset, int length, boolean header, int startingAddress) {
        int i;
        StringBuffer line = new StringBuffer();
        int[] freq = new int[256];
        if (header) {
            line.append("      ");
            i = 0;
            while (i < 16) {
                line.append("  " + hex[i]);
                ++i;
            }
            if (offset == 0) {
                line.append("\n");
            }
        }
        i = offset;
        while (i < offset + length) {
            if (line.length() > 0 && i > 0) {
                line.append("\n");
            }
            int temp = i + startingAddress;
            int max = 65536;
            while (max > 0) {
                if (temp >= max) {
                    line.append(hex[temp / max]);
                    temp %= max;
                } else {
                    line.append("0");
                }
                max /= 16;
            }
            line.append(" : ");
            StringBuffer trans = new StringBuffer();
            StringBuffer hexLine = new StringBuffer();
            int j = i;
            while (j < i + 16 && j < offset + length) {
                int c;
                int n = c = buffer[j] & 0xFF;
                freq[n] = freq[n] + 1;
                hexLine.append(String.format("%02X ", c));
                if (c > 127) {
                    c = c < 160 ? (c -= 64) : (c -= 128);
                }
                if (c < 32 || c == 127) {
                    trans.append(".");
                } else {
                    trans.append((char)c);
                }
                ++j;
            }
            while (hexLine.length() < 48) {
                hexLine.append(" ");
            }
            line.append(String.valueOf(hexLine.toString()) + ": " + trans.toString());
            i += 16;
        }
        return line.toString();
    }

    public static String getString(byte[] buffer, int offset, int length) {
        StringBuffer text = new StringBuffer();
        int i = offset;
        while (i < offset + length) {
            int c = HexFormatter.intValue(buffer[i]);
            if (c > 127) {
                c = c < 160 ? (c -= 64) : (c -= 128);
            }
            if (c == 13) {
                text.append("\n");
            } else if (c < 32) {
                text.append(".");
            } else {
                text.append((char)c);
            }
            ++i;
        }
        return text.toString();
    }

    public static String getString2(byte[] buffer, int offset, int length) {
        StringBuffer text = new StringBuffer();
        int i = offset;
        while (i < offset + length) {
            int c = HexFormatter.intValue(buffer[i]);
            if (c == 136 && text.length() > 0) {
                System.out.println(text.toString());
                text.deleteCharAt(text.length() - 1);
                System.out.println("deleted");
            } else {
                if (c > 127) {
                    c = c < 160 ? (c -= 64) : (c -= 128);
                }
                if (c < 32) {
                    text.append((char)(c + 64));
                } else {
                    text.append((char)c);
                }
            }
            ++i;
        }
        return text.toString();
    }

    public static String getHexString(byte[] buffer, int offset, int length) {
        StringBuilder hex = new StringBuilder();
        int i = 0;
        while (i < length) {
            hex.append(String.format("%02X ", buffer[offset + i]));
            ++i;
        }
        if (length > 0) {
            hex.deleteCharAt(hex.length() - 1);
        }
        return hex.toString();
    }

    public static char byteValue(byte b) {
        int c = HexFormatter.intValue(b);
        if (c > 127) {
            c -= 128;
        }
        if (c > 95) {
            c -= 64;
        }
        if (c < 32) {
            return '.';
        }
        return (char)c;
    }

    public static String format4(int value) {
        if (value < 0) {
            return "***err**";
        }
        StringBuffer text = new StringBuffer();
        int i = 0;
        int weight = 4096;
        while (i < 4) {
            int digit = value / weight;
            if (digit < 0 || digit > 15) {
                return "***err**";
            }
            text.append(hex[digit]);
            value %= weight;
            weight /= 16;
            ++i;
        }
        return text.toString();
    }

    public static String format3(int value) {
        return HexFormatter.format4(value).substring(1);
    }

    public static String format2(int value) {
        if (value < 0) {
            value += 256;
        }
        String text = String.valueOf(hex[value / 16]) + hex[value % 16];
        return text;
    }

    public static String format1(int value) {
        String text = hex[value];
        return text;
    }

    public static int intValue(byte b1) {
        int i1 = b1;
        if (i1 < 0) {
            i1 += 256;
        }
        return i1;
    }

    public static int intValue(byte b1, byte b2) {
        return HexFormatter.intValue(b1) + HexFormatter.intValue(b2) * 256;
    }

    public static int intValue(byte b1, byte b2, byte b3) {
        return HexFormatter.intValue(b1) + HexFormatter.intValue(b2) * 256 + HexFormatter.intValue(b3) * 65536;
    }

    public static double floatValueOld(byte[] buffer, int offset) {
        double val = 0.0;
        int exponent = HexFormatter.intValue(buffer[offset]) - 128;
        int mantissa = (buffer[offset + 1] & 0x7F) * 0x1000000 + HexFormatter.intValue(buffer[offset + 2]) * 65536 + HexFormatter.intValue(buffer[offset + 3]) * 256 + HexFormatter.intValue(buffer[offset + 4]);
        int weight1 = 1;
        long weight2 = 0x80000000L;
        double multiplier = 0.0;
        int i = 0;
        while (i < 32) {
            if (((long)mantissa & weight2) > 0L) {
                multiplier += 1.0 / (double)weight1;
            }
            weight2 /= 2L;
            weight1 *= 2;
            ++i;
        }
        val = Math.pow(2.0, exponent - 1) * (multiplier + 1.0);
        return val;
    }

    public static double floatValue(byte[] buffer, int ptr) {
        int exponent = buffer[ptr] & 0x7F;
        if (exponent == 0) {
            return 0.0;
        }
        int mantissa = (buffer[ptr + 1] & 0x7F) << 24 | (buffer[ptr + 2] & 0xFF) << 16 | (buffer[ptr + 3] & 0xFF) << 8 | buffer[ptr + 4] & 0xFF;
        boolean negative = (buffer[ptr + 1] & 0x80) > 0;
        double value = 0.5;
        int i = 2;
        int weight = 0x40000000;
        while (i <= 32) {
            if ((mantissa & weight) > 0) {
                value += Math.pow(0.5, i);
            }
            ++i;
            weight >>>= 1;
        }
        BigDecimal bd = new BigDecimal(value *= Math.pow(2.0, exponent));
        double rounded = bd.round(mathContext).doubleValue();
        return negative ? rounded * -1.0 : rounded;
    }

    public static GregorianCalendar getAppleDate(byte[] buffer, int offset) {
        int date = HexFormatter.intValue(buffer[offset], buffer[offset + 1]);
        if (date > 0) {
            int year = (date & 0xFE00) >> 9;
            int month = (date & 0x1E0) >> 5;
            int day = date & 0x1F;
            int hour = HexFormatter.intValue(buffer[offset + 3]) & 0x1F;
            int minute = HexFormatter.intValue(buffer[offset + 2]) & 0x3F;
            year = year < 70 ? (year += 2000) : (year += 1900);
            return new GregorianCalendar(year, month - 1, day, hour, minute);
        }
        return null;
    }

    public static GregorianCalendar getPascalDate(byte[] buffer, int offset) {
        int year = HexFormatter.intValue(buffer[offset + 1]);
        int day = (buffer[offset] & 0xF0) >> 4;
        int month = buffer[offset] & 0xF;
        if (day == 0 || month == 0) {
            return null;
        }
        if (year % 2 > 0) {
            day += 16;
        }
        year = (year /= 2) < 70 ? (year += 2000) : (year += 1900);
        return new GregorianCalendar(year, month - 1, day);
    }

    public static String getPascalString(byte[] buffer, int offset) {
        int length = HexFormatter.intValue(buffer[offset]);
        return HexFormatter.getString(buffer, offset + 1, length);
    }
}

