/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.common;

import com.bytezone.common.Persistent;
import com.bytezone.common.Platform;
import com.bytezone.common.State;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public abstract class MyFrame
extends JFrame {
    protected final State state = new State(Preferences.userNodeForPackage(this.getClass()));
    protected final Font font;
    List<Persistent> persistList = new ArrayList<Persistent>();

    public MyFrame(String windowTitle, int width, int height) {
        super(windowTitle);
        Platform.setLookAndFeel();
        this.setSize(this.state.getWindowSize(width, height));
        this.setLocationRelativeTo(null);
        this.font = Platform.MAC ? Platform.getFont(Platform.FontType.PLAIN, Platform.FontSize.BASE_PLUS_1) : Platform.getFont(Platform.FontType.PLAIN, Platform.FontSize.BASE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MyFrame.this.closeWindow();
            }
        });
    }

    public MyFrame(String windowTitle) {
        this(windowTitle, 500, 500);
    }

    protected void closeWindow() {
        for (Persistent persist : this.persistList) {
            persist.save(this.state.preferences);
        }
        this.state.save(this);
        System.exit(0);
    }

    protected void restore(Persistent listener) {
        this.persistList.add(listener);
        listener.restore(this.state.preferences);
    }
}

