---------------------------------------
			   A COMMENT ON ERROR TRAPS
			     BY NICK FOTHERINGHAM
			 FROM THE APPLE BARREL, JULY'82
				   I.A.C.-TC

  YOU HAVE FINALLY GOTTEN ALL OF THE BUGS OUT OF THAT SPECIAL PROGRAM THAT HAS
KEPT YOU IN SECLUSION FOR THE PAST SEVERAL WEEKS.  IT DOES EXACTLY WHAT YOU WANT
IT TO DO, AND YOU ARE READY TO IMPRESS SOMEONE WITH IT.  YOU BEG YOUR BOSS TO
TAKE TIME FROM HIS BUSY SCHEDULE FOR A SESSION WITH YOUR APPLE, AND AFTER TEN
MINUTES OF ROUTINE DATA ENTRY, YOUR PROGRAM IS NEARING ITS FLASHY FINALE.  THE
NEXT QUESTION APPEARS:	"HOW MANY SIDES ON AN OCTOGON?" AS YOUR BOSS ENTERS
"E..I..G...", YOU STIFLE, "NOT THAT KEY, YOU DUMMY, THE '8'".  TOO LATE...  THE
APPLE HAS ALREADY RESPONDED WITH A "TYPE MISMATCH" MESSAGE AND SHUT YOUR
PROGRAM.

  ONE PURPOSE OF AN "ERROR TRAP" OR "ERROR HANDLING

  ROUTINE" IS TO HELP PREVENT SUCH EMBARRASSING SITUATIONS.  YOUR APPLE'S BASIC
INTERPRETER ALREADY HAS SEVERAL BUILT-IN ERROR TRAPS WHICH WERE DESIGNED TO
PROTECT THE SYSTEM FROM YOUR UNREASONABLE REQUESTS, SUCH AS ATTEMPTS TO DIVIDE
BY ZERO OR TO EXCEED TO SYSTEM'S CAPACITY ("STRING TOO LONG", "OVERFLOW",
"FORMULA TOO COMPLEX", "OUT OF MEMORY").  FORTUNATELY FOR MANY APPLICATIONS,
THESE TRAPS CAN BE AVOIDED BY USING THE ONERR GOTO.....POKE 216,0 COMMANDS.
ONERR GOTO...  DISABLES THE SYSTEM'S INTERNAL ERROR HANDLING ROUTINE AND, UPON
ENCOUNTERING AN ERROR, TRANSFERS PROGRAM PROCESSING TO A STATEMENT DEFINED BY
THE GOTO STATEMENT, TYPICALLY A REPLACEMENT ERROR HANDLING ROUTINE OF YOUR
DESIGN.  THE POKE 216,0 COMMAND REINSTATES THE SYSTEM'S ERROR HANDLING ROUTINE.

  FOR MANY BEGINNING PROGRAMMERS, DISABLING THE SYSTEM'S ERROR HANDLING ROUTINE,
ONLY TO REPLACE IT WITH ONE THAT YOU MUST DESIGN AND WHICH USES SOME OF YOUR
PRECIOUS RAM MEMORY SEEMS LIKE LUNACY.	THE MAJOR REASON FOR DOING SO IS THAT
MOST OF THE ERRORS TO WHICH THE SYSTEM REACTS NEED NOT BE FATAL TO

  YOUR RUN.  THE COMPUTER VIEWS THESE ERRORS AS FATAL BECAUSE THE CONTEXTS IN
WHICH THEY MAY OCCUR ARE SO DIVERSE THAT THE ONLY GENERAL SOLUTION THAT ENSURES
PROTECTION TO YOUR COMPUTER IS TO TERMINATE YOUR RUN.  HOWEVER, WITHIN YOUR
PROGRAM THE CONTEXT WITHIN WHICH AN ERROR MAY OCCUR CAN OFTEN BE MUCH MORE
NARROWLY DEFINED, AND NONFATAL SOLUTIONS MAY BE DEVELOPED.  SOME OF THESE
SOLUTIONS ARE DESCRIBED BELOW.

  ONE OF THE MOST COMMON APPLICATIONS FOR ERROR TRAPS IS TO GUARD YOUR PROGRAM
AGAINST TYPING ERRORS DURING DATA ENTRY FROM THE KEYBOARD.  MOST SUCH ERRORS CAN
BE RESOLVED WITHOUT ABORTING YOUR PROGRAM BY DESIGNING THE PROGRAM TO RECEIVE
ALL INPUT AS A STRING VARIABLE, SAY A$.  BECAUSE A$ WILL ACCEPT INPUT FROM
NEARLY EVERY KEY (EXCEPT RESET) WITHOUT A TYPE MISMATCH ERROR, IT IS PREFERABLE
TO A OR A% AS AN INPUT VARIABLE.  YOU MAY THEN TEST THE INPUT TO SEE IF A RETURN
HAS BEEN ENTERED (A$=""), TO SEE IF A NUMBER HAS ABEEN ENTERED (ASC(A$)>47 AND
ASC(A$)<58.  IF THE DESIRED NUMERICAL INPUT HAS BEEN ENTERED, YOU MAY THEN
CONVERT THE INPUT TO ITS

  NUMERICAL EQUIVALENT (A=VAL(A$) OR A%=INT(VAL(A$))) AND THEN TEST TO SEE IF
THIS VALUE IS WITHIN THE RANGE THAT YOU EXPECTED AS AN ANSWER TO YOUR QUESTION
(A%>0 AND A%<5).

  ONE OF THE GREAT ADVANTAGES OF OWNING YOUR OWN COMPUTER SYSTEM ON WHICH YOU
RUN PROGRAMS INTERACTIVELY IS THAT YOU CAN USUALLY TRAIN THE SYSTEM TO COME BACK
TO YOU FOR HELP WHEN IT HAS A COMPLAINT INSTEAD OF JUST DYING.	WHEN A "FATAL"
PROBLEM IS ENCOUNTERED, SUCH AS AN ATTEMPT TO DIVIDE BY ZERO, AN ERROR TRAP CAN
BE USED TO PRINT AN ERROR MESSAGE OF YOUR CHOOSING AND THEN GIVE YOU AN
OPPORTUNITY TO CHANGE THE DENOMINATOR TO A NON-ZERO NUMBER AND CONTINUE THE
CALCULATION OR TO ABORT THAT PROGRAM SEGMENT (E.G.  RETURN TO THE MENU).

  GOOD PROGRAMS SHOULD NEVER "CRASH".  EVEN WHEN THEY FAIL TO COMPLETE THE TASK
FOR WHICH THEY WERE DESIGNED, THEY SHOULD REACH A CONTROLLED ENDING WHICH
PROVIDES A DETAILED DESCRIPTION OF WHAT WENT WRONG AND AN OPPORTUNITY TO FIX IT
BEFORE ENDING.	SINCE MOST OF US WRITE PROGRAMS WITH THE

  EXPECTATION THAT OTHERS WILL RUN THEM, WE SHOULD GET IN THE HABIT OF USING
ERROR TRAPS ROUTINELY, AND WE SHOULD INSIST ON SUCH PROGRAMMING STYLE IN THE
COMMERCIAL SOFTWARE WE BUY.
---------------------------------------
