/* 
 * Apple // emulator for Linux: Glue file prologue for Intel 386
 *
 * Copyright 1994 Alexander Jean-Claude Bottema
 * Copyright 1995 Stephen Lee
 * Copyright 1997, 1998 Aaron Culliney
 * Copyright 1998, 1999, 2000, 2001 Michael Deutschmann
 *
 * This software package is subject to the GNU General Public License
 * version 2 or later (your choice) as published by the Free Software 
 * Foundation.
 *
 * THERE ARE NO WARRANTIES WHATSOEVER. 
 *
 */

#define __ASSEMBLY__
#include <apple2.h>
#include <cpu.h>
#include <misc.h>  /* Yuck, needed for SS_ALTZP */

#define GLUE_FIXED_READ(func,address)			\
E(func)			movb	SN(address)(%edi),%al;  \
			ret;

#define GLUE_FIXED_WRITE(func,address)                  \
E(func)			movb	%al,SN(address)(%edi);  \
			ret;

#define GLUE_BANK_READ(func,pointer) \
E(func)			addl	SN(pointer),%edi;	\
			movb	(%edi),%al;		\
			subl	SN(pointer),%edi;	\
			ret;

#define GLUE_BANK_WRITE(func,pointer) \
E(func)			addl	SN(pointer),%edi;	\
			movb	%al,(%edi);		\
			subl	SN(pointer),%edi;	\
			ret;

#define GLUE_BANK_MAYBEWRITE(func,pointer) \
E(func)			addl	SN(pointer),%edi;	\
			cmpl	$0,SN(pointer);		\
			jz	1f;			\
			movb	%al,(%edi);		\
1:			ret;


#define GLUE_C_WRITE(func) \
E(func)			pushl	%eax;			\
			andl	$0xff,%eax;		\
			pushl	%ecx;			\
			pushl	%edx;			\
			pushl	%eax;			\
			pushl	%edi;			\
			call	SN(unglued_##func);	\
			popl	%edx; /* dummy */	\
			popl	%edx; /* dummy */	\
			popl	%edx;			\
			popl	%ecx;			\
			popl	%eax;			\
			ret;				\

#define GLUE_C_READ(func) \
E(func)			pushl	%eax;			\
			pushl	%ecx;			\
			pushl	%edx;			\
			pushl	%edi;			\
			call	SN(unglued_##func);	\
			movb	%al,12(%esp);		\
			popl	%edx; /* dummy */	\
			popl	%edx;			\
			popl	%ecx;			\
			popl	%eax;			\
			ret;


#define GLUE_C_GATE(func,pointer,trapbank) 			\
1:			popl	%eax;				\
2:			addl	SN(pointer),%edi;		\
			movb	(%edi),%al;			\
			subl	SN(pointer),%edi;		\
			ret;					\
E(func)			cmpl	$SN(trapbank),SN(pointer);	\
			jne 	2b;				\
			pushl	%eax;				\
			leal	-1(PC_Reg_E),%eax;		\
			cmpl	%eax,EffectiveAddr_E;		\
			jne	1b;				\
			movw	PC_Reg, SN(cpu65_current);	\
			movb	A_Reg, SN(cpu65_current)+2;	\
			movb	F_Reg, SN(cpu65_current)+3;	\
			movb	X_Reg, SN(cpu65_current)+4;	\
			movb	Y_Reg, SN(cpu65_current)+5;	\
			movb	SP_Reg_L, SN(cpu65_current)+6;	\
			call	SN(unglued_##func);		\
			popl	%eax;				\
			movb	$0x60,%al;	/* RTS */	\
			xorl	%ebx, %ebx;			\
			xorl	%ecx, %ecx;			\
			movl	$0x0100, %edx;			\
			xorl	%esi, %esi;			\
			xorl	%edi, %edi;			\
			movw	SN(cpu65_current), PC_Reg;	\
			movb	SN(cpu65_current)+2, A_Reg;	\
			movb	SN(cpu65_current)+3, F_Reg;	\
			movb	SN(cpu65_current)+4, X_Reg;	\
			movb	SN(cpu65_current)+5, Y_Reg;	\
			movb	SN(cpu65_current)+6, SP_Reg_L;  \
                        testl	$SS_ALTZP, SN(softswitches);    \
			jz	1f;				\
			orl	$0x10000, %edx;			\
1:			ret
