/* 
 * Apple // emulator for Linux: Private definitions of the video driver
 *
 * Copyright 1994 Alexander Jean-Claude Bottema
 * Copyright 1995 Stephen Lee
 * Copyright 1997, 1998 Aaron Culliney
 * Copyright 1998, 1999, 2000, 2001 Michael Deutschmann
 *
 * This software package is subject to the GNU General Public License
 * version 2 or later (your choice) as published by the Free Software 
 * Foundation.
 *
 * THERE ARE NO WARRANTIES WHATSOEVER. 
 *
 */

#ifndef A2_VIDPRIV_H
#define A2_VIDPRIV_H

/* Note: The two existing video drivers, X-Windows and SVGALib, are 
 * `joined at the hip' through this file and vidsup.c.  However, it is 
 * likely that any other driver would have it's own distinct version of 
 * this header. 
 */

#ifdef _640x400
/* 640x400 mode really isn't what it advertises.  It's really 560x384 with 4
 * extra bytes on each side for color interpolation hack.  This is yet another
 * area where I've traded the optimization gain (especially on older slower
 * machines) for a standard resolution.
 */
#define SCANWIDTH 568
#define SCANHEIGHT 384
#define SCANSTEP SCANWIDTH-12
#else /* !_640x400 */
#define SCANWIDTH 320
#define SCANHEIGHT 200
#define SCANSTEP SCANWIDTH-6
#endif /* !_640x400 */

/* Lores/dhires colors, in normal order.  The color numbers are for the 
 * convienence of the dhires code. */
#define COLOR_BLACK		0	/* also text and hires */
#define COLOR_MAGENTA		8
#define COLOR_DARK_BLUE		1
#define COLOR_PURPLE		9	/* also hires */
#define COLOR_DARK_GREEN	2
#define COLOR_DARK_GREY		10
#define COLOR_BLUE		3	/* also hires */
#define COLOR_SKY_BLUE		11
#define COLOR_BROWN		4
#define COLOR_ORANGE		12	/* also hires */
#define COLOR_LIGHT_GREY	5
#define COLOR_PINK		13
#define COLOR_GREEN		6	/* also hires */
#define COLOR_YELLOW		14
#define COLOR_AQUA		7
#define COLOR_WHITE		15	/* also text and hires */

/* Flashing colors for text */
#define COLOR_FLASHING_BLACK	16
#define COLOR_FLASHING_WHITE	17

/* Interface colors */
#define COLOR_IF_RED		18
#define COLOR_IF_GREEN		19
#define COLOR_IF_BLUE		20

#ifndef __ASSEMBLER__
/* ----------------------------------
    generic graphics globals
   ---------------------------------- */

/* Pointers to framebuffer (can be VGA memory or host buffer) 
 */

extern unsigned char	*video__fb1,*video__fb2;

#ifdef _640x400
extern unsigned char	video__wider_hires_even[0x1000];
extern unsigned char	video__wider_hires_odd[0x1000];
#endif /* _640x400 */

extern unsigned char	video__hires_even[0x800];
extern unsigned char	video__hires_odd[0x800];

extern unsigned char	video__dhires1[256];
extern unsigned char	video__dhires2[256];

extern const unsigned long	video__lores[16];

extern int video__current_page;	/* Current visual page */

extern int video__strictcolors;

#ifdef _640x400
extern unsigned char   video__wider_int_font[3][0x8000];
#else /* _640x400 */
extern unsigned char   video__int_font[3][0x4000];
#endif /* _640x400 */

/* --- Precalculated hi-res page offsets given addr --- */
extern unsigned int	video__screen_addresses[8192];
extern unsigned char	video__columns[8192];

extern unsigned char	video__odd_colors[2];
extern unsigned char	video__even_colors[2];

/* Hooks */

void		video__write_text0(),
		video__write_text0_mixed(),
		video__write_text1(),
		video__write_text1_mixed(),
		video__write_even0(),
		video__write_odd0(),
		video__write_even0_mixed(),
		video__write_odd0_mixed(),
		video__write_even1(),
		video__write_odd1(),
		video__write_even1_mixed(),
		video__write_odd1_mixed();

void 		video__write_2e_text0(),
		video__write_2e_text0_mixed(),
		video__write_2e_text1(),
		video__write_2e_text1_mixed(),
		video__write_2e_odd0(),
		video__write_2e_even0(),
		video__write_2e_odd0_mixed(),
		video__write_2e_even0_mixed(),
		video__write_2e_odd1(),
		video__write_2e_even1(),
		video__write_2e_odd1_mixed(),
		video__write_2e_even1_mixed();

#endif /* !__ASSEMBLER__ */

#endif /* !A2_VIDPRIV_H */
