/***********************************************************************
 *
 *	upmail.c	Transport interface to smail
 *			by Bill Blue
 *			Part of the UMDSS Project
 *			(C)opyright 1992 Morgan Davis Group
 *
 **********************************************************************/

#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "config.h"

#define	NO_ERROR	(0)		/* no error */
#define	ERROR		(-1)		/* generic error code */

#define FASTIO

main(argc, argv)
int	argc;
char	*argv[];
{
	char	spooldir[PATHLEN], tmpdir[PATHLEN], tmpfn[PATHLEN];
	char	lstring[2048];
	short	c, didPpath;
	FILE	*fp;
	int	n, omask;
	struct	tm *t;
	time_t	pclock;
	struct	stat statbuf;
	static	char spdir[] = SPOOLDIR;

	time(&pclock);
	t = (struct tm *)localtime(&pclock);

	sprintf(tmpdir, "%s%s", spdir, argv[1]);
	sprintf(tmpfn, "%s%s/%d.%d%d", spdir, argv[1], getpid(),
			t->tm_min, t->tm_sec);

	if(stat(tmpdir, &statbuf) == -1) {	/* see if dir exists */
		if(mkdir(tmpdir, DPERM) < 0) {	/* if not, create it */
			fprintf(stderr, "%s: can't mkdir %s", argv[0], tmpdir);
			exit(ERROR);
		}
	}

	umask(~0660);
	if((fp = fopen(tmpfn, "w+")) == NULL)
		exit(ERROR);

	/*
	 *	This loop scans through each line of the header and
	 *	looks for a To: or Apparently-To:.  When found, a Ppath:
	 *	is inserted at that point.  We set a flag so that we don't
	 *	insert any extra Ppath:'s.  We also scan until the end of
	 *	the header is reached, tossing out any Ppath:'s that may
	 *	already exist (as is the case with EBBS-generated mail
	 *	because it incorrectly puts Ppath: *after* the To: field.
	 */
	
	didPpath = 0;

	while(fgets(lstring, sizeof(lstring), stdin) != NULL) {
		if(
			!didPpath &&
			(
				!strncmp(lstring, "To: ", 4) ||
				!strncmp(lstring, "To:\t", 4) ||
				!strncmp(lstring, "Apparently-To: ", 15) ||
				!strncmp(lstring, "Apparently-To:\t", 15)
			)
		) {
			fprintf(fp,"Ppath: %s!%s\n", argv[1], argv[2]);
			didPpath = 1;
		}
		if(!strncmp(lstring, "Ppath: ", 7))
			continue;	/* toss any existing Ppath field */
		fputs(lstring, fp);
		if (*lstring == '\n')	/* end of header */
			break;
	}
	/* after end of header, continue in next loop */

#ifdef FASTIO
	while((n = fread(lstring, sizeof(char), sizeof(lstring), stdin)))
		fwrite(lstring, sizeof(char), n, fp);
#else
	while((c = getc(stdin)) != EOF) 
		putc(c, fp);
#endif /* FASTREAD */

	fclose(fp);
	exit(NO_ERROR);
}


#if MKDIR
/*
 * mkdir()
 */

int mkdir(name, mode)
	const char *name;	/* name of directory to create */
	mode_t mode;		/* mode for directory */
{
	int	status;
	char	buf[PATHLEN + 32];

	strcpy(buf, "mkdir ");
	strcat(buf, name);
	strcat(buf, " > /dev/null 2>&1");
	if (!(status = system(buf)))
		chmod(name, mode);
	return(status);
}
#endif
