/**********************************************************************
 *
 *	mdx.c	Morgan Davis XMODEM 1.0
 *		(C)opyright 1992 Morgan Davis Group
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/ioctl.h>

#include "config.h"
#include "mdx.h"
#include "serial.h"

	/* Global variables */

mode_t oldcmask;

/*
 *	cleanup()
 *
 *	Called before quitting to reset the environment.
 */

void cleanup()
{
	tty_restore();
	umask(oldcmask);
}   

void trap_hangup()
{
	cleanup();
	exit(HUP_ERROR);
}

int main(argc, argv)
	int argc;
	char *argv[];
{
	extern int optind;
	extern char *optarg;
	char c, mode, *fname;
	int blocksize, crcflag, result, errflag;
	struct stat dummy;

	errflag = mode = crcflag = blocksize = 0;

	while ((c = getopt(argc, argv, "s:r:CKL")) != EOF) {
		switch (c) {
		case 's':
		case 'r':
			mode = c;
			fname = optarg;
			break;
		case 'C':
			if (!blocksize) blocksize = 128;
			++crcflag;
			break;
		case 'K':
			if (blocksize < 1024) blocksize = 1024;
			++crcflag;
			break;
		case 'L':
			blocksize = 4096;
			++crcflag;
			break;
		default:
			errflag = 1;
		}
	}

	if (errflag || !mode) {
		fprintf (stderr, "Usage: %s [ options ]\n", argv[0]);
		fprintf (stderr, "\t-s file\t\tSend file\n");
		fprintf (stderr, "\t-r file\t\tReceive file\n");
		fprintf (stderr, "\t-C\t\tXMODEM-CRC\n");
		fprintf (stderr, "\t-K\t\tXMODEM-1K\n");
		fprintf (stderr, "\t-L\t\tXMODEM-4K\n");
		exit(-1);
	}

	result = stat(fname, &dummy);
	if (mode == 'r' && !result) {
		fprintf(stderr, "%s: %s exists!\n", argv[0], fname);
		return(OSERROR);
	}
	if (mode == 's' && result) {
		fprintf(stderr, "%s: %s not found\n", argv[0], fname);
		return(OSERROR);
	}

	oldcmask = umask(0177);

	if ((tty_save() < 0) || (tty_rawmode() < 0)) {
		fprintf (stderr, "%s: can't initialize terminal\n", argv[0]);
		exit(-1);
	}

	signal(SIGINT, SIG_IGN);	/* Ignore interrupts */
	signal(SIGQUIT, SIG_IGN);	/* Ignore Quit signal */
	signal(SIGHUP, trap_hangup);	/* If they hang up, record it! */

	if (mode == 's')
		result = xsend(fname, blocksize);
	else
		result = xrecv(fname, crcflag, blocksize);
	cleanup();
	return (result);
}
