/**********************************************************************
 *
 *	mdx.c	Morgan Davis XMODEM 1.0
 *		(C)opyright 1992 Morgan Davis Group
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <signal.h>
#include <sys/ioctl.h>

#include "serial.h"

/*
 *	cleanup()
 *
 *	Called before quitting to reset the environment.
 */

void cleanup()
{
	tty_restore();
}   

void trap_hangup()
{
	cleanup();
	exit(-1);
}

int main(argc, argv)
	int argc;
	char *argv[];
{
	extern int optind;
	extern char *optarg;
	char c;
	int errflag;

	errflag = 0;

#if 0
	while ((c = getopt(argc, argv, "x") != EOF) {
		switch (c) {
		case 'x':
		default:
			errflag = 1;
		}
	}
	if (errflag) {
		fprintf (stderr, "Usage: %s [ options ]\n", argv[0]);
		exit(-1);
	}
#endif

	if ((tty_save() < 0) || (tty_rawmode() < 0)) {
		fprintf (stderr, "%s: can't initialize terminal\n", argv[0]);
		exit(-1);
	}

	printf ("iotest -- Type characters to test unbuffered response.\r\n");
	printf ("          Five second timeouts marked by ***.\r\n");
	printf ("          Press ESC to quit.\r\n\n");
	printf ("Port speed = %lu\r\n", (unsigned long)tty_speed());

	signal(SIGINT, SIG_IGN);	/* Ignore interrupts */
	signal(SIGQUIT, SIG_IGN);	/* Ignore Quit signal */
	signal(SIGHUP, trap_hangup);	/* If they hang up, record it! */

	do {
		c = get_timed_char(5);
		switch (c) {
		case -1:
			write_char('*');
			write_char('*');
			write_char('*');
		case 27:
			break;
		default:
			write_char(c);
/*			printf("[%2x]\n", c); */
			break;
		}
	} while (c != 27);
	cleanup();
	puts("\n--Done--");
}
