
/*
** GEN816.C
**
** by Toshiyasu Morita
**
** Started: 10/26/93 @ 10:56 pm
*/

#include <assert.h>
#include <stdio.h>

typedef struct NODE_STRUCT_TAG {

	struct NODE_STRUCT_TAG *parent, *kids[2];
	char text[16];

} NODE_STRUCT;

/*************************************
* Start tree functions
*************************************/


/*
** Allocate node
*/

NODE_STRUCT *Allocate_Node(char *string, NODE_STRUCT *parent, int kid_num)

{
	NODE_STRUCT *new_node;

	new_node = malloc(sizeof(NODE_STRUCT));
	assert(new_node != 0);

	new_node->parent      = parent;
	parent->kids[kid_num] = new_node;

	strncpy(&new_node->text, string, sizeof(new_node->text));

	return new_node;
}

/*************************************
* End tree functions
*************************************/

/*************************************
* Start input handling functions
*************************************/

char *line_p;

void Debug_Print_Op(char *text, int num)

{
	int i;

	for (i=0; i<num; i++)
		fputc(' ', stdout);

	while (*text && (isalnum(*text) || (*text == '_')))
		fputc(*text++, stdout);

	fputc('\n', stdout);
}


/*
** Parse nodes
*/

void Parse_Nodes(char *line, int level)

{
	static char c, *source;

	if (!level)
		source = line;

	printf("%d: %s\n", level, source);
	fflush(stdout);

	while (*source && isspace(*source))
		source++;

	Debug_Print_Op(source, level);

	while (*source && ((*source != '(') && (*source != ')')))
		source++;

	if (*source == ')')
		return;

	source++;

	Parse_Nodes(line, level+1);

	while (*source && ((*source != ',') && (*source != ')')))
		source++;

	c = *source++;

	if (c == ',') {

		Parse_Nodes(line, level+1);

		while (*source && (*source != ')'))
			source++;

	} else if (!c)
		printf("Parse_Nodes(): Error, no closing parentheses\n");
}

/*************************************
* End input handling functions
*************************************/


void main(void)

{

	Parse_Nodes("ASGNI(ADDRLP(_c), CNSTI(0))", 0);
}
