	Page	58,132
	Title	RESET.ASM	Apple Emulator Reset Routines
;******************************************************************************
;
;   Name:	RESET.ASM	Apple Emulator Reset Routines
;
;   Group:	Emulator
;
;   Revision:	1.00
;
;   Date:	January 30, 1988
;
;   Author:	Randy W. Spurlock
;
;******************************************************************************
;
;  Module Functional Description:
;
;		This module contains all the code for the Apple reset
;	routines.
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;   1/30/88	1.00	Original
;
;******************************************************************************
	Page
;
;  Public Declarations
;
	Public	CPU_Reset		; Reset the 65C02 CPU routine
	Public	BUS_Reset		; Reset the Apple ][ bus routine
;
;  External Declarations
;
	Extrn	Dev_Reset:Word		; Device reset table		 (DATA)
;
;  LOCAL Equates
;
FRAC_ONE	Equ	0100h		; Fractional constant one (1.00)
;
;  Define any include files needed
;
	Include 	Macros.inc	; Include the macro definitions
	Include 	Equates.inc	; Include the equate definitions
	.286c				; Include 80286 instructions
	Page
;
;  Define the emulator code segment
;
Emulate Segment Word Public 'EMULATE'   ; Emulator code segment
	Assume	cs:Emulate, ds:Nothing, es:Nothing
	Subttl	CPU_Reset	Reset the 65C02 CPU Routine
	Page	+
;******************************************************************************
;
;	CPU_Reset()
;
;		Initialize the accumulator register			(0h)
;		Initialize the X index register 			(0h)
;		Initialize the Y index register 			(0h)
;		Initialize the stack pointer register		      (1FFh)
;		Initialize the program counter register 	     (FFFCh)
;		Initialize the 65C02 processor status register		(0h)
;		Return to the caller
;
;	Registers on Entry:
;
;		DS    - 65C02 RAM space
;
;	Registers on Exit:
;
;		DL    - Accumulator initialized        (0h)
;		DH    - 65C02 flags initialized        (0h)
;		CL    - Y index register initialized   (0h)
;		CH    - X index register initialized   (0h)
;		BX    - Stack pointer initialized    (1FFh)
;		SI    - PC initialized	     (Reset Vector)
;
;******************************************************************************
		Even			; Force procedure to even address
CPU_Reset	Proc	Near		; Reset the 65C02 CPU procedure
	xor	dl,dl			; Initialize the accumualtor register
	xor	ch,ch			; Initialize the X index register
	xor	cl,cl			; Initialize the Y index register
	mov	bx,STACK_TOP		; Initialize the stack pointer
	mov	si,ds:[RST_VECTOR]	; Initialize the program counter
	xor	dh,dh			; Initialize 65C02 processor flags
	ret				; Return to the caller
CPU_Reset	Endp			; End of the CPU_Reset procedure
	Subttl	BUS_Reset	Reset Apple ][ Bus Routine
	Page	+
;******************************************************************************
;
;	BUS_Reset()
;
;		Initialize the current slot number (0)
;		Initialize the slot number counter (8)
;		While there are more slots
;			Call routine to reset this slot
;			Increment the current slot number
;			Decrement the slot counter
;		Endwhile
;		Return to the caller
;
;	Registers on Entry:
;
;		None
;
;	Registers on Exit:
;
;		AX-DX - Destroyed
;
;******************************************************************************
		Even			; Force procedure to even address
BUS_Reset	Proc	Near		; Apple ][ bus reset procedure
	xor	bx,bx			; Initialize the current slot number
	mov	cx,SLOT_MAX		; Get the maximum number of slots
Slot_Loop:
	shl	bx,1			; Convert slot number to table index
	call	cs:[Dev_Reset + bx]	; Call routine to reset this slot
	shr	bx,1			; Restore the current slot number
	inc	bx			; Increment the current slot number
	loop	Slot_Loop		; Loop till all expansion slots reset
Reset_Exit:
	ret				; Return to the caller
BUS_Reset	Endp			; End of the BUS_Reset procedure
;******************************************************************************
;
;	Define the end of the Emulator Code Segment
;
;******************************************************************************
Emulate Ends
	End				; End of the Reset module
