	.Xlist
	Page	58,132
	Subttl	STRUCS.INC	Apple Emulator (65C02 Processor)
;******************************************************************************
;
;   Name:	STRUCS		Apple Emulator (65C02 Processor)
;
;   Group:	Emulator
;
;   Revision:	1.00
;
;   Date:	January 30, 1988
;
;   Author:	Randy W. Spurlock
;
;******************************************************************************
;
;  Module Functional Description:
;
;		This module contains all the structures needed by the
;	Apple emulator. This module can be included with any needed
;	source files to define the Apple emulator structures.
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;   1/30/88	1.00	Original
;
;******************************************************************************
	Page
;******************************************************************************
;
;	Define the Apple ][ memory structure
;
;******************************************************************************
Apple_Memory	Struc				; Slot data pointer structure
RAM_Area	Db	0C000h Dup (?)		; Apple ][ system RAM area
Hardware_Area	Db	00100h Dup (?)		; Apple ][ system hardware area
ROM_Area	Db	03EFFh Dup (?)		; Apple ][ system ROM area - 1
Apple_Memory	Ends				; End of Slot_Data structure
;******************************************************************************
;
;	Define the filename structure
;
;******************************************************************************
File_Name	Struc				; File name structure
		Db	64 Dup (?)		; Maximum name size (64 Bytes)
File_Name	Ends				; End of File_Name structure
;******************************************************************************
;
;	Define the device table entry structure
;
;******************************************************************************
Device_Entry	Struc				; Device table entry structure
Device_ID	Dw	?			; Device ID string
Device_Init	Dw	?			; Device initialization routine
Device_Ctrl	Dw	?			; Device control routine
Device_Rd	Dw	?			; Device read routine
Device_Wrt	Dw	?			; Device write routine
Device_Mem_Rd	Dw	?			; Device memory read routine
Device_Mem_Wrt	Dw	?			; Device memory write routine
Device_Exp_Rd	Dw	?			; Device expansion read routine
Device_Exp_Wrt	Dw	?			; Device expansion write routine
Device_Reset	Dw	?			; Device reset routine
Device_Entry	Ends				; End of Device_Entry structure
;******************************************************************************
;
;	Define the language card structure
;
;******************************************************************************
Slot_Data	Struc				; Slot data pointer structure
Slot_0		Dw	0			; Slot 0 data pointer
Slot_1		Dw	0			; Slot 1 data pointer
Slot_2		Dw	0			; Slot 2 data pointer
Slot_3		Dw	0			; Slot 3 data pointer
Slot_4		Dw	0			; Slot 4 data pointer
Slot_5		Dw	0			; Slot 5 data pointer
Slot_6		Dw	0			; Slot 6 data pointer
Slot_7		Dw	0			; Slot 7 data pointer
Slot_Data	Ends				; End of Slot_Data structure
;******************************************************************************
;
;	Define the language card structure
;
;******************************************************************************
Lang_Card	Struc				; Language card structure
Lang_Byte	Db	(?)			; Language card control byte
Lang_Flag	Db	(?)			; Language card flag byte
Seg_1_Bank_1	Db	4096 Dup (?)		; Lang. card segment 1 bank 1
Seg_1_Bank_2	Db	4096 Dup (?)		; Lang. card segment 1 bank 2
Seg_1_RAM	Db	8192 Dup (?)		; Lang. card segment 1 RAM
Seg_2_Bank_1	Db	4096 Dup (?)		; Lang. card segment 2 bank 1
Seg_2_Bank_2	Db	4096 Dup (?)		; Lang. card segment 2 bank 2
Seg_2_RAM	Db	8192 Dup (?)		; Lang. card segment 2 RAM
Lang_Card	Ends				; End of Lang_Card structure
;******************************************************************************
;
;	Define the cartridge structure
;
;******************************************************************************
Cart_Card	Struc				; Cartridge structure
Cart_File	Db	(Size File_Name) Dup (?); Cartridge file name
Cart_Byte	Db	(?)			; Cartridge control byte
Cart_Image	Db	32768 Dup (?)		; Cartridge image area
Cart_Card	Ends				; End of Cart_Card structure
;******************************************************************************
;
;	Define the cartridge file name structure
;
;******************************************************************************
Cart_Name	Struc				; Cartridge file name structure
Cart_Base	Db	"Cart"                  ; Cartridge base file name
Cart_Slot	Db	"x"                     ; Cartridge base slot number
Cart_Ext	Db	".crt",0                ; Cartridge base extension
Cart_Name	Ends				; End of Cart_Name structure
;******************************************************************************
;
;	Define the base floppy file name structure
;
;******************************************************************************
Floppy_Name	Struc				; Floppy file name structure
Floppy_Base	Db	"Floppy"                ; Floppy drive base file name
Floppy_Slot	Db	"x"                     ; Floppy drive base slot number
Floppy_Letter	Db	"y"                     ; Floppy drive base drive letter
Floppy_Ext	Db	".dsk",0                ; Floppy drive base extension
Floppy_Name	Ends				; End of Floppy_Name structure
;******************************************************************************
;
;	Define the floppy address structure (13/16 Sector Disk)
;
;******************************************************************************
Floppy_Address	Struc				; Floppy track address structure
Prologue	Db	3 Dup (?)		; Address prologue (D5 AA 96)
Volume		Db	2 Dup (?)		; Floppy volume number
Track		Db	2 Dup (?)		; Floppy track number
Sector		Db	2 Dup (?)		; Floppy sector number
Checksum	Db	2 Dup (?)		; Address checksum
Epilogue	Db	3 Dup (?)		; Address epilogue (DE AA EB)
Floppy_Address	Ends				; End of Floppy_Address struc.
;******************************************************************************
;
;	Define the gap 1 structure (64 Bytes) [Floppy]
;
;******************************************************************************
Gap_1		Struc				; Gap 1 structure
		Db	64 Dup (?)		; Disk gap 1 size (64 Bytes)
Gap_1		Ends				; End of Gap_1 structure
;******************************************************************************
;
;	Define the gap 2 structure (8 Bytes) [Floppy]
;
;******************************************************************************
Gap_2		Struc				; Gap 2 structure
		Db	8 Dup (?)		; Disk gap 2 size (8 Bytes)
Gap_2		Ends				; End of Gap_2 structure
;******************************************************************************
;
;	Define the gap 3 structure (8 Bytes) [Floppy]
;
;******************************************************************************
Gap_3		Struc				; Gap 3 structure
		Db	8 Dup (?)		; Disk gap 3 size (8 Bytes)
Gap_3		Ends				; End of Gap_3 structure
;******************************************************************************
;
;	Define the raw sector structure [Floppy]
;
;******************************************************************************
Raw_Sector	Struc				; Raw sector structure
Raw_Data	Db	256 Dup (?)		; Raw sector data (256 Bytes)
Raw_Sector	Ends				; End of Raw_Sector structure
;******************************************************************************
;
;	Define the sector structure (13 Sector Floppy)
;
;******************************************************************************
Sector_13	Struc				; 13 Sector structure
Address_13	Db	(Size Floppy_Address) Dup (?)
		Db	(Size Gap_2) Dup (?)	; 13 Sector gap 3 area (8 Bytes)
Prologue_13	Db	3 Dup (?)		; 13 Sector prologue (D5 AA AD)
Data_13 	Db	410 Dup (?)		; 13 Sector data bytes
Checksum_13	Db	1 Dup (?)		; 13 Sector checksum
Epilogue_13	Db	3 Dup (?)		; 13 Sector epilogue (DE AA EB)
		Db	(Size Gap_3) Dup (?)	; 13 Sector gap 3 area (8 Bytes)
Sector_13	Ends				; End of Sector_13 structure
;******************************************************************************
;
;	Define the sector structure (16 Sector Floppy)
;
;******************************************************************************
Sector_16	Struc				; 16 Sector structure
Address_16	Db	(Size Floppy_Address) Dup (?)
		Db	(Size Gap_2) Dup (?)	; 16 Sector gap 2 area (8 Bytes)
Prologue_16	Db	3 Dup (?)		; 16 Sector prologue (D5 AA AD)
Data_16 	Db	342 Dup (?)		; 16 Sector data bytes
Checksum_16	Db	1 Dup (?)		; 16 Sector checksum
Epilogue_16	Db	3 Dup (?)		; 16 Sector epilogue (DE AA EB)
		Db	(Size Gap_3) Dup (?)	; 16 Sector gap 3 area (8 Bytes)
Sector_16	Ends				; End of Sector_16 structure
;******************************************************************************
;
;	Define the unencrypted track buffer structure (13 Sector Floppy)
;
;******************************************************************************
Buffer_13	Struc				; Unencrypted track structure
Buffer_0_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 0
Buffer_1_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 1
Buffer_2_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 2
Buffer_3_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 3
Buffer_4_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 4
Buffer_5_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 5
Buffer_6_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 6
Buffer_7_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 7
Buffer_8_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 8
Buffer_9_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 9
Buffer_A_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector A
Buffer_B_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector B
Buffer_C_13	Db	(Size Raw_Sector) Dup(?); Unencrypted sector C
Buffer_13	Ends				; End of Buffer_13 structure
;******************************************************************************
;
;	Define the unencrypted track buffer structure (16 Sector Floppy)
;
;******************************************************************************
Buffer_16	Struc				; Unencrypted track structure
Buffer_0_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 0
Buffer_1_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 1
Buffer_2_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 2
Buffer_3_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 3
Buffer_4_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 4
Buffer_5_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 5
Buffer_6_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 6
Buffer_7_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 7
Buffer_8_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 8
Buffer_9_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector 9
Buffer_A_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector A
Buffer_B_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector B
Buffer_C_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector C
Buffer_D_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector D
Buffer_E_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector E
Buffer_F_16	Db	(Size Raw_Sector) Dup(?); Unencrypted sector F
Buffer_16	Ends				; End of Buffer_16 structure
;******************************************************************************
;
;	Define the encrypted track buffer structure (13 Sector Floppy)
;
;******************************************************************************
Track_13	Struc				; 13 Sector track structure
Gap_1_13	Db	(Size Gap_1) Dup (?)	; 13 Sector floppy - Gap 1
Sector_0_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector 0
Sector_1_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector 1
Sector_2_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector 2
Sector_3_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector 3
Sector_4_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector 4
Sector_5_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector 5
Sector_6_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector 6
Sector_7_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector 7
Sector_8_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector 8
Sector_9_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector 9
Sector_A_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector A
Sector_B_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector B
Sector_C_13	Db	(Size Sector_13) Dup (?); 13 Sector floppy - Sector C
Track_13	Ends				; End of Track_13 structure
;******************************************************************************
;
;	Define the encrypted track buffer structure (16 Sector Floppy)
;
;******************************************************************************
Track_16	Struc				; 16 Sector track structure
Gap_1_16	Db	(Size Gap_1) Dup (?)	; 16 Sector floppy - Gap 1
Sector_0_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector 0
Sector_1_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector 1
Sector_2_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector 2
Sector_3_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector 3
Sector_4_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector 4
Sector_5_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector 5
Sector_6_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector 6
Sector_7_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector 7
Sector_8_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector 8
Sector_9_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector 9
Sector_A_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector A
Sector_B_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector B
Sector_C_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector C
Sector_D_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector D
Sector_E_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector E
Sector_F_16	Db	(Size Sector_16) Dup (?); 16 Sector floppy - Sector F
Track_16	Ends				; End of Track_16 structure
;******************************************************************************
;
;	Define the floppy drive structure
;
;******************************************************************************
Floppy_Drive	Struc				; Floppy drive structure
Floppy_File	Db	(Size File_Name) Dup (?); Floppy drive file name
Floppy_Flag	Db	(?)			; Floppy drive flag byte
Floppy_Last	Db	(?)			; Floppy drive last phase
Floppy_Curr	Db	(?)			; Floppy drive current phase
Floppy_Latch	Db	(?)			; Floppy drive write data latch
Floppy_Handle	Dw	(?)			; Floppy drive handle number
Floppy_Pointer	Dw	(?)			; Floppy track buffer pointer
Floppy_Limit	Dw	(?)			; Floppy track pointer limit
Floppy_Track	Dw	(?)			; Floppy track size
Floppy_Sector	Db	(?)			; Floppy sector size (13/16)
Floppy_Buffer	Db	(Size Track_16) Dup (?) ; Floppy drive track buffer
Floppy_Drive	Ends				; End of Floppy_Drive structure
;******************************************************************************
;
;	Define the floppy controller structure
;
;******************************************************************************
Floppy_Card	Struc				; Floppy controller structure
Floppy_Current	Dw	(?)			; Floppy current drive ptr.
Floppy_Drive_A	Db	(Size Floppy_Drive) Dup(?)
Floppy_Drive_B	Db	(Size Floppy_Drive) Dup(?)
Floppy_Card	Ends				; End of Floppy_Card structure
;******************************************************************************
;
;	Define the serial controller structure
;
;******************************************************************************
Serial_Card	Struc				; Serial controller structure
Serial_Base	Dw	(?)			; Serial controller base port
Serial_Control	Db	(?)			; Serial control value
Serial_Command	Db	(?)			; Serial command value
Serial_Pullup	Db	(?)			; Serial pullup value
Serial_Card	Ends				; End of Serial_Card structure
;******************************************************************************
;
;	Define the find matching file structure
;
;******************************************************************************
Find_Match	Struc				; Find matching structure
DOS_Reserved	Db	21 Dup (?)		; MS-DOS reserved area
File_Attr	Db	(?)			; File attribute byte
File_Time	Dw	(?)			; File time value
File_Date	Dw	(?)			; File data value
File_Size_Low	Dw	(?)			; File size value (LSW)
File_Size_High	Dw	(?)			; File size value (MSW)
File_Name_Ext	Db	13 Dup (?)		; File name/extension/zero byte
Find_Match	Ends				; End of Find_Match structure
;******************************************************************************
;
;	Define the opcode debug structure
;
;******************************************************************************
Opcode_Debug	Struc				; Opcode debug structure
Op_Type 	Db	?			; Opcode type value
Op_Address	Db	?			; Opcode addressing type
Opcode_Debug	Ends				; End of Opcode_Debug structure
;******************************************************************************
;
;	Define the opcode mnemonic structure
;
;******************************************************************************
Opcode_Mnemonic Struc				; Opcode mnemonic structure
Op_Mnemonic	Db	"   "                   ; Opcode mnemonic string
		Db	0
Opcode_Mnemonic Ends				; End of Opcode_Mnemonic struc.
;******************************************************************************
;
;	Define the Int_Update stack frame structure
;
;******************************************************************************
Interrupt_Frame Struc			; Int_Update stack frame definition
BP_Save 	Dw	?		; Saved BP register value
Return_Address	Dw	?		; Caller return address
AX_Save 	Dw	?		; Saved AX register (From Interrupt)
Current_IP	Dw	?		; Currently executing IP register
Current_CS	Dw	?		; Currently executing CS register
Current_Flag	Dw	?		; Currently executing flag register
Interrupt_Frame Ends			; End of stack frame definition
;******************************************************************************
;
;	Define the debug stack frame structure
;
;******************************************************************************
Debug_Frame	Struc			; Debug stack frame definition
BP_Register	Dw	?		; Saved BP register value
DI_Register	Dw	?		; Saved DI register value
SI_Register	Dw	?		; Saved SI register (65C02 PC)
DL_Register	Db	?		; Saved DL register (65C02 Accumulator)
DH_Register	Db	?		; Saved DH register (65C02 Flags)
CL_Register	Db	?		; Saved CL register (65C02 Y Index)
CH_Register	Db	?		; Saved CH register (65C02 X Index)
BX_Register	Dw	?		; Saved BX register (65C02 Stack)
AX_Register	Dw	?		; Saved AX register value
Debug_Frame	Ends			; End of stack frame definition
;******************************************************************************
;
;	Define the debug color structure
;
;******************************************************************************
Debug_Color	Struc			; Debugger color definition
Color_Back	Dw	GRAY		; Debugger background color value
Color_Command	Dw	INTENSE_WHITE	; Debugger command color value
Color_Title	Dw	INTENSE_WHITE	; Debugger title color value
Color_Address	Dw	CYAN		; Debugger address color value
Color_Register	Dw	INTENSE_WHITE	; Debugger register color value
Color_Value	Dw	RED		; Debugger value color value
Color_Opcode	Dw	WHITE		; Debugger opcode color value
Color_Mnemonic	Dw	WHITE		; Debugger mnemonic color value
Color_On	Dw	INTENSE_WHITE	; Debugger flag on color value
Color_Off	Dw	WHITE		; Debugger flag off color value
Color_Data	Dw	GREEN		; Debugger data color value
Color_Stack	Dw	BLUE		; Debugger stack color value
Color_Error	Dw	RED		; Debugger error color value
Color_Enabled	Dw	GREEN		; Debugger enabled breakpoint color
Color_Disabled	Dw	RED		; Debugger disabled breakpoint color
Debug_Color	Ends			; End of debug color definition
;******************************************************************************
;
;	Define the debug break structure
;
;******************************************************************************
Debug_Break	Struc			; Debug breakpoint definition
Debug_Type	Db	0		; Debug breakpoint type (Hard/Soft/Exec)
Debug_Address	Dw	0		; Debug breakpoint address
Debug_Data	Db	5 Dup (0)	; Debug breakpoint specific data
Debug_Break	Ends			; End of debug breakpoint definition
;******************************************************************************
;
;	Define the software break structure
;
;******************************************************************************
Soft_Break	Struc			; Software breakpoint definition
Soft_Type	Db	TYPE_SOFT	; Software breakpoint type value
Soft_Address	Dw	?		; Software breakpoint address
Soft_Opcode	Db	?		; Software breakpoint opcode save value
Soft_Reserved	Db	4 Dup (?)	; Software breakpoint reserved area
Soft_Break	Ends			; End of software breakpoint definition
;******************************************************************************
;
;	Define the hardware break structure
;
;******************************************************************************
Hard_Break	Struc			; Hardware breakpoint definition
Hard_Type	Db	TYPE_HARD	; Hardware breakpoint type value
Hard_Address	Dw	?		; Hardware breakpoint address
Hard_Check	Db	?		; Hardware breakpoint check value
Hard_Reserved	Db	4 Dup (?)	; Hardware breakpoint reserved area
Hard_Break	Ends			; End of hardware breakpoint definition
;******************************************************************************
;
;	Define the execution break structure
;
;******************************************************************************
Exec_Break	Struc			; Execution breakpoint definition
Exec_Type	Db	TYPE_EXECUTE	; Execution breakpoint type value
Exec_Address	Dw	?		; Execution breakpoint address
Exec_Reserved	Db	5 Dup (?)	; Execution breakpoint reserved area
Exec_Break	Ends			; End of execution breakpoint definition
;******************************************************************************
;
;	Define the private stack structure
;
;******************************************************************************
Private_Stack	Struc			; Private stack definition
Private_Size	Dw	?		; Private stack size in bytes
Private_Pointer Dw	?		; Private stack pointer
Private_Stack	Ends			; End of private stack definition
Private_Data	Equ	Private_Pointer + 2
;******************************************************************************
;
;	Define the window structure
;
;******************************************************************************
Window		Struc			; Window structure
Upper_Left_Row	Dw	?		; Window upper left row coordinate
Upper_Left_Col	Dw	?		; Window upper left column coordinate
Lower_Right_Row Dw	?		; Window lower right row coordinate
Lower_Right_Col Dw	?		; Window lower right column coordinate
Current_Fore	Dw	WHITE		; Window current foreground color value
Current_Back	Dw	BLACK		; Window current background color value
Current_Row	Dw	0		; Window current row value
Current_Col	Dw	0		; Window current column value
Cursor_Row	Dw	0		; Window cursor row value
Cursor_Col	Dw	0		; Window cursor column value
Cursor_Type	Dw	OFF_CURSOR	; Window cursor type value
Cursor_Save	Dw	ON_CURSOR	; Window cursor type save value
Window		Ends			; End of window definition
	.List
