/* song.h */

/* internal data structures for the soundtracker player routine....
 */

/* $Author: espie $
 * $Date: 1991/11/17 23:07:58 $
 * $Revision: 2.1 $
 * $Log: song.h,v $
 * Revision 2.1  1991/11/17  23:07:58  espie
 * Added some symbolic constants.
 *
 * Revision 2.0  1991/11/17  21:42:08  espie
 * New version.
 *
 * Revision 1.1  1991/11/04  13:23:59  espie
 * Initial revision
 *
 *
 */


#define NUMBER_SAMPLES 32

#define BLOCK_LENGTH 64
#define NUMBER_TRACKS 4
#define NUMBER_PATTERNS 128

#define NUMBER_EFFECTS 16

#define MIN_PITCH 113
#define MAX_PITCH 1023

#define MIN_VOLUME 0
#define MAX_VOLUME 64

/* the fuzz in note pitch */
#define FUZZ 2

/* we refuse to allocate more than 500000 bytes for one sample */
#define MAX_SAMPLE_LENGTH 500000

struct sample_info
   {
   char *name;
   int  length, rp_offset, rp_length;
   int volume;
   int finetune;
   SAMPLE *start, *rp_start;
   };

/* the actual parameters may be split in two halves occasionnally */

#define LOW(para) ((para) & 15)
#define HI(para) ((para) >> 4)

struct event
   {
   unsigned char sample_number;
   unsigned char effect;
   unsigned char parameters;
   unsigned char note;
   int pitch;
   };

struct block
   {
   struct event e[NUMBER_TRACKS][BLOCK_LENGTH];
   };
    
        
struct song_info
   {
   int length;
   int maxpat;
   char patnumber[NUMBER_PATTERNS];
   struct block *pblocks;
   };

struct song
   {
   char *title;
      /* sample 0 is always a dummy sample */
   struct sample_info *samples[NUMBER_SAMPLES];
   struct song_info *info;
   };

