/* extern.h */

/* $Author: espie $
 * $Id: extern.h,v 2.9 1991/12/04 08:28:53 espie Exp $
 * $Revision: 2.9 $
 * $Log: extern.h,v $
 * Revision 2.9  1991/12/04  08:28:53  espie
 * Separated mix/stereo stuff.
 *
 * Revision 2.8  1991/12/03  20:43:46  espie
 * Added possibility to get back to MONO for the sgi.
 *
 * Revision 2.7  1991/12/03  18:07:38  espie
 * Added stereo capabilities to the indigo version.
 *
 * Revision 2.6  1991/12/03  17:10:11  espie
 * Added some new song types to automatize the choice process.
 *
 * Revision 2.5  1991/11/19  16:07:19  espie
 * Added comments, moved minor stuff around.
 *
 * Revision 2.4  1991/11/18  14:10:30  espie
 * Moved resampling to audio, added prototype.
 *
 * Revision 2.3  1991/11/18  01:23:30  espie
 * Added SAMPLE_FAULT, for trying to play
 * a note without a sample (not really an error).
 *
 * Revision 2.2  1991/11/18  01:10:45  espie
 * Added some prototypes.
 *
 * Revision 2.1  1991/11/17  23:07:58  espie
 * Moved prototypes around, added new functions.
 *
 * Revision 2.0  1991/11/17  21:42:08  espie
 * Added prototypes for new functions.
 * Removed prototypes for some commands.
 *
 * Revision 1.7  1991/11/08  14:25:55  espie
 * Modified audio prototype so that you can change
 * frequency.
 *
 * Revision 1.6  1991/11/08  13:35:57  espie
 * Added prototype for release_song.
 *
 * Revision 1.5  1991/11/07  21:40:16  espie
 * Added arpeggio effect.
 *
 * Revision 1.4  1991/11/07  20:05:53  espie
 * Added entries for new effects.
 *
 * Revision 1.3  1991/11/06  09:46:06  espie
 * Added entries for commands.c.
 *
 * Revision 1.2  1991/11/04  13:23:59  espie
 * Moved some definitions from str32.
 * Added debug.
 *
 * Revision 1.1  1991/11/03  22:45:26  espie
 * Initial revision
 *
 */

/* str32.c */

/* error types. Everything is centralized,
 * and we check in some places (see read, player and str32)
 * that there was no error. Additionnally signal traps work
 * that way too.
 */
 
/* normal state */
#define NONE 0  
/* read error */
#define FILE_TOO_SHORT 1
#define CORRUPT_FILE 2
/* trap error: goto next song right now */
#define NEXT_SONG 3
/* run time problem */
#define FAULT 4
/* the song has ended */
#define ENDED 5
/* unrecoverable problem: typically, trying to 
 * jump to nowhere land.
 */
#define UNRECOVERABLE 6
/* Missing sample. Very common error, not too serious. */
#define SAMPLE_FAULT 7

extern int error;


/* xxx_audio.c */

/* real_freq = open_audio(ask_freq):
 * try to open audio with a sampling rate of ask_freq.
 * We get the real frequency back. If we ask for 0, we
 * get the ``preferred'' frequency.
 */
extern int open_audio();
/* close_audio():
 * returns the audio to the system control, doing necessary
 * cleanup
 */
extern void close_audio();
/* set_mix(percent): set mix channels level.
 * 0: spatial stereo. 100: mono.
 */
extern void set_mix();
/* output_samples(l, r): outputs a pair of stereo samples.
 * Samples are 15 bits signed.
 */
extern void output_samples();
/* flush_buffer(): call from time to time, because buffering
 * is done by the program to get better (?) performance.
 */
extern void flush_buffer();

/* automaton.c */

/* init_automaton(a, song):
 * put the automaton a in the right state to play song.
 */
extern void init_automaton();
/* next_tick(a):
 * set up everything for the next tick.
 */
extern void next_tick();

/* read.c */

/* s = read_song(f, type):
 * tries to read f as a song of type NEW/OLD.
 * returns NULL (and an error) if it doesn't work.
 * Returns a dynamic song structure if successful.
 */
extern struct song *read_song();

/* dump_song(s): 
 * displays some information pertinent to the given 
 * song s.
 */
extern void dump_song();

/* release_song(s):
 * release all the memory song occupies.
 */
extern void release_song();





/* commands.c */

/* init_effects(): sets up all data for the effects */
extern void init_effects();
/* do_nothing: this is the default behavior for an effect.
 */
extern void do_nothing();




/* audio.c */

/* init_tables(oversample, frequency):
 * precomputes the step_table and the pitch_table
 * according to the desired oversample and frequency.
 * This is static, you can call it again whenever you want.
 */
extern void init_tables();

/* pitch of each and every note */
extern int pitch_table[];

/* resample(chan, oversample, number):
 * send number samples out computed according
 * to the current state of chan[0:NUMBER_CHANNELS],
 * and oversample.
 */
extern void resample();

/* reset_note(ch, note, pitch):
 * set channel ch to play note at pitch pitch
 */
extern void reset_note();

/* set_current_pitch(ch, pitch):
 * set channel ch to play at pitch pitch
 */
extern void set_current_pitch();



/* player.c */

/* init_player(oversample, frequency):
 * sets up the player for a given oversample and
 * output frequency.
 */
extern void init_player();

/* play_song(song, pref):
 * plays the song according to the current pref.
 */
extern void play_song();


#define ACCURACY 16
#define fix_to_int(x) ((x) >> ACCURACY)
#define int_to_fix(x) ((x) << ACCURACY)


/* some definitions for being able to read song.h */

#define OLD 0
#define NEW 1
/* special new type: for when we try to read it as both types.
 */
#define BOTH 2
/* special type: does not check the signature */
#define NEW_NO_CHECK 3

#define NUMBER_NOTES 120

#define MIN(A,B) ((A)<(B) ? (A) : (B))
#define MAX(A,B) ((A)>(B) ? (A) : (B))
     
#define D fprintf(stderr, "%d\n", __LINE__);

