/* channel.h */

/* $Author: espie $
 * $Id: channel.h,v 2.3 1991/12/03 23:03:39 espie Exp $
 * $Revision: 2.3 $
 * $Log: channel.h,v $
 * Revision 2.3  1991/12/03  23:03:39  espie
 * Added transpose feature.
 *
 * Revision 2.2  1991/11/19  16:07:19  espie
 * Added comments, moved minor stuff around.
 *
 * Revision 2.1  1991/11/17  23:07:58  espie
 * Added some comments.
 *
 * Revision 2.0  1991/11/17  21:42:08  espie
 * Structured part of the code, especially replay ``automaton''
 * and setting up of effects.
 *
 * Revision 1.5  1991/11/16  16:54:19  espie
 * Added comments to each and every field.
 *
 * Revision 1.4  1991/11/16  15:42:43  espie
 * tabs.
 *
 * Revision 1.3  1991/11/09  17:47:33  espie
 * Bug correction: when doing arpeggio, there might not
 * be a new note, so we have to save the old note value
 * and do the arppeggio on that note.
 *
 * Revision 1.2  1991/11/07  21:40:16  espie
 * Added fields for arpeggio.
 *
 * Revision 1.1  1991/11/06  09:46:06  espie
 * Initial revision
 *
 *
 */

     
/* DO_NOTHING is also used for the automaton */
#define DO_NOTHING 0
#define PLAY 1
#define REPLAY 2
     
#define MAX_ARP 3
     
/* there is no note in each channel initially.
 * This is defensive programming, because some
 * commands rely on the previous note. Checking
 * that there was no previous note is a way to
 * detect faulty modules.
 */
#define NO_NOTE 255

struct channel
    {
    struct sample_info *samp;
    int mode;               /* automaton state for the sound generatio */
    unsigned int pointer;   /* current sample position (fixed pos) */
    unsigned int step;      /* sample position increment (gives pitch) */
    int volume;             /* current volume of the sample (0-64) */
    int pitch;              /* current pitch of the sample */
    int note;               /* we have to save the note cause */
                            /* we can do an arpeggio without a new note */
    
    int arp[MAX_ARP];       /* the three pitch values for an arpeggio */
    int arpindex;           /* an index to know which note the arpeggio is doing
                             */

    int viboffset;          /* current offset for vibrato (if any) */
    int vibdepth;           /* depth of vibrato (if any) */

    int slide;              /* step size of pitch slide */

    int pitchgoal;          /* pitch to slide to */
    int pitchrate;          /* step rate for portamento */

    int volumerate;         /* step rate for volume slide */

    int vibrate;            /* step rate for vibrato */
    void (*adjust)();       /* current command to adjust parameters */
    };

/* DO_NOTHING was already declared for the channel
   #define DO_NOTHING 0 */
#define SET_SPEED 1
#define SET_SKIP 2
#define SET_FASTSKIP 4

#define NORMAL_SPEED 6
#define NORMAL_FINESPEED 100

struct automaton
    {
    int pattern_num;            /* the pattern in the song */
    int note_num;               /* the note in the pattern */
    struct block *pattern;      /* the physical pattern */
    struct song_info *info;     /* we need the song_info */

    int counter;                /* the fine position inside the effect */
    int speed;                  /* the `speed', number of effect repeats */
    int finespeed;              /* the finespeed, base is 100 */

    int do_stuff;               /* keeping some stuff to do */
                                /* ... and parameters for it: */
    int new_speed, new_note, new_pattern, new_fastspeed;

    int pitch, note, para;      /* some extra parameters effects need */
    };
